/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.duck.Duck_PlayerTarget;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class TargetUtil {
    public static void updateBlockLookEffects(ServerPlayer player) {
        List<Triple> miningEnchantmentComponents = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), player.getMainHandItem()).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.TARGET_BLOCK_CHANGED).isEmpty()).map(entry -> Triple.of((Object)((Holder)entry.getKey()), (Object)((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.TARGET_BLOCK_CHANGED), (Object)entry.getIntValue())).toList();
        boolean changedAttributes = false;
        if (miningEnchantmentComponents.isEmpty() && ((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().isEmpty()) {
            return;
        }
        Vec3 startPos = player.getEyePosition();
        Vec3 endPos = startPos.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(player.blockInteractionRange()));
        BlockHitResult result = player.level().clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = result.getBlockPos();
        if (!miningEnchantmentComponents.isEmpty()) {
            LootParams.Builder params = new LootParams.Builder(player.serverLevel());
            params.withParameter(LootContextParams.BLOCK_STATE, (Object)player.level().getBlockState(pos));
            params.withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter());
            params.withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem());
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            params.withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)player.level().getBlockEntity(pos));
            for (Triple entry2 : miningEnchantmentComponents) {
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Integer)entry2.getRight()));
                LootContext context = new LootContext.Builder(params.create(EnchiridionLootContextParamSets.ENCHANTED_BLOCK)).create(Optional.empty());
                for (ConditionalEffect effect : (List)entry2.getMiddle()) {
                    if (effect.matches(context)) {
                        ((EnchantmentLocationBasedEffect)effect.effect()).onChangedBlock((ServerLevel)player.level(), ((Integer)entry2.getRight()).intValue(), new EnchantedItemInUse(player.getMainHandItem(), EquipmentSlot.MAINHAND, (LivingEntity)player), (Entity)player, pos.getCenter(), !((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().containsKey(entry2.getLeft()) || !((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().get(entry2.getLeft()).contains(effect.effect()));
                        if (!changedAttributes) {
                            changedAttributes = effect.effect() instanceof EnchantmentAttributeEffect && !((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().containsKey(entry2.getLeft()) || !((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().get(entry2.getLeft()).contains(effect.effect());
                        }
                        ((Duck_PlayerTarget)player).enchiridion$addActiveBlockTargetEnchantmentEffect((Holder<Enchantment>)((Holder)entry2.getLeft()), (EnchantmentLocationBasedEffect)effect.effect());
                        continue;
                    }
                    if (!((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().containsKey(entry2.getLeft()) || !((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().get(entry2.getLeft()).contains(effect.effect())) continue;
                    ((Duck_PlayerTarget)player).enchiridion$removeActiveBlockTargetEnchantmentEffect((Holder<Enchantment>)((Holder)entry2.getLeft()), (EnchantmentLocationBasedEffect)effect.effect());
                    ((EnchantmentLocationBasedEffect)effect.effect()).onDeactivated(new EnchantedItemInUse(player.getMainHandItem(), EquipmentSlot.MAINHAND, (LivingEntity)player), (Entity)player, pos.getCenter(), ((Integer)entry2.getRight()).intValue());
                    if (changedAttributes) continue;
                    changedAttributes = effect.effect() instanceof EnchantmentAttributeEffect;
                }
            }
        } else if (!((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().isEmpty()) {
            for (Holder holder : ((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().keySet()) {
                Set<EnchantmentLocationBasedEffect> effects = ((Duck_PlayerTarget)player).enchiridion$activeBlockTargetEnchantmentEffects().remove(holder);
                if (effects == null) continue;
                for (EnchantmentLocationBasedEffect effect : effects) {
                    effect.onDeactivated(new EnchantedItemInUse(player.getMainHandItem(), EquipmentSlot.MAINHAND, (LivingEntity)player), (Entity)player, pos.getCenter(), Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), player.getMainHandItem()).getLevel(holder));
                    if (changedAttributes) continue;
                    changedAttributes = effect instanceof EnchantmentAttributeEffect;
                }
            }
        }
        if (changedAttributes && !player.getAttributes().getAttributesToSync().isEmpty()) {
            ClientboundUpdateAttributesPacket packet = new ClientboundUpdateAttributesPacket(player.getId(), (Collection)player.getAttributes().getAttributesToSync());
            for (ServerPlayer others : Enchiridion.getHelper().getTracking((Entity)player)) {
                others.connection.send((Packet)packet);
            }
            player.connection.send((Packet)packet);
            player.getAttributes().getAttributesToSync().clear();
        }
    }
}

