/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.alivecombat.handler;

import com.xm666.alivecombat.Config;
import com.xm666.alivecombat.util.Logger;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class FakeSweepHandler {
    private static final RandomSource random = RandomSource.create();

    private static boolean canSweep(Entity target) {
        double d1;
        double d0;
        boolean critBlocksSweep;
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        float f2 = player.getAttackStrengthScale(0.5f);
        boolean flag3 = f2 > 0.9f;
        boolean flag = player.isSprinting() && flag3;
        boolean flag1 = flag3 && player.fallDistance > 0.0 && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.isMobilityRestricted() && !player.isPassenger() && target instanceof LivingEntity && !player.isSprinting();
        CriticalHitEvent critEvent = CommonHooks.fireCriticalHit((Player)player, (Entity)target, (boolean)flag1, (float)(flag1 ? 1.5f : 1.0f));
        boolean flag2 = false;
        boolean bl = critBlocksSweep = critEvent.isCriticalHit() && critEvent.disableSweep();
        if (flag3 && !critBlocksSweep && !flag && player.onGround() && (d0 = player.getKnownMovement().horizontalDistanceSqr()) < Mth.square((double)(d1 = (double)player.getSpeed() * 2.5)) && player.getItemInHand(InteractionHand.MAIN_HAND).canPerformAction(ItemAbilities.SWORD_SWEEP)) {
            flag2 = true;
        }
        return flag2;
    }

    private static void sweep() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.level().playSound((Entity)player, player.getX(), player.getY(), player.getZ(), FakeSweepHandler.getSoundEvent(), player.getSoundSource(), 1.0f, 1.0f);
            FakeSweepHandler.sweepAttack();
        }
    }

    private static void sweepAttack() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            double d0 = -Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            FakeSweepHandler.sendParticles(FakeSweepHandler.getParticleType(), player.getX() + d0, player.getY(0.5), player.getZ() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    private static <T extends ParticleOptions> void sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        BlockPos blockpos = Objects.requireNonNull(Minecraft.getInstance().player).blockPosition();
        if (blockpos.closerToCenterThan((Position)new Vec3(posX, posY, posZ), 32.0)) {
            if (particleCount == 0) {
                double d0 = speed * xOffset;
                double d2 = speed * yOffset;
                double d4 = speed * zOffset;
                try {
                    Objects.requireNonNull(Minecraft.getInstance().level).addParticle(type, false, false, posX, posY, posZ, d0, d2, d4);
                }
                catch (Throwable throwable) {
                    Logger.warn("Could not spawn particle effect {}", type);
                }
            } else {
                for (int i = 0; i < particleCount; ++i) {
                    double d1 = random.nextGaussian() * xOffset;
                    double d3 = random.nextGaussian() * yOffset;
                    double d5 = random.nextGaussian() * zOffset;
                    double d6 = random.nextGaussian() * speed;
                    double d7 = random.nextGaussian() * speed;
                    double d8 = random.nextGaussian() * speed;
                    try {
                        Objects.requireNonNull(Minecraft.getInstance().level).addParticle(type, false, false, posX + d1, posY + d3, posZ + d5, d6, d7, d8);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Logger.warn("Could not spawn particle effect {}", type);
                        return;
                    }
                }
            }
        }
    }

    private static SoundEvent getSoundEvent() {
        String type = "entity.player.attack.sweep";
        return (SoundEvent)((Holder.Reference)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)type)).get()).value();
    }

    private static SimpleParticleType getParticleType() {
        String type = "minecraft:sweep_attack";
        return (SimpleParticleType)((Holder.Reference)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)type)).get()).value();
    }

    @EventBusSubscriber(modid="alivecombat", value={Dist.CLIENT})
    public static class FakeSweepHandlerConfig {
        @SubscribeEvent
        static void onModConfigLoading(ModConfigEvent.Loading event) {
            FakeSweepHandlerConfig.toggle();
        }

        @SubscribeEvent
        static void onModConfigReloading(ModConfigEvent.Reloading event) {
            FakeSweepHandlerConfig.toggle();
        }

        static void toggle() {
            if (((Boolean)Config.FAKE_SWEEP_ENABLED.get()).booleanValue()) {
                NeoForge.EVENT_BUS.register(FakeSweepHandlerClient.class);
            } else {
                NeoForge.EVENT_BUS.unregister(FakeSweepHandlerClient.class);
            }
        }
    }

    public static class FakeSweepHandlerClient {
        @SubscribeEvent
        static void onAttackEntity(AttackEntityEvent event) {
            ItemStack weaponItem;
            Set tags;
            Player player = event.getEntity();
            if (player.level().isClientSide() && (tags = (weaponItem = player.getWeaponItem()).getTags().map(TagKey::location).map(ResourceLocation::toString).collect(Collectors.toSet())).contains("c:tools/melee_weapon") && !FakeSweepHandler.canSweep(event.getTarget())) {
                FakeSweepHandler.sweep();
            }
        }
    }
}

