/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.alivecombat.handler;

import com.xm666.alivecombat.Config;
import com.xm666.alivecombat.util.Logger;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

public class FakeSweepHandler {
    private static final RandomSource random = RandomSource.create();

    private static void sweep() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.level().playSound((Player)player, player.getX(), player.getY(), player.getZ(), FakeSweepHandler.getSoundEvent(), player.getSoundSource(), 1.0f, 1.0f);
            FakeSweepHandler.sweepAttack();
        }
    }

    private static void sweepAttack() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            double d0 = -Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            FakeSweepHandler.sendParticles(player.getX() + d0, player.getY(0.5), player.getZ() + d1, d0, d1);
        }
    }

    private static void sendParticles(double posX, double posY, double posZ, double xOffset, double zOffset) {
        ClientboundLevelParticlesPacket clientboundlevelparticlespacket = new ClientboundLevelParticlesPacket((ParticleOptions)FakeSweepHandler.getParticleType(), false, posX, posY, posZ, (float)xOffset, 0.0f, (float)zOffset, 0.0f, 0);
        FakeSweepHandler.handle(clientboundlevelparticlespacket);
    }

    private static void handle(ClientboundLevelParticlesPacket packet) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Level level = player.level();
            if (packet.getCount() == 0) {
                double d0 = packet.getMaxSpeed() * packet.getXDist();
                double d2 = packet.getMaxSpeed() * packet.getYDist();
                double d4 = packet.getMaxSpeed() * packet.getZDist();
                try {
                    level.addParticle(packet.getParticle(), packet.isOverrideLimiter(), packet.getX(), packet.getY(), packet.getZ(), d0, d2, d4);
                }
                catch (Throwable throwable) {
                    Logger.warn("Could not spawn particle effect {}", packet.getParticle());
                }
            } else {
                for (int i = 0; i < packet.getCount(); ++i) {
                    double d1 = random.nextGaussian() * (double)packet.getXDist();
                    double d3 = random.nextGaussian() * (double)packet.getYDist();
                    double d5 = random.nextGaussian() * (double)packet.getZDist();
                    double d6 = random.nextGaussian() * (double)packet.getMaxSpeed();
                    double d7 = random.nextGaussian() * (double)packet.getMaxSpeed();
                    double d8 = random.nextGaussian() * (double)packet.getMaxSpeed();
                    try {
                        level.addParticle(packet.getParticle(), packet.isOverrideLimiter(), packet.getX() + d1, packet.getY() + d3, packet.getZ() + d5, d6, d7, d8);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Logger.warn("Could not spawn particle effect {}", packet.getParticle());
                        return;
                    }
                }
            }
        }
    }

    private static SoundEvent getSoundEvent() {
        String type = "entity.player.attack.sweep";
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.tryParse((String)type));
    }

    private static SimpleParticleType getParticleType() {
        String type = "minecraft:sweep_attack";
        return (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)type));
    }

    @EventBusSubscriber(modid="alivecombat", value={Dist.CLIENT})
    public static class FakeSweepHandlerConfig {
        @SubscribeEvent
        static void onModConfigLoading(ModConfigEvent.Loading event) {
            FakeSweepHandlerConfig.toggle();
        }

        @SubscribeEvent
        static void onModConfigReloading(ModConfigEvent.Reloading event) {
            FakeSweepHandlerConfig.toggle();
        }

        static void toggle() {
            if (((Boolean)Config.FAKE_SWEEP_ENABLED.get()).booleanValue()) {
                NeoForge.EVENT_BUS.register(FakeSweepHandlerClient.class);
            } else {
                NeoForge.EVENT_BUS.unregister(FakeSweepHandlerClient.class);
            }
        }
    }

    public static class FakeSweepHandlerClient {
        @SubscribeEvent
        static void onAttackEntity(AttackEntityEvent event) {
            ItemStack weaponItem;
            Set tags;
            Player player = event.getEntity();
            if (player.level().isClientSide && (tags = (weaponItem = player.getWeaponItem()).getTags().map(TagKey::location).map(ResourceLocation::toString).collect(Collectors.toSet())).contains("c:tools/melee_weapon")) {
                FakeSweepHandler.sweep();
            }
        }
    }
}

