/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block;

import com.comphenix.protocol.utility.MinecraftReflection;
import hasjamon.block4block.command.ChickenBonusCommand;
import hasjamon.block4block.command.ClaimContestCommand;
import hasjamon.block4block.command.ClaimFixCommand;
import hasjamon.block4block.command.ClaimLocCommand;
import hasjamon.block4block.command.ClaimVisualCommand;
import hasjamon.block4block.command.CoordsCommand;
import hasjamon.block4block.command.DieCommand;
import hasjamon.block4block.command.HelpCommand;
import hasjamon.block4block.command.HintsCommand;
import hasjamon.block4block.command.IgnoreCommand;
import hasjamon.block4block.command.WelcomeCommand;
import hasjamon.block4block.files.ConfigManager;
import hasjamon.block4block.listener.BlackBearEgg;
import hasjamon.block4block.listener.BlockBreak;
import hasjamon.block4block.listener.BlockFertilize;
import hasjamon.block4block.listener.BlockPlace;
import hasjamon.block4block.listener.BlockSpread;
import hasjamon.block4block.listener.BookEdit;
import hasjamon.block4block.listener.BookPlaceTake;
import hasjamon.block4block.listener.BookReadLectern;
import hasjamon.block4block.listener.ChunkLoad;
import hasjamon.block4block.listener.ClaimVisual;
import hasjamon.block4block.listener.ComplimentaryBed;
import hasjamon.block4block.listener.CraftItem;
import hasjamon.block4block.listener.CreatureSpawn;
import hasjamon.block4block.listener.EggLay;
import hasjamon.block4block.listener.EntityChangeBlock;
import hasjamon.block4block.listener.EntityDropItem;
import hasjamon.block4block.listener.EquipPlayerHead;
import hasjamon.block4block.listener.Explode;
import hasjamon.block4block.listener.ExplosionPrime;
import hasjamon.block4block.listener.FreecamInteract;
import hasjamon.block4block.listener.LavaCasting;
import hasjamon.block4block.listener.LecternBreak;
import hasjamon.block4block.listener.MapCraft;
import hasjamon.block4block.listener.MapUseOnLectern;
import hasjamon.block4block.listener.PlayerChangedWorld;
import hasjamon.block4block.listener.PlayerChat;
import hasjamon.block4block.listener.PlayerDeath;
import hasjamon.block4block.listener.PlayerFish;
import hasjamon.block4block.listener.PlayerHarvestBlock;
import hasjamon.block4block.listener.PlayerJoin;
import hasjamon.block4block.listener.PlayerLavaDamage;
import hasjamon.block4block.listener.PlayerMove;
import hasjamon.block4block.listener.PlayerQuit;
import hasjamon.block4block.listener.PlayerRespawn;
import hasjamon.block4block.listener.PlayerStonecutter;
import hasjamon.block4block.listener.PlayerToggleGlide;
import hasjamon.block4block.listener.ShovelUse;
import hasjamon.block4block.listener.SpawnEggThrow;
import hasjamon.block4block.utils.utils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Block4Block
extends JavaPlugin {
    public PluginManager pluginManager = this.getServer().getPluginManager();
    public ConfigManager cfg;
    private static Block4Block instance;
    private ClaimVisual claimVisual;
    private List<?> hints;
    private int nextHint = 0;
    private ClaimContestCommand claimContestCommandInstance;

    public static Block4Block getInstance() {
        return instance;
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        instance = this;
        this.checkReflectionAvailability();
        this.cfg = new ConfigManager();
        this.getLogger().info("Loaded claim-protection config: " + String.valueOf(this.cfg.getClaimData().getStringList("claim-protection.protective-block-faces")));
        this.populateKnownPlayers();
        this.populateConfigConstants();
        this.claimVisual = new ClaimVisual(this);
        this.claimContestCommandInstance = new ClaimContestCommand(this);
        this.registerEvents();
        this.setCommandExecutors();
        this.setupHints();
        if (this.getCommand("claimvisual") != null) {
            this.getCommand("claimvisual").setExecutor((CommandExecutor)new ClaimVisualCommand(this, this.claimVisual.getVisualEnabledPlayers()));
        }
        if (this.getConfig().getBoolean("golems-guard-claims")) {
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, utils::updateGolemHostility, 0L, 20L);
        }
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, utils::updateCurrentTick, 0L, 1L);
        utils.minSecBetweenAlerts = this.getConfig().getInt("seconds-between-intruder-alerts");
        utils.claimWidth = this.getConfig().getInt("claim-width");
        utils.lavaFlowMaxY = this.getConfig().getInt("lava-flow-max-y");
        utils.gracePeriod = this.getConfig().getInt("b4b-grace-period");
        if (this.getConfig().getBoolean("enable-claim-maps")) {
            this.addMapRenderers();
        }
    }

    private void checkReflectionAvailability() {
        try {
            MinecraftReflection.getCraftPlayerClass().getDeclaredMethod("getProfile", new Class[0]);
        }
        catch (NoClassDefFoundError | NoSuchMethodException e) {
            utils.canUseReflection = false;
            this.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "Reflection is unavailable; some features have been disabled.");
        }
    }

    private void setupHints() {
        this.hints = this.getConfig().getList("hints");
        long interval = this.getConfig().getLong("seconds-between-hints");
        boolean hintsEnabled = this.getConfig().getBoolean("hints-enabled");
        if (this.hints != null && hintsEnabled) {
            Collections.shuffle(this.hints);
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::showHint, 0L, 20L * interval);
        }
    }

    private void showHint() {
        if (++this.nextHint >= this.hints.size()) {
            this.nextHint = 0;
        }
        String hint = (String)this.hints.get(this.nextHint);
        FileConfiguration hintSettings = this.cfg.getHintSettings();
        for (Player p : Bukkit.getOnlinePlayers()) {
            String pUUID = p.getUniqueId().toString();
            String pSettings = hintSettings.getString(pUUID);
            if (pSettings != null && !pSettings.equals("on")) continue;
            p.sendMessage(utils.chat(hint));
        }
    }

    private void setCommandExecutors() {
        PluginCommand dieCmd = this.getCommand("die");
        PluginCommand hintsCmd = this.getCommand("hints");
        PluginCommand helpCmd = this.getCommand("b4bhelp");
        PluginCommand ignoreCmd = this.getCommand("ignore");
        PluginCommand unignoreCmd = this.getCommand("unignore");
        PluginCommand claimContestCmd = this.getCommand("claimcontest");
        PluginCommand welcomeCmd = this.getCommand("welcome");
        PluginCommand claimLocCmd = this.getCommand("claimloc");
        PluginCommand claimFixCmd = this.getCommand("claimfix");
        PluginCommand chickenBonusCmd = this.getCommand("chickenbonus");
        PluginCommand coordsCmd = this.getCommand("coords");
        PluginCommand claimVisualCmd = this.getCommand("claimvisual");
        if (dieCmd != null) {
            dieCmd.setExecutor((CommandExecutor)new DieCommand());
        }
        if (hintsCmd != null) {
            hintsCmd.setExecutor((CommandExecutor)new HintsCommand(this));
        }
        if (helpCmd != null) {
            helpCmd.setExecutor((CommandExecutor)new HelpCommand(this));
        }
        if (ignoreCmd != null && unignoreCmd != null) {
            IgnoreCommand cmd = new IgnoreCommand(this);
            ignoreCmd.setExecutor((CommandExecutor)cmd);
            unignoreCmd.setExecutor((CommandExecutor)cmd);
        }
        if (claimContestCmd != null) {
            claimContestCmd.setExecutor((CommandExecutor)this.claimContestCommandInstance);
        } else {
            this.getLogger().severe("Command 'claimcontest' not found in plugin.yml! ClaimContest command executor will not work.");
        }
        if (welcomeCmd != null) {
            welcomeCmd.setExecutor((CommandExecutor)new WelcomeCommand());
        }
        if (claimLocCmd != null) {
            claimLocCmd.setExecutor((CommandExecutor)new ClaimLocCommand(this));
        }
        if (claimFixCmd != null) {
            claimFixCmd.setExecutor((CommandExecutor)new ClaimFixCommand(this));
        }
        if (chickenBonusCmd != null) {
            chickenBonusCmd.setExecutor((CommandExecutor)new ChickenBonusCommand(this));
        }
        if (coordsCmd != null) {
            coordsCmd.setExecutor((CommandExecutor)new CoordsCommand(this));
        }
        if (claimVisualCmd != null) {
            claimVisualCmd.setExecutor((CommandExecutor)new ClaimVisualCommand(this, this.claimVisual.getVisualEnabledPlayers()));
        }
    }

    private void registerEvents() {
        this.pluginManager.registerEvents((Listener)this.claimContestCommandInstance, (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BookPlaceTake(this, this.claimContestCommandInstance), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlockBreak(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new LecternBreak(this), (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.pluginManager.registerEvents((Listener)new BookReadLectern(this), (Plugin)this);
        } else {
            this.getLogger().info("ProtocolLib not found - skipping BookReadLectern.");
        }
        this.pluginManager.registerEvents((Listener)new BookEdit(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlockPlace(this), (Plugin)this);
        if (this.getConfig().getBoolean("balance-lavacasting")) {
            this.pluginManager.registerEvents((Listener)new LavaCasting(), (Plugin)this);
        }
        if (this.getConfig().getBoolean("chickens-lay-spawn-eggs")) {
            this.pluginManager.registerEvents((Listener)new EggLay(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("destroy-fishing-rods")) {
            this.pluginManager.registerEvents((Listener)new PlayerFish(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("block-stonecutter")) {
            this.pluginManager.registerEvents((Listener)new PlayerStonecutter(this), (Plugin)this);
        }
        this.pluginManager.registerEvents((Listener)new EntityDropItem(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new CreatureSpawn(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerChat(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerMove(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerQuit(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerDeath(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ComplimentaryBed(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)this.claimVisual, (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerRespawn(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ChunkLoad(), (Plugin)this);
        if (this.getConfig().getBoolean("disable-freecam-interactions")) {
            this.pluginManager.registerEvents((Listener)new FreecamInteract(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("enable-lava-immunity")) {
            this.pluginManager.registerEvents((Listener)new PlayerLavaDamage(this), (Plugin)this);
        }
        this.pluginManager.registerEvents((Listener)new Explode(this), (Plugin)this);
        if (this.getConfig().getBoolean("enable-disguises")) {
            this.pluginManager.registerEvents((Listener)new EquipPlayerHead(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("enable-claim-maps")) {
            this.pluginManager.registerEvents((Listener)new MapUseOnLectern(this), (Plugin)this);
        }
        this.pluginManager.registerEvents((Listener)new MapCraft(), (Plugin)this);
        if (this.getConfig().getBoolean("enable-path-grace-period")) {
            this.pluginManager.registerEvents((Listener)new ShovelUse(), (Plugin)this);
        }
        this.pluginManager.registerEvents((Listener)new EntityChangeBlock(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new CraftItem(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerHarvestBlock(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlockFertilize(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlockSpread(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerToggleGlide(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerChangedWorld(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ExplosionPrime(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlackBearEgg(new NamespacedKey((Plugin)this, "black_bear_spawn_egg")), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new SpawnEggThrow(new NamespacedKey((Plugin)this, "custom_spawn_egg")), (Plugin)this);
    }

    private void addMapRenderers() {
        FileConfiguration claimMaps = this.cfg.getClaimMaps();
        Set mapIDs = claimMaps.getKeys(false);
        for (String id : mapIDs) {
            MapView view = Bukkit.getMap((int)Integer.parseInt(id));
            String uuid = claimMaps.getString(id);
            if (view != null && uuid != null && view.getRenderers().size() == 1) {
                OfflinePlayer mapCreator = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
                view.addRenderer(utils.createClaimRenderer(mapCreator));
                view.addRenderer(utils.createIntruderRenderer(mapCreator));
                continue;
            }
            claimMaps.set(id, null);
        }
        this.cfg.saveClaimMaps();
    }

    private void populateConfigConstants() {
        this.populateNonProtectiveBlockTypes();
        this.populateProtectiveBlockFaces();
    }

    private void populateKnownPlayers() {
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            if (p == null || p.getName() == null) continue;
            utils.knownPlayers.add(p.getName().toLowerCase());
        }
    }

    private void populateNonProtectiveBlockTypes() {
        List<Material> blockTypes = this.getConfig().getStringList("claim-protection.nonprotective-blocks").stream().map(Material::valueOf).toList();
        utils.nonProtectiveBlockTypes.addAll(blockTypes);
    }

    private void populateProtectiveBlockFaces() {
        List<BlockFace> blockFaces = this.getConfig().getStringList("claim-protection.protective-block-faces").stream().map(BlockFace::valueOf).toList();
        utils.protectiveBlockFaces.addAll(blockFaces);
    }
}

