/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.ChickenBonuses;
import hasjamon.block4block.utils.utils;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ChickenBonusCommand
implements CommandExecutor {
    private final Block4Block plugin;

    public ChickenBonusCommand(Block4Block plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            int radius = this.plugin.getConfig().getInt("named-chicken-radius");
            ChickenBonuses bonuses = utils.calcChickenBonuses((Entity)player);
            Map<Character, Integer> letterBonuses = bonuses.letterBonuses;
            int numNamedChickens = bonuses.numNamedChickens;
            double spawnChance = this.plugin.getConfig().getDouble("spawn-egg-chance");
            double withBonus = spawnChance * utils.calcGeneralChickenBonus(numNamedChickens);
            player.sendMessage("\u00a77Unique coords with named chickens within " + radius + " blocks: " + numNamedChickens);
            player.sendMessage("\u00a77Chance to lay a spawn egg: " + Math.floor(withBonus * 10000.0) / 100.0 + "%");
            player.sendMessage("\u00a77Letter bonuses: " + letterBonuses.toString());
            return true;
        }
        return false;
    }
}

