/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.ClaimContestOverEvent;
import hasjamon.block4block.events.ContestChunkClaimedEvent;
import hasjamon.block4block.utils.utils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class ClaimContestCommand
implements CommandExecutor,
TabCompleter,
Listener {
    private final Block4Block plugin;
    private final FileConfiguration claimContestConfig;
    private final FileConfiguration claimDataConfig;
    private final ScoreboardManager scoreboardManager;
    private final BukkitScheduler scheduler;
    private final PluginManager pluginManager;
    private final int PROXIMITY_RADIUS_CHUNKS;
    private BukkitTask mainTask;
    private Phase currentPhase = Phase.PENDING;
    private String currentContestClaimId = null;
    private String currentHolderName = "None";
    private long contestStartTimeMillis = -1L;
    private long contestEndTimeMillis = -1L;
    private final AtomicLong holdEndTimeMillis = new AtomicLong(-1L);
    private boolean contestEnded = false;
    private boolean modePreReveal = false;
    private boolean modeHold = false;
    private long preRevealDurationMillis = 0L;
    private long holdDurationMillis = 0L;
    private long contestDurationMillis = 0L;
    private static final String DATA_SECTION = "data";
    private static final String HISTORY_SECTION = "history";
    private static final String CHUNK_LOC_KEY = "chunkLoc";
    private static final String CLAIM_ID_KEY = "claimID";
    private static final String DURATION_KEY = "duration";
    private static final String PRIZE_KEY = "prize";
    private static final String COMMAND_START_TIMESTAMP_KEY = "command-start-timestamp";
    private static final String START_TIMESTAMP_KEY = "active-phase-start-timestamp";
    private static final String CONFIG_SAVE_TIMESTAMP_KEY = "config-save-timestamp";
    private static final String CURRENT_CLAIMANT_KEY = "current-claimant";
    private static final String CURRENT_HOLDER_KEY = "current-holder";
    private static final String PHASE_KEY = "current-phase";
    private static final String PRE_REVEAL_END_TIMESTAMP_KEY = "pre-reveal-end-timestamp";
    private static final String CONTEST_END_TIMESTAMP_KEY = "contest-end-timestamp";
    private static final String HOLD_END_TIMESTAMP_KEY = "hold-end-timestamp";
    private static final String MODE_PRE_REVEAL_KEY = "mode.pre-reveal.enabled";
    private static final String MODE_HOLD_KEY = "mode.hold.enabled";
    private static final String DURATION_PRE_REVEAL_KEY = "mode.pre-reveal.duration";
    private static final String DURATION_HOLD_KEY = "mode.hold.duration";
    private static final long DEFAULT_PRE_REVEAL_MINUTES = 2L;
    private static final long DEFAULT_HOLD_MINUTES = 5L;
    private static final String NO_CLAIMANT = "None";
    private static final String SCOREBOARD_OBJECTIVE_NAME = "b4bcontest";
    private static final String SCOREBOARD_TITLE = String.valueOf(ChatColor.GOLD) + "Claim Contest";
    private static final String TEAM_CLAIMANT = "b4bclaimant_team";
    private static final String TEAM_DEFENDER = "b4bdefender_team";
    private static final String TEAM_INTRUDER = "b4bintruder_team";
    private static final DateTimeFormatter HISTORY_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MMM-dd_HH-mm-ss");
    private static final String HISTORY_START_DATE_KEY = "start-date";
    private static final String HISTORY_END_DATE_KEY = "end-date";
    private static final String HISTORY_CALCULATED_DURATION_KEY = "calculated-duration";
    private static final long TICKS_PER_SECOND = 20L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private final Map<UUID, Long> teamUpdateCooldowns = new HashMap<UUID, Long>();
    private static final long TEAM_UPDATE_COOLDOWN_MILLIS = 2000L;

    public ClaimContestCommand(Block4Block plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
        this.claimContestConfig = plugin.cfg.getClaimContest();
        this.claimDataConfig = plugin.cfg.getClaimData();
        this.scoreboardManager = Bukkit.getScoreboardManager();
        this.scheduler = Bukkit.getScheduler();
        this.pluginManager = Bukkit.getPluginManager();
        this.PROXIMITY_RADIUS_CHUNKS = plugin.getConfig().getInt("claim-width") + plugin.getConfig().getInt("claim-contest-radius");
        Objects.requireNonNull(this.claimContestConfig, "ClaimContest config cannot be null");
        Objects.requireNonNull(this.claimDataConfig, "ClaimData config cannot be null");
        Objects.requireNonNull(this.scoreboardManager, "ScoreboardManager cannot be null");
        Objects.requireNonNull(this.scheduler, "Scheduler cannot be null");
        Objects.requireNonNull(this.pluginManager, "PluginManager cannot be null");
        this.pluginManager.registerEvents((Listener)this, (Plugin)plugin);
        this.loadAndResumeContest();
    }

    public String getCurrentContestClaimId() {
        return this.currentContestClaimId;
    }

    public Phase getCurrentPhase() {
        return this.currentPhase;
    }

    public boolean isModeHold() {
        return this.modeHold;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendCurrentContestStatus(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        boolean configLocked = this.currentPhase != Phase.PENDING && this.currentPhase != Phase.FINISHED;
        List<String> configCommands = Arrays.asList("chunk", "loc", "at", "xyz", DURATION_KEY, "time", PRIZE_KEY, "mode");
        if (configLocked && configCommands.contains(subCommand)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot change configuration while a contest is active (" + String.valueOf((Object)this.currentPhase) + "). Use /claimcontest cancel first.");
            return true;
        }
        try {
            boolean success = false;
            switch (subCommand) {
                case "help": {
                    success = this.handleHelpCommand(player);
                    break;
                }
                case "chunk": 
                case "loc": 
                case "at": 
                case "xyz": {
                    success = this.handleChunkCommand(player, args);
                    break;
                }
                case "duration": 
                case "time": {
                    success = this.handleDurationCommand(player, args);
                    break;
                }
                case "prize": {
                    success = this.handlePrizeCommand(player, args);
                    break;
                }
                case "mode": {
                    success = this.handleModeCommand(player, args);
                    break;
                }
                case "start": {
                    success = this.handleStartCommand(player);
                    break;
                }
                case "cancel": {
                    success = this.handleCancelCommand(player);
                    break;
                }
                case "status": {
                    success = this.sendCurrentContestStatus(player);
                    break;
                }
                default: {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use '/" + label + " help'.");
                    return false;
                }
            }
            if (success && !subCommand.equals("start") && !subCommand.equals("cancel") && !subCommand.equals("status")) {
                this.setDataValue(CONFIG_SAVE_TIMESTAMP_KEY, System.currentTimeMillis());
                this.plugin.cfg.saveClaimContest();
                this.sendCurrentContestStatus(player);
            }
            return success;
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number provided: " + e.getMessage());
            return false;
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid argument: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An unexpected error occurred. Check server logs.");
            this.plugin.getLogger().severe("Error executing ClaimContestCommand: " + e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    private boolean handleHelpCommand(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Claim Contest Help ---");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest chunk <world> <x> <z> " + String.valueOf(ChatColor.WHITE) + "- Set location.");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest duration <time> " + String.valueOf(ChatColor.WHITE) + "- Set overall duration (if not using hold mode, e.g., 1h 30m).");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest prize <text> " + String.valueOf(ChatColor.WHITE) + "- Set prize.");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest mode <flag> [value] " + String.valueOf(ChatColor.WHITE) + "- Toggle/set modes:");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  pre_reveal [time] " + String.valueOf(ChatColor.WHITE) + "- Enable/set pre-reveal phase (e.g., 5m).");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  hold [time] " + String.valueOf(ChatColor.WHITE) + "- Enable/set hold phase (e.g., 10m).");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "  standard " + String.valueOf(ChatColor.WHITE) + "- Disable special modes (uses main duration).");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest start " + String.valueOf(ChatColor.WHITE) + "- Start the contest.");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest cancel " + String.valueOf(ChatColor.WHITE) + "- Cancel the current contest.");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "/claimcontest status " + String.valueOf(ChatColor.WHITE) + "- Show current status/config.");
        return true;
    }

    private boolean handleChunkCommand(Player player, String[] args) {
        String chunkDisplayName;
        World.Environment environment;
        String dimensionNameInput;
        if (args.length < 4) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimcontest chunk <overworld|nether|end> <x> <z>");
            return false;
        }
        switch (dimensionNameInput = args[1].toLowerCase()) {
            case "overworld": {
                environment = World.Environment.NORMAL;
                chunkDisplayName = "Overworld";
                break;
            }
            case "nether": {
                environment = World.Environment.NETHER;
                chunkDisplayName = "The Nether";
                break;
            }
            case "end": {
                environment = World.Environment.THE_END;
                chunkDisplayName = "The End";
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid dimension: " + args[1] + ". Use overworld, nether, or end.");
                return false;
            }
        }
        try {
            int x = Integer.parseInt(args[2]);
            int z = Integer.parseInt(args[3]);
            String chunkLocString = chunkDisplayName + " (X: " + x + ", Z: " + z + ")";
            String claimId = utils.getClaimID(x, z, environment);
            if (claimId == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to generate claim ID for the specified location.");
                return true;
            }
            this.setDataValue(CHUNK_LOC_KEY, chunkLocString);
            this.setDataValue(CLAIM_ID_KEY, claimId);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Contest location set to: " + chunkLocString);
            return true;
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid coordinates: X and Z must be numbers.");
            return false;
        }
    }

    private boolean handleDurationCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimcontest duration <time> (e.g., 1d 2h 30m)");
            return false;
        }
        long durationMillis = this.parseTimeArgument(Arrays.copyOfRange(args, 1, args.length));
        if (durationMillis < 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time format. Use #d, #h, #m (e.g., 1d 2h 30m).");
            return false;
        }
        if (durationMillis == 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Standard duration must be positive.");
            return true;
        }
        this.setDataValue(DURATION_KEY, durationMillis);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Contest standard duration set to: " + this.formatDuration(durationMillis));
        return true;
    }

    private boolean handlePrizeCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimcontest prize <description...>");
            return false;
        }
        String prizeDescription = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        prizeDescription = ChatColor.translateAlternateColorCodes((char)'&', (String)prizeDescription);
        this.setDataValue(PRIZE_KEY, prizeDescription);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Contest prize set to: " + prizeDescription);
        return true;
    }

    private boolean handleModeCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimcontest mode <pre_reveal|hold|standard> [time]");
            return false;
        }
        String flag = args[1].toLowerCase();
        long timeValueMillis = -1L;
        if (args.length > 2) {
            timeValueMillis = this.parseTimeArgument(Arrays.copyOfRange(args, 2, args.length));
            if (timeValueMillis < 0L) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time format for mode duration. Use #d, #h, #m.");
                return false;
            }
            if (timeValueMillis == 0L && !flag.equals("standard")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Mode duration must be positive.");
                return true;
            }
        }
        switch (flag) {
            case "pre_reveal": {
                boolean enabledPre;
                boolean bl = enabledPre = timeValueMillis != 0L;
                if (enabledPre && timeValueMillis <= 0L) {
                    timeValueMillis = 120000L;
                }
                this.setDataValue(MODE_PRE_REVEAL_KEY, enabledPre);
                this.setDataValue(DURATION_PRE_REVEAL_KEY, enabledPre ? timeValueMillis : 0L);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Pre-Reveal mode " + (String)(enabledPre ? "enabled (" + this.formatDuration(timeValueMillis) + ")" : "disabled."));
                break;
            }
            case "hold": {
                boolean enabledHold;
                boolean bl = enabledHold = timeValueMillis != 0L;
                if (enabledHold && timeValueMillis <= 0L) {
                    timeValueMillis = 300000L;
                }
                this.setDataValue(MODE_HOLD_KEY, enabledHold);
                this.setDataValue(DURATION_HOLD_KEY, enabledHold ? timeValueMillis : 0L);
                if (enabledHold) {
                    this.setDataValue(DURATION_KEY, 0L);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Standard duration disabled as Hold mode is active.");
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Hold mode " + (String)(enabledHold ? "enabled (" + this.formatDuration(timeValueMillis) + ")" : "disabled."));
                break;
            }
            case "standard": {
                this.setDataValue(MODE_PRE_REVEAL_KEY, false);
                this.setDataValue(MODE_HOLD_KEY, false);
                this.setDataValue(DURATION_PRE_REVEAL_KEY, 0L);
                this.setDataValue(DURATION_HOLD_KEY, 0L);
                if (this.getDataLong(DURATION_KEY) <= 0L) {
                    this.setDataValue(DURATION_KEY, 1800000L);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Set default standard duration (30m). Use /claimcontest duration to change.");
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Switched to Standard mode.");
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown mode flag: " + flag + ". Use pre_reveal, hold, or standard.");
                return false;
            }
        }
        return true;
    }

    private boolean handleStartCommand(Player player) {
        if (this.currentPhase != Phase.PENDING && this.currentPhase != Phase.FINISHED) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "A contest is already active (" + String.valueOf((Object)this.currentPhase) + ")!");
            return true;
        }
        this.currentContestClaimId = this.getDataString(CLAIM_ID_KEY);
        this.contestDurationMillis = this.getDataLong(DURATION_KEY);
        this.modePreReveal = this.getDataBoolean(MODE_PRE_REVEAL_KEY);
        this.modeHold = this.getDataBoolean(MODE_HOLD_KEY);
        this.preRevealDurationMillis = this.getDataLong(DURATION_PRE_REVEAL_KEY);
        this.holdDurationMillis = this.getDataLong(DURATION_HOLD_KEY);
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY);
        String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
        if (this.currentContestClaimId == null || this.currentContestClaimId.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Contest location is not set! Use '/claimcontest chunk'.");
            return true;
        }
        if (this.modeHold && this.holdDurationMillis <= 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Hold mode duration is not set or invalid! Use '/claimcontest mode hold <time>'.");
            return true;
        }
        if (!this.modeHold && this.contestDurationMillis <= 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Contest standard duration is not set or invalid! Use '/claimcontest duration <time>'.");
            return true;
        }
        if (this.modePreReveal && this.preRevealDurationMillis <= 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Pre-Reveal mode duration is not set or invalid! Use '/claimcontest mode pre_reveal <time>'.");
            return true;
        }
        this.setDataValue(COMMAND_START_TIMESTAMP_KEY, System.currentTimeMillis());
        this.plugin.cfg.saveClaimContest();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Starting claim contest...");
        this.startContestWorkflow();
        return true;
    }

    private boolean handleCancelCommand(Player player) {
        if (this.currentPhase == Phase.PENDING || this.currentPhase == Phase.FINISHED) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No contest is currently active.");
            return true;
        }
        this.cancelContest(player.getName());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Claim contest cancelled.");
        return true;
    }

    private void startContestWorkflow() {
        this.clearRuntimeContestData();
        if (this.modePreReveal) {
            this.transitionToPhase(Phase.PRE_REVEAL);
        } else {
            this.transitionToPhase(Phase.ACTIVE);
        }
    }

    private void transitionToPhase(Phase nextPhase) {
        this.plugin.getLogger().info("Contest transitioning from " + String.valueOf((Object)this.currentPhase) + " to " + String.valueOf((Object)nextPhase));
        Phase previousPhase = this.currentPhase;
        this.currentPhase = nextPhase;
        this.setDataValue(PHASE_KEY, this.currentPhase.name());
        this.plugin.cfg.saveClaimContest();
        if (this.mainTask != null) {
            this.plugin.getLogger().info("Cancelling previous mainTask.");
            this.mainTask.cancel();
            this.mainTask = null;
        }
        long now = System.currentTimeMillis();
        switch (this.currentPhase.ordinal()) {
            case 1: {
                this.contestEndTimeMillis = now + this.preRevealDurationMillis;
                this.setDataValue(PRE_REVEAL_END_TIMESTAMP_KEY, this.contestEndTimeMillis);
                this.plugin.cfg.saveClaimContest();
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "A CLAIM CONTEST IS STARTING SOON!"));
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "The exact location will be revealed in " + this.formatDuration(this.preRevealDurationMillis)));
                this.plugin.getLogger().info("Scheduling tickPreReveal task.");
                this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickPreReveal, 0L, 20L);
                break;
            }
            case 2: {
                this.contestStartTimeMillis = now;
                this.setDataValue(START_TIMESTAMP_KEY, this.contestStartTimeMillis);
                this.currentHolderName = NO_CLAIMANT;
                this.setDataValue(CURRENT_HOLDER_KEY, NO_CLAIMANT);
                this.setDataValue(CURRENT_CLAIMANT_KEY, NO_CLAIMANT);
                if (previousPhase == Phase.PRE_REVEAL) {
                    this.broadcastExactArea();
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "THE CLAIM CONTEST HAS OFFICIALLY BEGUN!"));
                } else {
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "A new Claim Contest has started!"));
                    this.broadcastExactArea();
                }
                String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
                if (!prize.equals(NO_CLAIMANT)) {
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize));
                }
                if (this.modeHold) {
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Mode: Claim and Hold! First to claim must hold it for " + this.formatDuration(this.holdDurationMillis) + "."));
                    this.plugin.getLogger().info("Scheduling tickActiveHoldMode task.");
                    this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickActiveHoldMode, 0L, 20L);
                    this.plugin.getLogger().info("Updating Active Hold Mode scoreboards immediately after phase transition.");
                    this.updateActiveHoldModeScoreboards();
                    String initialClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
                    if (!initialClaimant.equals(NO_CLAIMANT)) {
                        this.plugin.getLogger().info("Contest started in ACTIVE (Hold Mode) with chunk already claimed by: " + initialClaimant + ". Directly transitioning to HOLD.");
                        this.currentHolderName = initialClaimant;
                        long holdEnds = System.currentTimeMillis() + this.holdDurationMillis;
                        this.holdEndTimeMillis.set(holdEnds);
                        this.setDataValue(HOLD_END_TIMESTAMP_KEY, holdEnds);
                        this.setDataValue(CURRENT_HOLDER_KEY, this.currentHolderName);
                        this.plugin.cfg.saveClaimContest();
                        this.transitionToPhase(Phase.HOLD);
                    }
                } else {
                    this.contestEndTimeMillis = this.contestStartTimeMillis + this.contestDurationMillis;
                    this.setDataValue(CONTEST_END_TIMESTAMP_KEY, this.contestEndTimeMillis);
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Mode: Standard! Contest ends in " + this.formatDuration(this.contestDurationMillis) + "."));
                    this.plugin.getLogger().info("Scheduling tickStandard task.");
                    this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickStandard, 0L, 20L);
                }
                this.plugin.cfg.saveClaimContest();
                break;
            }
            case 3: {
                this.plugin.getLogger().info("Transitioning to HOLD phase.");
                long holdEnds = now + this.holdDurationMillis;
                this.holdEndTimeMillis.set(holdEnds);
                this.setDataValue(HOLD_END_TIMESTAMP_KEY, holdEnds);
                this.setDataValue(CURRENT_HOLDER_KEY, this.currentHolderName);
                this.plugin.cfg.saveClaimContest();
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + this.currentHolderName + " has claimed the Contest Area!"));
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "They must hold it for " + this.formatDuration(this.holdDurationMillis) + " to win!"));
                this.plugin.getLogger().info("Scheduling tickHold task for holder: " + this.currentHolderName);
                this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickHold, 0L, 20L);
                break;
            }
            case 4: {
                this.plugin.getLogger().info("Transitioning to FINISHED phase. Cancelling contest.");
                this.cancelContest(null);
                break;
            }
            case 0: {
                this.plugin.getLogger().warning("Attempted to transition to PENDING phase during runtime.");
            }
        }
    }

    private void tickPreReveal() {
        long now = System.currentTimeMillis();
        if (now >= this.contestEndTimeMillis) {
            this.transitionToPhase(Phase.ACTIVE);
        } else {
            this.updatePreRevealScoreboards(this.contestEndTimeMillis - now);
        }
    }

    private void tickStandard() {
        long now = System.currentTimeMillis();
        if (now >= this.contestEndTimeMillis) {
            String finalClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
            this.handleContestEnd(finalClaimant);
        } else {
            this.updateStandardScoreboards(this.contestEndTimeMillis - now);
            this.checkStandardClaimantChange();
        }
    }

    private void tickActiveHoldMode() {
        this.updateActiveHoldModeScoreboards();
    }

    private void tickHold() {
        if (this.contestEnded) {
            return;
        }
        long now = System.currentTimeMillis();
        long holdEnds = this.holdEndTimeMillis.get();
        long millisLeft = holdEnds - now;
        this.plugin.getLogger().info("tickHold running. Time left: " + this.formatTimeLeft(millisLeft));
        if (now >= holdEnds) {
            this.plugin.getLogger().info("Hold time completed. Ending contest for holder: " + this.currentHolderName);
            this.handleContestEnd(this.currentHolderName);
            return;
        }
        String actualClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
        if (!actualClaimant.equalsIgnoreCase(this.currentHolderName)) {
            this.plugin.getLogger().info(this.currentHolderName + " lost the claim (" + this.currentContestClaimId + "). Actual claimant is now: " + actualClaimant + ". Resetting hold timer.");
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + this.currentHolderName + " lost the claim! The hold timer has reset."));
            this.currentHolderName = NO_CLAIMANT;
            this.setDataValue(CURRENT_HOLDER_KEY, NO_CLAIMANT);
            this.holdEndTimeMillis.set(-1L);
            this.setDataValue(HOLD_END_TIMESTAMP_KEY, -1);
            this.plugin.cfg.saveClaimContest();
            this.transitionToPhase(Phase.ACTIVE);
        } else {
            this.updateHoldScoreboards(millisLeft);
        }
    }

    @EventHandler
    public void onContestChunkClaimed(ContestChunkClaimedEvent event) {
        if (this.currentPhase == Phase.ACTIVE && this.modeHold) {
            String activeContestClaimId = this.getDataString(CLAIM_ID_KEY);
            if (activeContestClaimId == null || activeContestClaimId.isEmpty()) {
                this.plugin.getLogger().warning("CLAIM_ID_KEY is missing!");
                return;
            }
            String actualCurrentClaimant = this.getPrimaryClaimantName(activeContestClaimId);
            if (!actualCurrentClaimant.equalsIgnoreCase(this.currentHolderName)) {
                if (actualCurrentClaimant.equals(NO_CLAIMANT)) {
                    this.plugin.getLogger().fine("Chunk is unclaimed.");
                } else {
                    this.currentHolderName = actualCurrentClaimant;
                    this.transitionToPhase(Phase.HOLD);
                }
            } else if (actualCurrentClaimant.equals(NO_CLAIMANT)) {
                this.plugin.getLogger().fine("Chunk is unclaimed.");
            } else {
                this.plugin.getLogger().fine("Claimant is already the current holder.");
            }
        } else {
            this.plugin.getLogger().fine("Event ignored. Incorrect phase or mode.");
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.getFrom().getChunk().equals((Object)event.getTo().getChunk())) {
            this.updatePlayerTeamIfNeeded(event.getPlayer());
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.updatePlayerTeamIfNeeded(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayerTeamIfNeeded(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.clearPlayerScoreboard(event.getPlayer());
        this.plugin.getLogger().info("Cleared scoreboard for quitting player: " + event.getPlayer().getName());
        this.removePlayerFromContestTeams(event.getPlayer());
    }

    private void removePlayerFromContestTeams(Player player) {
        Scoreboard currentBoard = player.getScoreboard();
        if (currentBoard == null || currentBoard == this.scoreboardManager.getMainScoreboard()) {
            currentBoard = this.scoreboardManager.getMainScoreboard();
        }
        Team claimantTeam = currentBoard.getTeam(TEAM_CLAIMANT);
        Team defenderTeam = currentBoard.getTeam(TEAM_DEFENDER);
        Team intruderTeam = currentBoard.getTeam(TEAM_INTRUDER);
        if (claimantTeam != null) {
            claimantTeam.removeEntry(player.getName());
        }
        if (defenderTeam != null) {
            defenderTeam.removeEntry(player.getName());
        }
        if (intruderTeam != null) {
            intruderTeam.removeEntry(player.getName());
        }
    }

    private void handleContestEnd(String winnerName) {
        if (this.contestEnded) {
            return;
        }
        this.contestEnded = true;
        Phase phaseEnded = this.currentPhase;
        this.plugin.getLogger().info("Contest ending. Winner: " + winnerName + " (Ended from Phase: " + String.valueOf((Object)phaseEnded) + ")");
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown");
        String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
        long contestEndTimeMillisActual = System.currentTimeMillis();
        String endDateFormatted = HISTORY_DATE_FORMAT.format(LocalDateTime.now());
        String historyPath = "history." + endDateFormatted;
        long commandStartTimeMillis = this.getDataLong(COMMAND_START_TIMESTAMP_KEY);
        String calculatedDuration = "N/A";
        if (commandStartTimeMillis > 0L) {
            long durationMillis = contestEndTimeMillisActual - commandStartTimeMillis;
            if (durationMillis >= 0L) {
                calculatedDuration = this.formatDuration(durationMillis);
            } else {
                calculatedDuration = "Error: Negative Duration";
                this.plugin.getLogger().warning("Calculated negative contest duration for history. Command start time: " + commandStartTimeMillis + ", End time: " + contestEndTimeMillisActual);
            }
        } else {
            this.plugin.getLogger().warning("Contest command start time not found in config for history entry.");
        }
        this.claimContestConfig.set(historyPath + ".location", (Object)chunkLoc);
        this.claimContestConfig.set(historyPath + ".winner", (Object)winnerName);
        this.claimContestConfig.set(historyPath + ".prize", (Object)prize);
        this.claimContestConfig.set(historyPath + ".mode.pre-reveal", (Object)this.getDataBoolean(MODE_PRE_REVEAL_KEY));
        this.claimContestConfig.set(historyPath + ".mode.hold", (Object)this.getDataBoolean(MODE_HOLD_KEY));
        this.claimContestConfig.set(historyPath + ".config_duration.standard", (Object)this.formatDuration(this.getDataLong(DURATION_KEY)));
        this.claimContestConfig.set(historyPath + ".config_duration.pre-reveal", (Object)this.formatDuration(this.getDataLong(DURATION_PRE_REVEAL_KEY)));
        this.claimContestConfig.set(historyPath + ".config_duration.hold", (Object)this.formatDuration(this.getDataLong(DURATION_HOLD_KEY)));
        this.claimContestConfig.set(historyPath + ".ended_phase", (Object)phaseEnded.name());
        this.claimContestConfig.set(historyPath + ".start-date", (Object)(commandStartTimeMillis > 0L ? HISTORY_DATE_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(commandStartTimeMillis), ZoneId.systemDefault())) : "N/A"));
        this.claimContestConfig.set(historyPath + ".end-date", (Object)endDateFormatted);
        this.claimContestConfig.set(historyPath + ".calculated-duration", (Object)calculatedDuration);
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "THE CONTEST HAS ENDED!"));
        if (!winnerName.equals(NO_CLAIMANT)) {
            Player winnerPlayer = Bukkit.getPlayerExact((String)winnerName);
            String finalWinnerName = winnerPlayer != null ? winnerPlayer.getName() : winnerName;
            Bukkit.broadcastMessage((String)("Location: " + String.valueOf(ChatColor.AQUA) + chunkLoc));
            Bukkit.broadcastMessage((String)("And the winner is... " + String.valueOf(ChatColor.GREEN) + finalWinnerName + "!"));
            if (!prize.equals(NO_CLAIMANT)) {
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize));
            }
            if (!calculatedDuration.equals("N/A") && !calculatedDuration.contains("Error")) {
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Duration: " + String.valueOf(ChatColor.WHITE) + calculatedDuration));
            }
            if (winnerPlayer != null) {
                this.pluginManager.callEvent((Event)new ClaimContestOverEvent(winnerPlayer));
            } else {
                this.plugin.getLogger().info("Contest winner " + finalWinnerName + " is offline. Prize: " + prize + (String)(calculatedDuration.equals("N/A") ? "" : ", Duration: " + calculatedDuration));
            }
        } else {
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "No one secured the claim when the contest ended!"));
            if (!calculatedDuration.equals("N/A") && !calculatedDuration.contains("Error")) {
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Duration: " + String.valueOf(ChatColor.WHITE) + calculatedDuration));
            }
        }
        this.clearContestTeams();
        this.cancelContest(null);
    }

    private void cancelContest(String cancelledBy) {
        this.contestEnded = false;
        if (this.currentPhase == Phase.PENDING || this.currentPhase == Phase.FINISHED) {
            return;
        }
        Phase phaseCancelled = this.currentPhase;
        this.plugin.getLogger().info("Cancelling contest. Current phase: " + String.valueOf((Object)phaseCancelled) + (String)(cancelledBy != null ? " by " + cancelledBy : ""));
        if (this.mainTask != null) {
            this.mainTask.cancel();
            this.mainTask = null;
        }
        this.currentPhase = Phase.FINISHED;
        this.currentContestClaimId = null;
        this.currentHolderName = NO_CLAIMANT;
        this.contestStartTimeMillis = -1L;
        this.contestEndTimeMillis = -1L;
        this.holdEndTimeMillis.set(-1L);
        this.clearRuntimeContestData();
        this.plugin.cfg.saveClaimContest();
        this.clearAllScoreboards();
        this.clearContestTeams();
        if (cancelledBy != null) {
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "The claim contest was cancelled by " + cancelledBy + "."));
        }
    }

    private void updatePreRevealScoreboards(long millisLeft) {
        String timeLeftFormatted = this.formatTimeLeft(millisLeft);
        String approxLocation = this.getApproximateLocationString();
        Scoreboard board = this.scoreboardManager.getNewScoreboard();
        Objective sidebar = board.registerNewObjective(SCOREBOARD_OBJECTIVE_NAME, "dummy", SCOREBOARD_TITLE);
        sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + "Contest starting soon!").setScore(5);
        sidebar.getScore(" ").setScore(4);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Approx. Location:").setScore(3);
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + approxLocation).setScore(2);
        sidebar.getScore("  ").setScore(1);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Revealing in: " + String.valueOf(ChatColor.WHITE) + timeLeftFormatted).setScore(0);
        this.setBoardForAllPlayers(board);
    }

    private void updateStandardScoreboards(long millisLeft) {
        String timeLeftFormatted = this.formatTimeLeft(millisLeft);
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown");
        String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
        Scoreboard board = this.createScoreboardBase(SCOREBOARD_TITLE);
        Objective sidebar = board.getObjective(DisplaySlot.SIDEBAR);
        String[] locationParts = chunkLoc.split(" \\(X: ");
        String worldName = locationParts[0];
        String coords = "(X: " + locationParts[1];
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + "Location:").setScore(5);
        sidebar.getScore(String.valueOf(this.getWorldColor(worldName)) + worldName).setScore(4);
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + coords).setScore(3);
        sidebar.getScore(" ").setScore(2);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Time Left: " + String.valueOf(ChatColor.WHITE) + timeLeftFormatted).setScore(1);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize).setScore(0);
        this.updatePlayerTeams(board, this.currentContestClaimId);
        this.setBoardForAllPlayers(board);
    }

    private void updateActiveHoldModeScoreboards() {
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown");
        String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
        String currentClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
        String claimantStatus = currentClaimant.equals(NO_CLAIMANT) ? String.valueOf(ChatColor.WHITE) + "Claimant: " + String.valueOf(ChatColor.GRAY) + NO_CLAIMANT : String.valueOf(ChatColor.YELLOW) + "Claimant: " + String.valueOf(ChatColor.GREEN) + currentClaimant;
        Scoreboard board = this.createScoreboardBase(SCOREBOARD_TITLE);
        Objective sidebar = board.getObjective(DisplaySlot.SIDEBAR);
        String[] locationParts = chunkLoc.split(" \\(X: ");
        String worldName = locationParts[0];
        String coords = "(X: " + locationParts[1];
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + "Location:").setScore(6);
        sidebar.getScore(String.valueOf(this.getWorldColor(worldName)) + worldName).setScore(5);
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + coords).setScore(4);
        sidebar.getScore(" ").setScore(3);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Mode: " + String.valueOf(ChatColor.AQUA) + "Claim and Hold").setScore(2);
        sidebar.getScore(claimantStatus).setScore(1);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize).setScore(0);
        this.updatePlayerTeams(board, this.currentContestClaimId);
        this.setBoardForAllPlayers(board);
    }

    private void updateHoldScoreboards(long millisLeft) {
        String timeLeftFormatted = this.formatTimeLeft(millisLeft);
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown");
        String prize = this.getDataString(PRIZE_KEY, NO_CLAIMANT);
        Scoreboard board = this.createScoreboardBase(String.valueOf(ChatColor.GOLD) + "Hold the Claim!");
        Objective sidebar = board.getObjective(DisplaySlot.SIDEBAR);
        sidebar.getScore(" ").setScore(6);
        String[] locationParts = chunkLoc.split(" \\(X: ");
        String worldName = locationParts[0];
        String coords = "(X: " + locationParts[1];
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + "Location:").setScore(8);
        sidebar.getScore(String.valueOf(this.getWorldColor(worldName)) + worldName).setScore(7);
        sidebar.getScore(String.valueOf(ChatColor.WHITE) + coords).setScore(6);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Holder: " + String.valueOf(ChatColor.GREEN) + this.currentHolderName).setScore(5);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Hold Time Left: " + String.valueOf(ChatColor.WHITE) + timeLeftFormatted).setScore(4);
        sidebar.getScore(" ").setScore(3);
        sidebar.getScore(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize).setScore(2);
        this.updatePlayerTeams(board, this.currentContestClaimId);
        this.plugin.getLogger().info("updateHoldScoreboards: Created board. Assigning scoreboards and updating teams.");
        this.setBoardForAllPlayers(board);
    }

    private ChatColor getWorldColor(String worldName) {
        switch (worldName) {
            case "Overworld": {
                return ChatColor.GREEN;
            }
            case "The Nether": {
                return ChatColor.RED;
            }
            case "The End": {
                return ChatColor.AQUA;
            }
            case "world": 
            case "world_nether": 
            case "world_the_end": {
                this.plugin.getLogger().warning("getWorldColor received unexpected internal world name: " + worldName);
                return ChatColor.WHITE;
            }
        }
        return ChatColor.WHITE;
    }

    private Scoreboard createScoreboardBase(String title) {
        Scoreboard board = this.scoreboardManager.getNewScoreboard();
        Objective sidebar = board.registerNewObjective(SCOREBOARD_OBJECTIVE_NAME, "dummy", title);
        sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
        return board;
    }

    private Location getContestChunkLocation() {
        String chunkLocString = this.getDataString(CHUNK_LOC_KEY);
        if (chunkLocString == null || chunkLocString.isEmpty() || chunkLocString.equals(String.valueOf(ChatColor.RED) + "Not Set")) {
            return null;
        }
        try {
            String worldName;
            String[] parts = chunkLocString.split(" \\(X: ");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid chunkLoc format");
            }
            String dimensionName = parts[0].trim();
            String coordsPart = parts[1].replace("X: ", "").replace("Z: ", "").replace(")", "").trim();
            String[] coords = coordsPart.split(", ");
            if (coords.length != 2) {
                throw new IllegalArgumentException("Invalid coords format");
            }
            switch (dimensionName) {
                case "Overworld": {
                    worldName = "world";
                    break;
                }
                case "The Nether": {
                    worldName = "world_nether";
                    break;
                }
                case "The End": {
                    worldName = "world_the_end";
                    break;
                }
                default: {
                    this.plugin.getLogger().warning("Unknown dimension name in chunkLoc: " + dimensionName);
                    return null;
                }
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                this.plugin.getLogger().warning("Could not find world with name: " + worldName);
                return null;
            }
            int chunkX = Integer.parseInt(coords[0]) * 16;
            int chunkZ = Integer.parseInt(coords[1]) * 16;
            int blockX = chunkX + 8;
            int blockZ = chunkZ + 8;
            int blockY = world.getHighestBlockYAt(blockX, blockZ);
            return new Location(world, (double)blockX, (double)blockY, (double)blockZ);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Failed to parse chunk coordinates from chunkLoc: " + chunkLocString);
            return null;
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid chunkLoc format: " + chunkLocString + " - " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("An unexpected error occurred parsing chunkLoc: " + chunkLocString + " - " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private Team getOrCreateTeam(Scoreboard board, String teamName, String prefix, ChatColor color) {
        Team team = board.getTeam(teamName);
        if (team == null) {
            team = board.registerNewTeam(teamName);
            team.setPrefix(String.valueOf(color) + prefix + String.valueOf(ChatColor.RESET) + " ");
            team.setColor(color);
            team.setAllowFriendlyFire(true);
            team.setCanSeeFriendlyInvisibles(false);
        }
        return team;
    }

    private void updatePlayerTeams(Scoreboard board, String contestedClaimId) {
        int contestBlockZ;
        int contestBlockX;
        World contestWorld;
        List<String> claimMembers;
        String primaryClaimant;
        block34: {
            this.plugin.getLogger().info("updatePlayerTeams: Starting team update.");
            if (contestedClaimId == null || contestedClaimId.isEmpty()) {
                this.plugin.getLogger().warning("updatePlayerTeams: contestedClaimId is null or empty. Cannot update teams.");
                return;
            }
            primaryClaimant = this.getPrimaryClaimantName(contestedClaimId);
            claimMembers = this.getClaimMembers(contestedClaimId);
            this.plugin.getLogger().info("updatePlayerTeams: Primary Claimant for " + contestedClaimId + ": " + primaryClaimant);
            this.plugin.getLogger().info("updatePlayerTeams: Claim Members for " + contestedClaimId + ": " + String.valueOf(claimMembers));
            contestWorld = null;
            contestBlockX = Integer.MAX_VALUE;
            contestBlockZ = Integer.MAX_VALUE;
            String chunkLocString = this.getDataString(CHUNK_LOC_KEY);
            if (chunkLocString != null && !chunkLocString.isEmpty() && !chunkLocString.equals(String.valueOf(ChatColor.RED) + "Not Set")) {
                try {
                    String[] parts = chunkLocString.split(" \\(X: ");
                    if (parts.length == 2) {
                        String dimensionName = parts[0].trim();
                        String coordsPart = parts[1].replace("X: ", "").replace("Z: ", "").replace(")", "").trim();
                        String[] coords = coordsPart.split(", ");
                        if (coords.length == 2) {
                            String worldName = null;
                            switch (dimensionName) {
                                case "Overworld": {
                                    worldName = "world";
                                    break;
                                }
                                case "The Nether": {
                                    worldName = "world_nether";
                                    break;
                                }
                                case "The End": {
                                    worldName = "world_the_end";
                                    break;
                                }
                                default: {
                                    this.plugin.getLogger().warning("updatePlayerTeams: Unknown dimension name in chunkLoc for teams proximity: " + dimensionName);
                                    worldName = null;
                                }
                            }
                            if (worldName != null) {
                                contestWorld = Bukkit.getWorld((String)worldName);
                                if (contestWorld == null) {
                                    this.plugin.getLogger().warning("updatePlayerTeams: Could not find world for name: " + worldName + " (from dimension: " + dimensionName + ") for teams proximity check.");
                                } else {
                                    this.plugin.getLogger().info("updatePlayerTeams: Contest world identified: " + contestWorld.getName());
                                }
                            }
                            contestBlockX = Integer.parseInt(coords[0]);
                            contestBlockZ = Integer.parseInt(coords[1]);
                            this.plugin.getLogger().info("updatePlayerTeams: Contest block coords (X, Z): " + contestBlockX + ", " + contestBlockZ);
                        } else {
                            this.plugin.getLogger().warning("updatePlayerTeams: Invalid coords format in chunkLoc for teams proximity: " + chunkLocString);
                        }
                        break block34;
                    }
                    this.plugin.getLogger().warning("updatePlayerTeams: Invalid chunkLoc format for teams proximity: " + chunkLocString);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("updatePlayerTeams: Failed to parse chunk coordinates from chunkLoc for teams proximity: " + chunkLocString);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("updatePlayerTeams: An unexpected error occurred parsing chunkLoc for teams proximity: " + chunkLocString + " - " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                this.plugin.getLogger().warning("updatePlayerTeams: chunkLocString is null, empty, or not set. Cannot perform proximity check.");
            }
        }
        Team claimantTeam = this.getOrCreateTeam(board, TEAM_CLAIMANT, "Claimant", ChatColor.GOLD);
        Team defenderTeam = this.getOrCreateTeam(board, TEAM_DEFENDER, "Defender", ChatColor.BLUE);
        Team intruderTeam = this.getOrCreateTeam(board, TEAM_INTRUDER, "Intruder", ChatColor.RED);
        if (claimantTeam == null || defenderTeam == null || intruderTeam == null) {
            this.plugin.getLogger().severe("updatePlayerTeams: Failed to get or create all required teams. Aborting team assignment.");
            return;
        }
        this.plugin.getLogger().info("updatePlayerTeams: Iterating through online players.");
        for (Player player : Bukkit.getOnlinePlayers()) {
            String playerName = player.getName();
            this.plugin.getLogger().info("updatePlayerTeams: Processing player: " + playerName);
            this.plugin.getLogger().info("updatePlayerTeams: Attempting to remove " + playerName + " from all contest teams.");
            if (claimantTeam.hasEntry(playerName)) {
                claimantTeam.removeEntry(playerName);
                this.plugin.getLogger().info(playerName + " removed from b4bclaimant_team");
            }
            if (defenderTeam.hasEntry(playerName)) {
                defenderTeam.removeEntry(playerName);
                this.plugin.getLogger().info(playerName + " removed from b4bdefender_team");
            }
            if (intruderTeam.hasEntry(playerName)) {
                intruderTeam.removeEntry(playerName);
                this.plugin.getLogger().info(playerName + " removed from b4bintruder_team");
            }
            if (playerName.equalsIgnoreCase(primaryClaimant)) {
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is the primary claimant. Assigning to Claimant team.");
                claimantTeam.addEntry(playerName);
                continue;
            }
            boolean isInProximity = false;
            if (contestWorld != null && player.getWorld().equals((Object)contestWorld) && contestBlockX != Integer.MAX_VALUE && contestBlockZ != Integer.MAX_VALUE) {
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is in the contest world (" + contestWorld.getName() + "). Checking proximity.");
                int playerBlockX = player.getLocation().getBlockX();
                int playerBlockZ = player.getLocation().getBlockZ();
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + "'s block coords (X, Z): " + playerBlockX + ", " + playerBlockZ);
                int deltaX = Math.abs(playerBlockX - contestBlockX);
                int deltaZ = Math.abs(playerBlockZ - contestBlockZ);
                int proximityRadiusBlocks = this.PROXIMITY_RADIUS_CHUNKS * 16;
                this.plugin.getLogger().info("updatePlayerTeams: Proximity check for " + playerName + ". Delta X: " + deltaX + ", Delta Z: " + deltaZ + ", Radius in blocks: " + proximityRadiusBlocks);
                if (deltaX <= proximityRadiusBlocks && deltaZ <= proximityRadiusBlocks) {
                    isInProximity = true;
                    this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " IS within proximity radius.");
                } else {
                    this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is NOT within proximity radius.");
                }
            } else {
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is not in the contest world or contest location is invalid. Skipping proximity check.");
            }
            if (isInProximity) {
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is in proximity. Checking claim membership.");
                if (claimMembers.stream().anyMatch(member -> member.equalsIgnoreCase(playerName))) {
                    this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is a claim member. Assigning to Defender team.");
                    defenderTeam.addEntry(playerName);
                    continue;
                }
                this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is NOT a claim member. Assigning to Intruder team.");
                intruderTeam.addEntry(playerName);
                continue;
            }
            this.plugin.getLogger().info("updatePlayerTeams: " + playerName + " is outside proximity and not the claimant. Not assigning to Defender/Intruder teams.");
        }
        this.plugin.getLogger().info("updatePlayerTeams: Finished team update iteration.");
    }

    private void updatePlayerTeamIfNeeded(Player player) {
        UUID uuid;
        long lastUpdate;
        long now = System.currentTimeMillis();
        if (now - (lastUpdate = this.teamUpdateCooldowns.getOrDefault(uuid = player.getUniqueId(), 0L).longValue()) < 2000L) {
            return;
        }
        this.teamUpdateCooldowns.put(uuid, now);
        if (this.currentContestClaimId == null || this.currentContestClaimId.isEmpty() || this.currentPhase == Phase.PENDING || this.currentPhase == Phase.FINISHED) {
            return;
        }
        Scoreboard board = player.getScoreboard();
        if (board == null || board == this.scoreboardManager.getMainScoreboard()) {
            board = this.scoreboardManager.getNewScoreboard();
            player.setScoreboard(board);
        }
        String playerName = player.getName();
        String primaryClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
        List<String> claimMembers = this.getClaimMembers(this.currentContestClaimId);
        Team claimantTeam = this.getOrCreateTeam(board, TEAM_CLAIMANT, "Claimant", ChatColor.GOLD);
        Team defenderTeam = this.getOrCreateTeam(board, TEAM_DEFENDER, "Defender", ChatColor.BLUE);
        Team intruderTeam = this.getOrCreateTeam(board, TEAM_INTRUDER, "Intruder", ChatColor.RED);
        claimantTeam.removeEntry(playerName);
        defenderTeam.removeEntry(playerName);
        intruderTeam.removeEntry(playerName);
        if (playerName.equalsIgnoreCase(primaryClaimant)) {
            claimantTeam.addEntry(playerName);
            return;
        }
        Location loc = player.getLocation();
        Location contestLoc = this.getContestChunkLocation();
        if (loc.getWorld() != null && contestLoc != null && loc.getWorld().equals((Object)contestLoc.getWorld())) {
            int dx = Math.abs(loc.getBlockX() - contestLoc.getBlockX());
            int dz = Math.abs(loc.getBlockZ() - contestLoc.getBlockZ());
            int radiusBlocks = this.PROXIMITY_RADIUS_CHUNKS * 16;
            if (dx <= radiusBlocks && dz <= radiusBlocks) {
                if (claimMembers.stream().anyMatch(m -> m.equalsIgnoreCase(playerName))) {
                    defenderTeam.addEntry(playerName);
                } else {
                    intruderTeam.addEntry(playerName);
                }
            }
        }
    }

    private void setBoardForAllPlayers(Scoreboard board) {
        if (board == null) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.setScoreboard(board);
        }
    }

    private void clearPlayerScoreboard(Player player) {
        if (player.getScoreboard() != null && player.getScoreboard().getObjective(SCOREBOARD_OBJECTIVE_NAME) != null) {
            player.setScoreboard(this.scoreboardManager.getMainScoreboard());
        }
    }

    private void clearAllScoreboards() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.clearPlayerScoreboard(p);
        }
    }

    private void clearContestTeams() {
        Scoreboard mainBoard = this.scoreboardManager.getMainScoreboard();
        Team claimantTeam = mainBoard.getTeam(TEAM_CLAIMANT);
        Team defenderTeam = mainBoard.getTeam(TEAM_DEFENDER);
        Team intruderTeam = mainBoard.getTeam(TEAM_INTRUDER);
        if (claimantTeam != null) {
            claimantTeam.getEntries().forEach(entry -> claimantTeam.removeEntry(entry));
        }
        if (defenderTeam != null) {
            defenderTeam.getEntries().forEach(entry -> defenderTeam.removeEntry(entry));
        }
        if (intruderTeam != null) {
            intruderTeam.getEntries().forEach(entry -> intruderTeam.removeEntry(entry));
        }
    }

    private long parseTimeArgument(String[] args) {
        long totalSeconds = 0L;
        boolean valid = false;
        for (String part : args) {
            part = part.toLowerCase();
            try {
                long value = Long.parseLong(part.substring(0, part.length() - 1));
                if (part.endsWith("d")) {
                    totalSeconds += value * 86400L;
                } else if (part.endsWith("h")) {
                    totalSeconds += value * 3600L;
                } else if (part.endsWith("m")) {
                    totalSeconds += value * 60L;
                } else if (part.endsWith("s")) {
                    totalSeconds += value;
                } else {
                    return -1L;
                }
                valid = true;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                return -1L;
            }
        }
        return valid ? totalSeconds * 1000L : -1L;
    }

    private List<String> getClaimMembers(String claimId) {
        if (claimId == null || claimId.isEmpty()) {
            return Collections.emptyList();
        }
        String membersString = this.claimDataConfig.getString(claimId + ".members");
        if (membersString == null || membersString.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(membersString.split("\\n")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private String getPrimaryClaimantName(String claimId) {
        List<String> members = this.getClaimMembers(claimId);
        return members.isEmpty() ? NO_CLAIMANT : members.get(0);
    }

    private void checkStandardClaimantChange() {
        Bukkit.getOnlinePlayers().forEach(this::updatePlayerTeamIfNeeded);
        String actualClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
        String previousClaimant = this.getDataString(CURRENT_CLAIMANT_KEY, NO_CLAIMANT);
        if (!actualClaimant.equalsIgnoreCase(previousClaimant)) {
            this.setDataValue(CURRENT_CLAIMANT_KEY, actualClaimant);
            this.plugin.cfg.saveClaimContest();
            if (!actualClaimant.equals(NO_CLAIMANT)) {
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + actualClaimant + " has claimed the Contest Area!"));
            } else if (!previousClaimant.equals(NO_CLAIMANT)) {
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + previousClaimant + " no longer holds the Contest Area!"));
            }
        }
    }

    private void broadcastExactArea() {
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown");
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "Contest Location: " + String.valueOf(ChatColor.AQUA) + chunkLoc));
    }

    private String getApproximateLocationString() {
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, "Unknown Location");
        try {
            String dimension = chunkLoc.split(" ")[0];
            if (dimension.isEmpty() || dimension.contains("(")) {
                dimension = "Unknown";
            }
            int x = this.getDataInt(CLAIM_ID_KEY.hashCode() + "_approx_x_offset", 0);
            int z = this.getDataInt(CLAIM_ID_KEY.hashCode() + "_approx_z_offset", 0);
            if (x == 0 && z == 0) {
                Random random = new Random(this.getDataString(CLAIM_ID_KEY, "").hashCode());
                int offsetX = (random.nextBoolean() ? 1 : -1) * (64 + random.nextInt(64));
                int offsetZ = (random.nextBoolean() ? 1 : -1) * (64 + random.nextInt(64));
                String[] parts = chunkLoc.split("\\(")[1].split(",");
                int actualX = Integer.parseInt(parts[0].replaceAll("[^\\d-]", ""));
                int actualZ = Integer.parseInt(parts[1].replaceAll("[^\\d-]", ""));
                x = actualX + offsetX;
                z = actualZ + offsetZ;
                this.setDataValue(CLAIM_ID_KEY.hashCode() + "_approx_x_offset", x);
                this.setDataValue(CLAIM_ID_KEY.hashCode() + "_approx_z_offset", z);
                this.plugin.cfg.saveClaimContest();
            }
            return dimension + " near X:" + x + ", Z:" + z;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse chunkLoc for approximate location: " + chunkLoc);
            return "An Unknown Area";
        }
    }

    private boolean sendCurrentContestStatus(Player player) {
        ConfigurationSection data = this.claimContestConfig.getConfigurationSection(DATA_SECTION);
        boolean configExists = data != null && !data.getKeys(false).isEmpty();
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Contest Status ---");
        if (this.currentPhase != Phase.PENDING && this.currentPhase != Phase.FINISHED) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Status: ACTIVE (" + String.valueOf((Object)this.currentPhase) + ")");
        } else if (configExists && this.getDataLong(CONFIG_SAVE_TIMESTAMP_KEY) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Status: Configured (Pending Start)");
        } else {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Status: No contest configured.");
            return true;
        }
        String chunkLoc = this.getDataString(CHUNK_LOC_KEY, String.valueOf(ChatColor.RED) + "Not Set");
        String prize = this.getDataString(PRIZE_KEY, String.valueOf(ChatColor.GRAY) + NO_CLAIMANT);
        boolean preReveal = this.getDataBoolean(MODE_PRE_REVEAL_KEY);
        boolean hold = this.getDataBoolean(MODE_HOLD_KEY);
        long stdDur = this.getDataLong(DURATION_KEY);
        long preRevDur = this.getDataLong(DURATION_PRE_REVEAL_KEY);
        long holdDur = this.getDataLong(DURATION_HOLD_KEY);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Location: " + String.valueOf(ChatColor.WHITE) + chunkLoc);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Prize: " + String.valueOf(ChatColor.WHITE) + prize);
        if (hold) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mode: " + String.valueOf(ChatColor.AQUA) + "Claim and Hold (" + this.formatDuration(holdDur) + ")");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mode: " + String.valueOf(ChatColor.AQUA) + "Standard (" + this.formatDuration(stdDur) + ")");
        }
        if (preReveal) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Pre-Reveal: " + String.valueOf(ChatColor.GREEN) + "Enabled (" + this.formatDuration(preRevDur) + ")");
        }
        if (this.currentPhase != Phase.PENDING && this.currentPhase != Phase.FINISHED) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Runtime Info ---");
            long now = System.currentTimeMillis();
            switch (this.currentPhase.ordinal()) {
                case 1: {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Revealing in: " + String.valueOf(ChatColor.WHITE) + this.formatTimeLeft(this.contestEndTimeMillis - now));
                    break;
                }
                case 2: {
                    if (this.modeHold) {
                        String currentClaimant = this.getPrimaryClaimantName(this.currentContestClaimId);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Claimant: " + (currentClaimant.equals(NO_CLAIMANT) ? String.valueOf(ChatColor.GRAY) + NO_CLAIMANT : String.valueOf(ChatColor.GREEN) + currentClaimant));
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Hold for " + this.formatDuration(this.holdDurationMillis) + " to win!");
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Time Left: " + String.valueOf(ChatColor.WHITE) + this.formatTimeLeft(this.contestEndTimeMillis - now));
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Claimant: " + String.valueOf(ChatColor.WHITE) + this.getPrimaryClaimantName(this.currentContestClaimId));
                    break;
                }
                case 3: {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Holder: " + String.valueOf(ChatColor.GREEN) + this.currentHolderName);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Hold Time Left: " + String.valueOf(ChatColor.WHITE) + this.formatTimeLeft(this.holdEndTimeMillis.get() - now));
                }
            }
            long commandStartTime = this.getDataLong(COMMAND_START_TIMESTAMP_KEY);
            if (commandStartTime > 0L) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Started At: " + String.valueOf(ChatColor.WHITE) + HISTORY_DATE_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(commandStartTime), ZoneId.systemDefault())));
            }
        } else if (this.currentPhase == Phase.PENDING && configExists) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Use '/claimcontest start' to begin.");
            long commandStartTime = this.getDataLong(COMMAND_START_TIMESTAMP_KEY);
            if (commandStartTime > 0L) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Last Configured Start At: " + String.valueOf(ChatColor.WHITE) + HISTORY_DATE_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(commandStartTime), ZoneId.systemDefault())));
            }
        }
        return true;
    }

    private String formatDuration(long millis) {
        if (millis <= 0L) {
            return "0s";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    private String formatTimeLeft(long millis) {
        if (millis <= 0L) {
            return "00:00:00:00";
        }
        long secondsTotal = Math.max(0L, millis / 1000L);
        long days = secondsTotal / 86400L;
        long hours = secondsTotal % 86400L / 3600L;
        long minutes = secondsTotal % 3600L / 60L;
        long seconds = secondsTotal % 60L;
        return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    private void setDataValue(String key, Object value) {
        this.claimContestConfig.set("data." + key, value);
    }

    private String getDataString(String key, String def) {
        return this.claimContestConfig.getString("data." + key, def);
    }

    private String getDataString(String key) {
        return this.getDataString(key, null);
    }

    private long getDataLong(String key) {
        return this.claimContestConfig.getLong("data." + key, 0L);
    }

    private boolean getDataBoolean(String key) {
        return this.claimContestConfig.getBoolean("data." + key, false);
    }

    private int getDataInt(String key, int def) {
        return this.claimContestConfig.getInt("data." + key, def);
    }

    private void clearRuntimeContestData() {
        ConfigurationSection dataSection = this.claimContestConfig.getConfigurationSection(DATA_SECTION);
        if (dataSection != null) {
            dataSection.set(START_TIMESTAMP_KEY, null);
            dataSection.set(CURRENT_CLAIMANT_KEY, null);
            dataSection.set(CURRENT_HOLDER_KEY, null);
            dataSection.set(PHASE_KEY, null);
            dataSection.set(PRE_REVEAL_END_TIMESTAMP_KEY, null);
            dataSection.set(CONTEST_END_TIMESTAMP_KEY, null);
            dataSection.set(HOLD_END_TIMESTAMP_KEY, null);
            dataSection.set(CLAIM_ID_KEY.hashCode() + "_approx_x_offset", null);
            dataSection.set(CLAIM_ID_KEY.hashCode() + "_approx_z_offset", null);
        }
    }

    private void clearFullContestData() {
        this.claimContestConfig.set(DATA_SECTION, null);
    }

    private void loadAndResumeContest() {
        ConfigurationSection data = this.claimContestConfig.getConfigurationSection(DATA_SECTION);
        if (data == null || !data.contains(PHASE_KEY)) {
            this.currentPhase = Phase.PENDING;
            return;
        }
        try {
            this.currentPhase = Phase.valueOf(data.getString(PHASE_KEY, Phase.PENDING.name()));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid phase found in contest config: " + data.getString(PHASE_KEY) + ". Resetting.");
            this.clearFullContestData();
            this.plugin.cfg.saveClaimContest();
            this.currentPhase = Phase.PENDING;
            return;
        }
        if (this.currentPhase == Phase.PENDING || this.currentPhase == Phase.FINISHED) {
            if (this.currentPhase == Phase.FINISHED) {
                this.clearRuntimeContestData();
            }
            if (this.currentPhase == Phase.FINISHED) {
                this.setDataValue(COMMAND_START_TIMESTAMP_KEY, null);
                this.plugin.cfg.saveClaimContest();
            }
            return;
        }
        this.plugin.getLogger().info("Resuming claim contest from Phase: " + String.valueOf((Object)this.currentPhase));
        this.currentContestClaimId = data.getString(CLAIM_ID_KEY);
        this.modeHold = data.getBoolean(MODE_HOLD_KEY);
        this.holdDurationMillis = data.getLong(DURATION_HOLD_KEY);
        long commandStartTimeLoaded = data.getLong(COMMAND_START_TIMESTAMP_KEY, -1L);
        if (this.currentContestClaimId == null || this.currentContestClaimId.isEmpty()) {
            this.plugin.getLogger().severe("Cannot resume contest: Claim ID missing from config!");
            this.clearFullContestData();
            this.plugin.cfg.saveClaimContest();
            this.currentPhase = Phase.PENDING;
            return;
        }
        long now = System.currentTimeMillis();
        switch (this.currentPhase.ordinal()) {
            case 1: {
                this.contestEndTimeMillis = data.getLong(PRE_REVEAL_END_TIMESTAMP_KEY, -1L);
                if (now >= this.contestEndTimeMillis) {
                    this.plugin.getLogger().warning("Pre-Reveal phase ended while server was down. Advancing...");
                    this.modePreReveal = data.getBoolean(MODE_PRE_REVEAL_KEY);
                    this.preRevealDurationMillis = data.getLong(DURATION_PRE_REVEAL_KEY);
                    this.contestDurationMillis = this.getDataLong(DURATION_KEY);
                    this.scheduler.runTask((Plugin)this.plugin, () -> this.transitionToPhase(Phase.ACTIVE));
                    break;
                }
                this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickPreReveal, 0L, 20L);
                this.plugin.getLogger().info("Pre-Reveal phase resumed. Ends in " + this.formatDuration(this.contestEndTimeMillis - now));
                break;
            }
            case 2: {
                this.contestStartTimeMillis = data.getLong(START_TIMESTAMP_KEY, -1L);
                if (commandStartTimeLoaded <= 0L) {
                    this.plugin.getLogger().warning("COMMAND_START_TIMESTAMP_KEY missing when resuming ACTIVE phase. Cannot calculate full duration on end.");
                }
                if (this.modeHold) {
                    this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickActiveHoldMode, 0L, 20L);
                    this.plugin.getLogger().info("Active (Hold Mode) phase resumed. Waiting for claim.");
                    this.updateActiveHoldModeScoreboards();
                    break;
                }
                this.contestEndTimeMillis = data.getLong(CONTEST_END_TIMESTAMP_KEY, -1L);
                if (now >= this.contestEndTimeMillis) {
                    this.plugin.getLogger().warning("Standard contest phase ended while server was down. Finalizing...");
                    String finalClaimant = data.getString(CURRENT_CLAIMANT_KEY, NO_CLAIMANT);
                    this.scheduler.runTask((Plugin)this.plugin, () -> this.handleContestEnd(finalClaimant));
                    break;
                }
                this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickStandard, 0L, 20L);
                this.plugin.getLogger().info("Standard contest phase resumed. Ends in " + this.formatDuration(this.contestEndTimeMillis - now));
                this.updateStandardScoreboards(this.contestEndTimeMillis - now);
                break;
            }
            case 3: {
                this.currentHolderName = data.getString(CURRENT_HOLDER_KEY, NO_CLAIMANT);
                long holdEnds = data.getLong(HOLD_END_TIMESTAMP_KEY, -1L);
                this.holdEndTimeMillis.set(holdEnds);
                if (commandStartTimeLoaded <= 0L) {
                    this.plugin.getLogger().warning("COMMAND_START_TIMESTAMP_KEY missing when resuming HOLD phase. Cannot calculate full duration on end.");
                }
                if (this.currentHolderName.equals(NO_CLAIMANT) || holdEnds <= 0L) {
                    this.plugin.getLogger().warning("Inconsistent HOLD phase state found. Resetting to ACTIVE.");
                    this.scheduler.runTask((Plugin)this.plugin, () -> this.transitionToPhase(Phase.ACTIVE));
                    return;
                }
                if (now >= holdEnds) {
                    this.plugin.getLogger().warning("Hold phase ended while server was down. Finalizing for holder: " + this.currentHolderName);
                    this.scheduler.runTask((Plugin)this.plugin, () -> this.handleContestEnd(this.currentHolderName));
                    break;
                }
                this.mainTask = this.scheduler.runTaskTimer((Plugin)this.plugin, this::tickHold, 0L, 20L);
                this.plugin.getLogger().info("Hold phase resumed for " + this.currentHolderName + ". Ends in " + this.formatDuration(holdEnds - now));
                this.updateHoldScoreboards(holdEnds - now);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        boolean configLocked;
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> possibilities = new ArrayList<String>();
        String currentArg = args[args.length - 1].toLowerCase();
        boolean bl = configLocked = this.currentPhase != Phase.PENDING && this.currentPhase != Phase.FINISHED;
        if (args.length == 1) {
            possibilities.addAll(Arrays.asList("help", "start", "cancel", "status"));
            if (!configLocked) {
                possibilities.addAll(Arrays.asList("chunk", DURATION_KEY, PRIZE_KEY, "mode"));
            }
        } else if (args.length >= 2) {
            String subCommand = args[0].toLowerCase();
            if (!configLocked) {
                switch (subCommand) {
                    case "chunk": 
                    case "loc": 
                    case "at": 
                    case "xyz": {
                        if (args.length == 2) {
                            possibilities.addAll(Arrays.asList("overworld", "nether", "end"));
                            break;
                        }
                        if (args.length == 3 && sender instanceof Player) {
                            possibilities.add(String.valueOf(((Player)sender).getLocation().getBlockX()));
                            possibilities.add("<X>");
                            break;
                        }
                        if (args.length != 4 || !(sender instanceof Player)) break;
                        possibilities.add(String.valueOf(((Player)sender).getLocation().getBlockZ()));
                        possibilities.add("<Z>");
                        break;
                    }
                    case "duration": 
                    case "time": {
                        if (args.length == 2) {
                            possibilities.add("<e.g., 1h 30m>");
                            break;
                        }
                        possibilities.addAll(Arrays.asList("d", "h", "m", "s"));
                        break;
                    }
                    case "prize": {
                        if (args.length != 2) break;
                        possibilities.add("<description>");
                        break;
                    }
                    case "mode": {
                        if (args.length == 2) {
                            possibilities.addAll(Arrays.asList("pre_reveal", "hold", "standard"));
                            break;
                        }
                        if (args.length == 3 && (args[1].equalsIgnoreCase("pre_reveal") || args[1].equalsIgnoreCase("hold"))) {
                            possibilities.add("<e.g., 5m>");
                            break;
                        }
                        if (args.length <= 3 || !args[1].equalsIgnoreCase("pre_reveal") && !args[1].equalsIgnoreCase("hold")) break;
                        possibilities.addAll(Arrays.asList("d", "h", "m", "s"));
                    }
                }
            }
        }
        for (String p : possibilities) {
            if (!p.toLowerCase().startsWith(currentArg)) continue;
            completions.add(p);
        }
        return completions;
    }

    public static enum Phase {
        PENDING,
        PRE_REVEAL,
        ACTIVE,
        HOLD,
        FINISHED;

    }
}

