/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class ClaimFixCommand
implements CommandExecutor {
    private final Block4Block plugin;

    public ClaimFixCommand(Block4Block plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("confirm")) {
            FileConfiguration claimData = this.plugin.cfg.getClaimData();
            FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
            if (this.plugin.cfg.backupClaimData() && this.plugin.cfg.backupOfflineClaimNotifications() && this.plugin.cfg.backupMasterBooks()) {
                Set allClaimIDs = claimData.getKeys(false);
                int fixedMembersCount = 0;
                for (String cID : allClaimIDs) {
                    Object membersObj = claimData.get(cID + ".members");
                    if (!(membersObj instanceof List)) continue;
                    List membersList = (List)membersObj;
                    String membersString = String.join((CharSequence)"\n", membersList);
                    claimData.set(cID + ".members", (Object)membersString);
                    ++fixedMembersCount;
                    sender.sendMessage("Fixed corrupted members data for claim " + cID);
                }
                if (fixedMembersCount > 0) {
                    this.plugin.cfg.saveClaimData();
                    sender.sendMessage("Fixed " + fixedMembersCount + " corrupted claim(s) with invalid members data structure.");
                }
                for (String cID : allClaimIDs) {
                    double x = claimData.getDouble(cID + ".location.X");
                    double y = claimData.getDouble(cID + ".location.Y");
                    double z = claimData.getDouble(cID + ".location.Z");
                    String envName = cID.split("\\|")[0];
                    for (World world : Bukkit.getWorlds()) {
                        World.Environment env = World.Environment.valueOf((String)envName);
                        if (env != world.getEnvironment()) continue;
                        Block block = world.getBlockAt((int)x, (int)y, (int)z);
                        String xyz = x + ", " + y + ", " + z;
                        if (block.getType() != Material.LECTERN) {
                            this.removeClaim(claimData, cID, xyz);
                            sender.sendMessage("Removed claim " + cID + " at (" + xyz + ") in " + utils.getWorldName(env));
                            continue;
                        }
                        String claimID = utils.getClaimID(block.getLocation());
                        if (claimID.equals(cID)) continue;
                        String[] members = claimData.getString(cID + ".members", "").split("\\n");
                        this.removeClaim(claimData, cID, xyz);
                        sender.sendMessage("Lectern outside claim: Removed claim " + cID + " at (" + xyz + ") in " + utils.getWorldName(env));
                        if (allClaimIDs.contains(claimID)) continue;
                        utils.claimChunk(block, Arrays.stream(members).toList(), null);
                        sender.sendMessage("Lectern outside claim: Added claim " + claimID + " at (" + xyz + ") in " + utils.getWorldName(env));
                    }
                }
                for (String mbook : masterBooks.getKeys(false)) {
                    if (mbook.equalsIgnoreCase("next-id")) continue;
                    List copies = masterBooks.getStringList(mbook + ".copies-on-lecterns");
                    ArrayList<String> copiesToRemove = new ArrayList<String>();
                    for (String copy : copies) {
                        String[] parts = copy.split("!");
                        String claimID = parts[0];
                        CharSequence[] xyz = parts[1].split(",");
                        String environment = claimID.split("\\|")[0];
                        World.Environment env = World.Environment.valueOf((String)environment);
                        int x = Integer.parseInt(xyz[0]);
                        int y = Integer.parseInt(xyz[1]);
                        int z = Integer.parseInt(xyz[2]);
                        for (World world : Bukkit.getWorlds()) {
                            Block block;
                            if (world.getEnvironment() != env || (block = world.getBlockAt(x, y, z)).getType() == Material.LECTERN) continue;
                            copiesToRemove.add(copy);
                            sender.sendMessage("Removed from Master Book #" + mbook + " copies-on-lecterns: (" + String.join((CharSequence)", ", xyz) + ") in " + utils.getWorldName(env));
                        }
                    }
                    for (String copy : copiesToRemove) {
                        copies.remove(copy);
                    }
                    masterBooks.set(mbook + ".copies-on-lecterns", (Object)copies);
                }
                this.plugin.cfg.saveClaimData();
                this.plugin.cfg.saveOfflineClaimNotifications();
                this.plugin.cfg.saveMasterBooks();
                utils.updateClaimCount();
                sender.sendMessage("Claim fix complete!");
                return true;
            }
        }
        return false;
    }

    private void removeClaim(FileConfiguration claimData, String cID, String xyz) {
        String[] members = claimData.getString(cID + ".members", "").split("\\n");
        claimData.set(cID, null);
        utils.onChunkUnclaim(cID, members, xyz, null);
    }
}

