/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClaimVisualCommand
implements CommandExecutor {
    private final Block4Block plugin;
    private final Set<UUID> visualEnabledPlayers;

    public ClaimVisualCommand(Block4Block plugin, Set<UUID> visualEnabledPlayers) {
        this.plugin = plugin;
        this.visualEnabledPlayers = visualEnabledPlayers;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            UUID playerUUID = player.getUniqueId();
            if (args.length == 1) {
                String action;
                switch (action = args[0].toLowerCase()) {
                    case "on": {
                        if (!this.visualEnabledPlayers.contains(playerUUID)) {
                            this.visualEnabledPlayers.add(playerUUID);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Claim visual enabled.");
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Claim visual is already enabled.");
                        }
                        return true;
                    }
                    case "off": {
                        if (this.visualEnabledPlayers.contains(playerUUID)) {
                            this.visualEnabledPlayers.remove(playerUUID);
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Claim visual disabled.");
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Claim visual is already disabled.");
                        }
                        return true;
                    }
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimvisual <on/off>");
                return false;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claimvisual <on/off>");
            return false;
        }
        return false;
    }
}

