/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CoordsCommand
implements CommandExecutor,
TabCompleter {
    private final Block4Block plugin;
    private final Set<String> validArgs = Set.of("off", "on");

    public CoordsCommand(Block4Block plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length > 0) {
                FileConfiguration coordsSettings = this.plugin.cfg.getCoordsSettings();
                String pUUID = player.getUniqueId().toString();
                String arg = args[0];
                if (this.validArgs.contains(arg)) {
                    coordsSettings.set(pUUID, (Object)arg.toLowerCase());
                    this.plugin.cfg.saveCoordsSettings();
                    player.sendMessage("Coords in system messages are now " + String.valueOf(ChatColor.RED) + arg.toUpperCase());
                    utils.updateBossBar(player, utils.getClaimID(player.getLocation()));
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.add("on");
            suggestions.add("off");
        }
        return suggestions;
    }
}

