/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.HelpCmdSucceededEvent;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HelpCommand
implements CommandExecutor,
Listener {
    private final Block4Block plugin;
    private final Inventory inv;
    private final List<ItemStack> clickableItems = new ArrayList<ItemStack>();

    public HelpCommand(Block4Block plugin) {
        this.plugin = plugin;
        plugin.pluginManager.registerEvents((Listener)this, (Plugin)plugin);
        this.inv = Bukkit.createInventory(null, (int)36, (String)"Block4Block Help");
        this.initItems();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(String.valueOf(ChatColor.GOLD) + "Hover over each item and read its description.");
            p.sendMessage(String.valueOf(ChatColor.GRAY) + "If you can't read the text; go to options -> video settings -> GUI scale (recommended: 2).");
            p.openInventory(this.inv);
            this.plugin.pluginManager.callEvent((Event)new HelpCmdSucceededEvent(p));
            return true;
        }
        return false;
    }

    public void initItems() {
        ItemStack oakLogItem = this.createItem(Material.OAK_LOG, "\u00a7bBasics: \u00a7eBlocks that can be broken.", "\u00a7fSome blocks can still be broken normally.", "\u00a77Trees can be broken down freely.", "\u00a77Use logs for any temporary structures.", "\u00a77Utilities such as crafting tables and beds are also exempt.", "\u00a7cClick this item for a full list in chat.");
        ItemStack redstoneBlock = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cClaim: \u00a7eBlocks that can be broken inside owned claim.", "\u00a77Inside your claim, you can break more blocks normally.", "\u00a77This applies mostly to redstone related items.", "\u00a7cClick this item for a full list in chat.");
        ItemStack writableBook = this.createItem(Material.WRITABLE_BOOK, "\u00a7cClaim: \u00a7eHow to make a claim book.", "\u00a77Use a book and quill and follow the below format.", "\u00a77Include yourself in the list to be a part of the claim.", "\u00a77You can place a claim for others.", "\u00a77See chat when placing your claim.", "\u00a77If done correctly, your memberlist will appear.", "\u00a7cClick this item for a link to an example.");
        this.clickableItems.add(oakLogItem);
        this.clickableItems.add(redstoneBlock);
        this.clickableItems.add(writableBook);
        this.inv.setItem(1, this.createItem(Material.STRUCTURE_VOID, "\u00a7bBasics: \u00a7eGrace Period", "\u00a77Within 5 seconds of placing a block you can break it freely.", "\u00a77Other players can break it freely as well.", "\u00a77Be sure to correct building mistakes as they happen."));
        this.inv.setItem(3, this.createItem(Material.GRASS_BLOCK, "\u00a7bBasics: \u00a7eWhy can't I break blocks?", "\u00a77Most blocks require you to have them when breaking them.", "\u00a77It costs a block to break them.", "\u00a77The item has to be in 1-9 or off-hand.", "\u00a77Experience meaningful progression", "\u00a77and significantly reduced griefing.", "\u00a77Consider it a Veteran Mode. Enjoy!"));
        this.inv.setItem(4, oakLogItem);
        this.inv.setItem(5, this.createItem(Material.STONE, "\u00a7bBasics: \u00a7eAdvanced Mining", "\u00a77Stone still drops cobble.", "\u00a7710% chance of double drop.", "\u00a77Smelting cobble back into stone makes it reusable.", "\u00a77Use ravines and caves to reach a low y.", "\u00a77Build ladders and platforms to reach ores in ravines.", "\u00a77You will have to navigate around diorite and granite.", "\u00a77No tunneling out without the right blocks.", "\u00a77Use signs to find back. "));
        this.inv.setItem(7, this.createItem(Material.RED_BED, "\u00a7bCommand: \u00a7e/bed", "\u00a77Be given a bed.", "\u00a77Has a 24 hour cooldown."));
        this.inv.setItem(9, this.createItem(Material.SKELETON_SKULL, "\u00a7aLoot: \u00a7eSkeletons drop stone", "\u00a77Stone is easiest obtained from skeletons.", "\u00a77It's recommended to get a shield.", "\u00a77Farming leather may help you boost your defenses.", "\u00a77Seek dark areas or make one for enemies to spawn.", "\u00a77Mobfarms are the easiest way to get a lot of stone."));
        this.inv.setItem(10, this.createItem(Material.SPAWNER, "\u00a7aLoot: \u00a7eSpawners drop", "\u00a77You can break and obtain spawners with any pickaxe.", "\u00a77No silk-touch needed.", "\u00a77Find a skeleton spawner to increase your stone production."));
        this.inv.setItem(11, this.createItem(Material.DIRT, "\u00a7aLoot: \u00a7ePigs drop dirt", "\u00a77Dirt can be gained from pigs.", "\u00a77Farm it to terraform your area.", "\u00a77Use tricks to change grassblocks into dirt.", "\u00a77Try placing a block on top or using a hoe."));
        this.inv.setItem(12, this.createItem(Material.ICE, "\u00a7aLoot: \u00a7eThere is more", "\u00a77There are more changes for you to seek out and discover.", "\u00a77consider sharing your discoveries on Discord."));
        this.inv.setItem(15, this.createItem(Material.SAND, "\u00a76Tricks: \u00a7eObtain blocks affected by gravity.", "\u00a77Blocks affected by gravity become drops, if they fall on torches.", "\u00a77You will have to find a way to break a block to make the blocks fall.", "\u00a77Place the torch as soon as they begin falling.", "\u00a77Make sure they can't fall beyond the torch."));
        this.inv.setItem(16, this.createItem(Material.WATER_BUCKET, "\u00a76Tricks: \u00a7eObtain blocks using water.", "\u00a77Flowers become drops when interacting with water.", "\u00a77Redstone wire and more is affected as well."));
        this.inv.setItem(17, this.createItem(Material.PISTON, "\u00a76Tricks: \u00a7eObtaining blocks using a piston", "\u00a77Watermelons, pumpkins and bamboo will drop when pushed by a piston.", "\u00a77If a piston doesn't work, try with TNT."));
        this.inv.setItem(19, this.createItem(Material.LECTERN, "\u00a7cClaim: \u00a7ePlacing a claim.", "\u00a77Use F3+G to see chunk borders.", "\u00a77Place the lectern in the area you wish to claim.", "\u00a77Put a claim book in the lectern to place your claim.", "\u00a77You cannot place a claim next to bedrock."));
        this.inv.setItem(20, this.createItem(Material.BARRIER, "\u00a7cClaim: \u00a7eWhat does a claim do?", "\u00a77Claims prevent non-members from placing blocks.", "\u00a77Players can still break blocks inside your claim.", "\u00a77By holding TAB you can see how many claims you and others have.", "\u00a77You can steal a claim by taking the book or breaking the lectern.", "\u00a77To break a lectern, remove any blocks in direct contact with it first. Bottom is excluded."));
        this.inv.setItem(21, this.createItem(Material.IRON_BLOCK, "\u00a7cClaim: \u00a7eProtecting a claim.", "\u00a77Protect your claim by surrounding your lectern with blocks.", "\u00a77Choose blocks you believe infiltrators won't expect.", "\u00a77Use redstone traps and doors to stop them from reaching your lectern.", "\u00a77Nametag strong mobs and have them guard the lectern for you.", "\u00a77Blocks affected by gravity can be pillared on each side of the lectern.", "\u00a77Be aware the lectern breaks gravity blocks landing on it."));
        this.inv.setItem(22, writableBook);
        this.inv.setItem(23, this.createItem(Material.BOOK, "\u00a7cClaim: \u00a7eUsing a signed book for claiming.", "\u00a77You can claim using a signed book as well.", "\u00a77Signed books identify the original author.", "\u00a77Copy the signed book to easily create many claims.", "\u00a77You can't change the memberlist of signed books.", "\u00a77You can tell if it's the original or a copy.", "\u00a77Use others' signed books to create conflicts."));
        this.inv.setItem(24, redstoneBlock);
        this.inv.setItem(30, this.createItem(Material.EGG, "\u00a7dSecret: \u00a7eChickens lay many eggs.", new String[0]));
        this.inv.setItem(32, this.createItem(Material.YELLOW_WOOL, "\u00a7dSecret: \u00a7eSheep are colorful and so are blocks.", new String[0]));
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        return this.createItem(item, name, lore);
    }

    private ItemStack createItem(ItemStack item, String name, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() == this.inv) {
            HumanEntity whoClicked = e.getWhoClicked();
            if (this.clickableItems.contains(e.getCurrentItem())) {
                whoClicked.spigot().sendMessage(new ComponentBuilder(utils.chat("&aCLICK HERE for more information")).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://hasjamon.github.io/b4block/lists.html")).create());
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        if (e.getInventory() == this.inv) {
            e.setCancelled(true);
        }
    }
}

