/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.command;

import hasjamon.block4block.Block4Block;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class IgnoreCommand
implements CommandExecutor,
TabCompleter {
    private final Block4Block plugin;

    public IgnoreCommand(Block4Block plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && sender instanceof Player) {
            FileConfiguration ignoreLists = this.plugin.cfg.getIgnoreLists();
            String ignoreeName = args[0];
            List ignoreeCandidates = Bukkit.matchPlayer((String)ignoreeName);
            Player ignorer = (Player)sender;
            if (ignoreeCandidates.size() != 1) {
                return false;
            }
            Player ignoree = (Player)ignoreeCandidates.get(0);
            String field = String.valueOf(ignoree.getUniqueId()) + "." + String.valueOf(ignorer.getUniqueId());
            long until = System.currentTimeMillis();
            switch (label.toLowerCase()) {
                case "ignore": {
                    if (args.length == 2) {
                        if (args[1].matches("[0-9]+")) {
                            until = (long)((double)until + (double)Long.parseLong(args[1]) * 60000.0);
                            break;
                        }
                        return false;
                    }
                    until *= 2L;
                    break;
                }
                case "unignore": {
                    until = 0L;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.sendIgnoreMessage(ignorer, ignoreeName, System.currentTimeMillis() < until);
            ignoreLists.set(field, (Object)until);
            this.plugin.cfg.saveIgnoreLists();
            return true;
        }
        return false;
    }

    private void sendIgnoreMessage(Player ignorer, String ignoreeName, boolean shouldIgnore) {
        if (shouldIgnore) {
            ignorer.sendMessage("Messages from " + ignoreeName + " are now " + String.valueOf(ChatColor.RED) + "OFF");
        } else {
            ignorer.sendMessage("Messages from " + ignoreeName + " are now " + String.valueOf(ChatColor.GREEN) + "ON");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.getName().equals(sender.getName())) continue;
                suggestions.add(p.getName());
            }
        }
        if (args.length == 2 && cmd.getName().equalsIgnoreCase("ignore")) {
            suggestions.add("<minutes>");
        }
        return suggestions;
    }
}

