/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.files;

import hasjamon.block4block.Block4Block;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockFace;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Block4Block plugin = (Block4Block)Block4Block.getPlugin(Block4Block.class);
    private final ConsoleCommandSender consoleSender = Bukkit.getServer().getConsoleSender();
    private final File claimDataFile = new File(this.plugin.getDataFolder(), "claimdata.yml");
    private final FileConfiguration claimDataCfg = YamlConfiguration.loadConfiguration((File)this.claimDataFile);
    private final File hintSettingsFile = new File(this.plugin.getDataFolder(), "hintsettings.yml");
    private final FileConfiguration hintSettingsCfg = YamlConfiguration.loadConfiguration((File)this.hintSettingsFile);
    private final File ignoreListsFile = new File(this.plugin.getDataFolder(), "ignorelists.yml");
    private final FileConfiguration ignoreListsCfg = YamlConfiguration.loadConfiguration((File)this.ignoreListsFile);
    private final File claimContestFile = new File(this.plugin.getDataFolder(), "claimcontest.yml");
    private final FileConfiguration claimContestCfg = YamlConfiguration.loadConfiguration((File)this.claimContestFile);
    private final File complimentaryBedUsageFile = new File(this.plugin.getDataFolder(), "complimentarybedusage.yml");
    private final FileConfiguration complimentaryBedUsageCfg = YamlConfiguration.loadConfiguration((File)this.complimentaryBedUsageFile);
    private final File masterBooksFile = new File(this.plugin.getDataFolder(), "masterbooks.yml");
    private final FileConfiguration masterBooksCfg = YamlConfiguration.loadConfiguration((File)this.masterBooksFile);
    private final File offlineClaimNotificationsFile = new File(this.plugin.getDataFolder(), "offlineclaimnotifications.yml");
    private final FileConfiguration offlineClaimNotificationsCfg = YamlConfiguration.loadConfiguration((File)this.offlineClaimNotificationsFile);
    private final File playerTexturesFile = new File(this.plugin.getDataFolder(), "playertextures.yml");
    private final FileConfiguration playerTexturesCfg = YamlConfiguration.loadConfiguration((File)this.playerTexturesFile);
    private final File claimTakeoversFile = new File(this.plugin.getDataFolder(), "claimtakeovers.yml");
    private final FileConfiguration claimTakeoversCfg = YamlConfiguration.loadConfiguration((File)this.claimTakeoversFile);
    private final File claimMapsFile = new File(this.plugin.getDataFolder(), "claimmaps.yml");
    private final FileConfiguration claimMapsCfg = YamlConfiguration.loadConfiguration((File)this.claimMapsFile);
    private final File coordsSettingsFile = new File(this.plugin.getDataFolder(), "coordssettings.yml");
    private final FileConfiguration coordsSettingsCfg = YamlConfiguration.loadConfiguration((File)this.coordsSettingsFile);

    public ConfigManager() {
        if (!this.plugin.getDataFolder().exists() && !this.plugin.getDataFolder().mkdir()) {
            this.consoleSender.sendMessage("Failed to create data folder.");
        }
        this.saveConfigAsDefault();
        this.saveClaimData();
        this.saveHintSettings();
        this.saveIgnoreLists();
        this.saveClaimContest();
        this.saveComplimentaryBedUsage();
        this.saveMasterBooks();
        this.saveOfflineClaimNotifications();
        this.savePlayerTextures();
        this.saveClaimTakeovers();
        this.saveClaimMaps();
        this.saveCoordsSettings();
    }

    private void saveConfigAsDefault() {
        File defaultFile = new File(this.plugin.getDataFolder(), "default.yml");
        InputStream cfgStream = this.plugin.getResource("config.yml");
        if (cfgStream != null) {
            try {
                Files.copy(cfgStream, defaultFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save default.yml");
            }
        }
    }

    public FileConfiguration getClaimData() {
        return this.claimDataCfg;
    }

    public void saveClaimData() {
        try {
            this.claimDataCfg.save(this.claimDataFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Claim data has been saved to claimdata.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save claim data to claimdata.yml");
        }
    }

    public boolean backupClaimData() {
        String backupName = "claimdata-backup-" + System.currentTimeMillis() + ".yml";
        File backupFile = new File(this.plugin.getDataFolder(), backupName);
        try {
            this.claimDataCfg.save(backupFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Claim data has been backed up to " + backupName);
            return true;
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to back up claim data to " + backupName);
            return false;
        }
    }

    public FileConfiguration getHintSettings() {
        return this.hintSettingsCfg;
    }

    public void saveHintSettings() {
        try {
            this.hintSettingsCfg.save(this.hintSettingsFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Hint settings have been saved to hintsettings.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save hint settings to hintsettings.yml");
        }
    }

    public FileConfiguration getIgnoreLists() {
        return this.ignoreListsCfg;
    }

    public void saveIgnoreLists() {
        try {
            this.ignoreListsCfg.save(this.ignoreListsFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Ignore lists have been saved to ignorelists.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save ignore lists to ignorelists.yml");
        }
    }

    public FileConfiguration getClaimContest() {
        return this.claimContestCfg;
    }

    public void saveClaimContest() {
        try {
            this.claimContestCfg.save(this.claimContestFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Claim contest has been saved to claimcontest.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save claim contest to claimcontest.yml");
        }
    }

    public void clearClaimContest() {
        this.claimContestCfg.set("data", null);
        this.saveClaimContest();
    }

    public FileConfiguration getComplimentaryBedUsage() {
        return this.complimentaryBedUsageCfg;
    }

    public void saveComplimentaryBedUsage() {
        try {
            this.complimentaryBedUsageCfg.save(this.complimentaryBedUsageFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Complimentary bed usage has been saved to complimentarybedusage.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save complimentary bed usage to complimentarybedusage.yml");
        }
    }

    public FileConfiguration getMasterBooks() {
        return this.masterBooksCfg;
    }

    public void saveMasterBooks() {
        try {
            this.masterBooksCfg.save(this.masterBooksFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Master books have been saved to masterbooks.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save master books to masterbooks.yml");
        }
    }

    public boolean backupMasterBooks() {
        String backupName = "masterbooks-backup-" + System.currentTimeMillis() + ".yml";
        File backupFile = new File(this.plugin.getDataFolder(), backupName);
        try {
            this.masterBooksCfg.save(backupFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Master books have been backed up to " + backupName);
            return true;
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to back up master books to " + backupName);
            return false;
        }
    }

    public FileConfiguration getOfflineClaimNotifications() {
        return this.offlineClaimNotificationsCfg;
    }

    public void saveOfflineClaimNotifications() {
        try {
            this.offlineClaimNotificationsCfg.save(this.offlineClaimNotificationsFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Offline claim notifications have been saved to offlineclaimnotifications.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save offline claim notifications to offlineclaimnotifications.yml");
        }
    }

    public boolean backupOfflineClaimNotifications() {
        String backupName = "offlineclaimnotifications-backup-" + System.currentTimeMillis() + ".yml";
        File backupFile = new File(this.plugin.getDataFolder(), backupName);
        try {
            this.offlineClaimNotificationsCfg.save(backupFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Offline claim notifications have been backed up to " + backupName);
            return true;
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to back up offline claim notifications to " + backupName);
            return false;
        }
    }

    public FileConfiguration getPlayerTextures() {
        return this.playerTexturesCfg;
    }

    public void savePlayerTextures() {
        try {
            this.playerTexturesCfg.save(this.playerTexturesFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Player textures have been saved to playertextures.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save player textures to playertextures.yml");
        }
    }

    public FileConfiguration getClaimTakeovers() {
        return this.claimTakeoversCfg;
    }

    public void saveClaimTakeovers() {
        try {
            this.claimTakeoversCfg.save(this.claimTakeoversFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Claim takeovers have been saved to claimtakeovers.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save claim takeovers to claimtakeovers.yml");
        }
    }

    public FileConfiguration getClaimMaps() {
        return this.claimMapsCfg;
    }

    public void saveClaimMaps() {
        try {
            this.claimMapsCfg.save(this.claimMapsFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Claim maps have been saved to claimmaps.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save claim maps to claimmaps.yml");
        }
    }

    public FileConfiguration getCoordsSettings() {
        return this.coordsSettingsCfg;
    }

    public void saveCoordsSettings() {
        try {
            this.coordsSettingsCfg.save(this.coordsSettingsFile);
            this.consoleSender.sendMessage(String.valueOf(ChatColor.AQUA) + "Coords settings have been saved to coordssettings.yml");
        }
        catch (IOException e) {
            this.consoleSender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save coords settings to coordssettings.yml");
        }
    }

    public Set<BlockFace> getProtectiveBlockFaces() {
        HashSet<BlockFace> protectiveBlockFaces = new HashSet<BlockFace>();
        FileConfiguration config = this.plugin.getConfig();
        if (config.contains("claim-protection.protective-block-faces")) {
            for (String face : config.getStringList("claim-protection.protective-block-faces")) {
                try {
                    BlockFace blockFace = BlockFace.valueOf((String)face.toUpperCase());
                    protectiveBlockFaces.add(blockFace);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid block face in config: " + face);
                }
            }
        }
        return protectiveBlockFaces;
    }
}

