/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.B4BlockBreakWithinGracePeriodEvent;
import hasjamon.block4block.events.BlockBreakInClaimEvent;
import hasjamon.block4block.utils.utils;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.DoubleChest;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;

public class BlockBreak
implements Listener {
    private final Block4Block plugin;
    private long andesiteLatestBreak = 0L;

    public BlockBreak(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Chest chestState;
        Player p = e.getPlayer();
        Block b = e.getBlock();
        FileConfiguration cfg = this.plugin.getConfig();
        boolean isInsideClaim = this.plugin.cfg.getClaimData().contains(utils.getClaimID(b.getLocation()));
        if (isInsideClaim && b.getType() == Material.CHEST) {
            String[] members = utils.getMembers(b.getLocation());
            boolean isMember = utils.isMemberOfClaim(members, (OfflinePlayer)p);
            boolean canOpen = utils.canOpenChest(b, p);
            if (!isMember && !canOpen) {
                e.setCancelled(true);
                String message = utils.chat("&cThe chest is shielded by the blocks above it.");
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                return;
            }
        }
        if (b.getType() == Material.CHEST && (chestState = (Chest)b.getState()).getInventory().getHolder() instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)chestState.getInventory().getHolder();
            Chest leftSide = (Chest)doubleChest.getLeftSide();
            Chest rightSide = (Chest)doubleChest.getRightSide();
            boolean isLeftSide = leftSide.getLocation().equals((Object)b.getLocation());
            boolean inOwnClaim = false;
            if (isInsideClaim) {
                String[] members = utils.getMembers(b.getLocation());
                inOwnClaim = utils.isMemberOfClaim(members, (OfflinePlayer)p);
            }
            if (!inOwnClaim) {
                boolean hasChest = false;
                if (p.getInventory().getItemInOffHand().getType() == Material.CHEST) {
                    p.getInventory().getItemInOffHand().setAmount(p.getInventory().getItemInOffHand().getAmount() - 1);
                    hasChest = true;
                } else {
                    for (int i = 0; i < 9; ++i) {
                        ItemStack item = p.getInventory().getItem(i);
                        if (item == null || item.getType() != Material.CHEST) continue;
                        item.setAmount(item.getAmount() - 1);
                        hasChest = true;
                        break;
                    }
                }
                if (!hasChest) {
                    e.setCancelled(true);
                    String message = utils.chat("&aYou need a &cCHEST &ain your hotbar to break this!");
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                    return;
                }
            }
            e.setCancelled(true);
            ItemStack[] allContents = chestState.getInventory().getContents();
            int startSlot = isLeftSide ? 0 : 27;
            int endSlot = isLeftSide ? 26 : 53;
            for (int i = startSlot; i <= endSlot; ++i) {
                if (i >= allContents.length || allContents[i] == null || allContents[i].getType() == Material.AIR) continue;
                b.getWorld().dropItemNaturally(b.getLocation(), allContents[i]);
                chestState.getInventory().setItem(i, null);
            }
            b.setType(Material.AIR);
            if (inOwnClaim) {
                b.getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.CHEST, 1));
            }
            return;
        }
        if (b.getType() == Material.LECTERN) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        List claimBlacklist = cfg.getList("blacklisted-claim-blocks");
        if (isInsideClaim) {
            String[] members;
            if (utils.isAdjacentToClaimBlock(b)) {
                String claimID = utils.getClaimID(b.getLocation());
                utils.updateBossBar(p, claimID);
            }
            if (!utils.isClaimBlock(b) && (members = utils.getMembers(b.getLocation())) != null) {
                if (utils.isMemberOfClaim(members, (OfflinePlayer)p)) {
                    if (this.plugin.getConfig().getBoolean("only-apply-b4b-to-intruders")) {
                        this.plugin.pluginManager.callEvent((Event)new BlockBreakInClaimEvent(p, b, true));
                        return;
                    }
                    if (claimBlacklist != null && claimBlacklist.contains(b.getType().toString())) {
                        this.plugin.pluginManager.callEvent((Event)new BlockBreakInClaimEvent(p, b, true));
                        return;
                    }
                } else if (!cfg.getBoolean("can-break-in-others-claims")) {
                    e.setCancelled(true);
                    p.sendMessage(utils.chat("&cYou cannot break blocks in this claim"));
                    this.plugin.pluginManager.callEvent((Event)new BlockBreakInClaimEvent(p, b, false));
                    return;
                }
            }
        }
        if (this.plugin.getConfig().getBoolean("andesite-splash-on") && b.getType() == Material.ANDESITE) {
            if ((double)(System.nanoTime() - this.andesiteLatestBreak) > 1.0E8) {
                this.andesiteLatestBreak = System.nanoTime();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x == 0 && y == 0 && z == 0 || b.getRelative(x, y, z).getType() != Material.ANDESITE) continue;
                            if (this.plugin.getConfig().getBoolean("andesite-splash-reduce-durability")) {
                                p.breakBlock(b.getRelative(x, y, z));
                                continue;
                            }
                            b.getRelative(x, y, z).breakNaturally(p.getInventory().getItemInMainHand());
                        }
                    }
                }
            }
            return;
        }
        if (!isInsideClaim && this.plugin.getConfig().getBoolean("only-apply-b4b-to-intruders")) {
            return;
        }
        List blacklistedBlocks = cfg.getList("blacklisted-blocks");
        List lootDisabledTypes = cfg.getList("no-loot-on-break");
        if (blacklistedBlocks != null && lootDisabledTypes != null) {
            boolean requiresBlock = !blacklistedBlocks.contains(b.getType().toString());
            boolean isFreeToBreakInClaim = claimBlacklist != null && claimBlacklist.contains(b.getType().toString());
            utils.removeExpiredB4BGracePeriods();
            if (utils.b4bGracePeriods.containsKey(b)) {
                this.plugin.pluginManager.callEvent((Event)new B4BlockBreakWithinGracePeriodEvent(p, b, requiresBlock));
                return;
            }
            utils.b4bCheck(p, b, e, lootDisabledTypes, requiresBlock, isFreeToBreakInClaim);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpawnerBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Block b = e.getBlock();
        if (b.getType() == Material.SPAWNER) {
            Byte isPlayerPlaced;
            EntityType spawnType;
            CreatureSpawner spawner = (CreatureSpawner)b.getState();
            NamespacedKey placedKey = new NamespacedKey((Plugin)this.plugin, "playerPlaced");
            if (spawner.getPersistentDataContainer().has(placedKey, PersistentDataType.BYTE)) {
                e.setExpToDrop(0);
            }
            if ((spawnType = spawner.getSpawnedType()) == null) {
                return;
            }
            String expectedSpawnerType = spawnType.name();
            ItemStack spawnerItem = new ItemStack(Material.SPAWNER);
            ItemMeta itemMeta = spawnerItem.getItemMeta();
            if (spawner.getPersistentDataContainer().has(placedKey, PersistentDataType.BYTE) && ((isPlayerPlaced = (Byte)spawner.getPersistentDataContainer().get(placedKey, PersistentDataType.BYTE)) == null || isPlayerPlaced != 1)) {
                return;
            }
            boolean isInsideClaim = this.plugin.cfg.getClaimData().contains(utils.getClaimID(b.getLocation()));
            if (isInsideClaim) {
                String[] members = utils.getMembers(b.getLocation());
                boolean isMember = utils.isMemberOfClaim(members, (OfflinePlayer)p);
                if (!isMember) {
                    ItemMeta offHandMeta;
                    String storedType;
                    ItemMeta mainHandMeta;
                    boolean isCorrectItem = false;
                    int itemSlot = -1;
                    if (p.getInventory().getItemInMainHand().hasItemMeta() && (mainHandMeta = p.getInventory().getItemInMainHand().getItemMeta()) != null && mainHandMeta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING) && (storedType = (String)mainHandMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING)) != null && storedType.equals(expectedSpawnerType)) {
                        isCorrectItem = true;
                        itemSlot = p.getInventory().getHeldItemSlot();
                    }
                    if (!isCorrectItem && p.getInventory().getItemInOffHand().hasItemMeta() && (offHandMeta = p.getInventory().getItemInOffHand().getItemMeta()) != null && offHandMeta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING) && (storedType = (String)offHandMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING)) != null && storedType.equals(expectedSpawnerType)) {
                        isCorrectItem = true;
                        itemSlot = -2;
                    }
                    if (!isCorrectItem) {
                        for (int i = 0; i < 9; ++i) {
                            String storedType2;
                            ItemMeta hotbarMeta;
                            ItemStack item = p.getInventory().getItem(i);
                            if (item == null || !item.hasItemMeta() || (hotbarMeta = item.getItemMeta()) == null || !hotbarMeta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING) || (storedType2 = (String)hotbarMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING)) == null || !storedType2.equals(expectedSpawnerType)) continue;
                            isCorrectItem = true;
                            itemSlot = i;
                            break;
                        }
                    }
                    if (!isCorrectItem) {
                        e.setCancelled(true);
                        String message = utils.chat("&aSpend &c" + expectedSpawnerType + "_SPAWNER &afrom your hotbar to break this!");
                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                        return;
                    }
                    if (itemSlot == -2) {
                        ItemStack offhandItem = p.getInventory().getItemInOffHand();
                        offhandItem.setAmount(offhandItem.getAmount() - 1);
                        p.getInventory().setItemInOffHand((ItemStack)(offhandItem.getAmount() > 0 ? offhandItem : null));
                    } else if (itemSlot >= 0) {
                        ItemStack itemToRemove = p.getInventory().getItem(itemSlot);
                        itemToRemove.setAmount(itemToRemove.getAmount() - 1);
                        p.getInventory().setItem(itemSlot, (ItemStack)(itemToRemove.getAmount() > 0 ? itemToRemove : null));
                    }
                } else if (itemMeta != null) {
                    itemMeta.setDisplayName(utils.prettifyEnumName(spawnType) + " Spawner");
                    itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                    itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING, (Object)spawnType.name());
                    spawnerItem.setItemMeta(itemMeta);
                    b.getWorld().dropItemNaturally(b.getLocation(), spawnerItem);
                }
            } else if (itemMeta != null && spawnType != null) {
                itemMeta.setDisplayName(utils.prettifyEnumName(spawnType) + " Spawner");
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING, (Object)spawnType.name());
                spawnerItem.setItemMeta(itemMeta);
                b.getWorld().dropItemNaturally(b.getLocation(), spawnerItem);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent e) {
        String[] members;
        Player p = e.getPlayer();
        Block b = e.getBlock();
        String claimID = utils.getClaimID(b.getLocation());
        if (utils.isAir(b.getType())) {
            return;
        }
        if (this.plugin.cfg.getClaimData().contains(claimID) && (members = utils.getMembers(b.getLocation())) != null) {
            if (utils.isMemberOfClaim(members, (OfflinePlayer)p)) {
                return;
            }
            String message = utils.chat("&cYou cannot fill buckets in others claim");
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteractWithWaterBottle(PlayerInteractEvent e) {
        String[] members;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getClickedBlock() == null) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getClickedBlock();
        if (b.getType() != Material.DIRT) {
            return;
        }
        ItemStack item = null;
        if (e.getHand() == EquipmentSlot.HAND) {
            item = p.getInventory().getItemInMainHand();
        } else if (e.getHand() == EquipmentSlot.OFF_HAND) {
            item = p.getInventory().getItemInOffHand();
        }
        if (item == null || item.getType() != Material.POTION) {
            return;
        }
        if (!this.isWaterBottle(item)) {
            return;
        }
        String claimID = utils.getClaimID(b.getLocation());
        if (this.plugin.cfg.getClaimData().contains(claimID) && (members = utils.getMembers(b.getLocation())) != null) {
            if (utils.isMemberOfClaim(members, (OfflinePlayer)p)) {
                return;
            }
            String message = utils.chat("&cYou cannot convert dirt to mud in others claim");
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            e.setCancelled(true);
        }
    }

    private boolean isWaterBottle(ItemStack item) {
        if (item == null || item.getType() != Material.POTION) {
            return false;
        }
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            return meta.getBasePotionType() == PotionType.WATER;
        }
        catch (NoSuchMethodError e) {
            try {
                return meta.getBasePotionData().getType() == PotionType.WATER;
            }
            catch (Exception ignored) {
                return !meta.hasCustomEffects() && meta.getCustomEffects().isEmpty();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCopperScrape(PlayerInteractEvent e) {
        String[] members;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getClickedBlock() == null) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getClickedBlock();
        ItemStack item = e.getItem();
        if (item == null || !item.getType().name().endsWith("_AXE")) {
            return;
        }
        if (!b.getType().name().contains("COPPER")) {
            return;
        }
        String claimID = utils.getClaimID(b.getLocation());
        if (this.plugin.cfg.getClaimData().contains(claimID) && (members = utils.getMembers(b.getLocation())) != null) {
            if (utils.isMemberOfClaim(members, (OfflinePlayer)p)) {
                return;
            }
            String message = utils.chat("&cYou cannot scrape copper blocks in others claim");
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            e.setCancelled(true);
        }
    }
}

