/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.plugin.Plugin;

public class BlockFertilize
implements Listener {
    private final Block4Block plugin;
    private final Random random = new Random();
    private final int MIN_DELAY_TICKS = 5;
    private final int MAX_DELAY_TICKS = 20;
    private int MAX_SPREAD_DEPTH_WARPED;
    private int MAX_SPREAD_DEPTH_CRIMSON;
    private final int[][] OFFSETS = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, -1, 0}, {-1, 1, 0}, {1, -1, 0}, {1, 1, 0}, {-1, 0, -1}, {-1, 0, 1}, {1, 0, -1}, {1, 0, 1}, {0, -1, -1}, {0, -1, 1}, {0, 1, -1}, {0, 1, 1}};

    private int getRandomDelay() {
        return this.random.nextInt(16) + 5;
    }

    public BlockFertilize(Block4Block plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.MAX_SPREAD_DEPTH_WARPED = config.getInt("max-recursion-depth-warped");
        this.MAX_SPREAD_DEPTH_CRIMSON = config.getInt("max-recursion-depth-crimson");
        Bukkit.getLogger().info("Max recursion depth (Warped): " + this.MAX_SPREAD_DEPTH_WARPED);
        Bukkit.getLogger().info("Max recursion depth (Crimson): " + this.MAX_SPREAD_DEPTH_CRIMSON);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String claimID = utils.getClaimID(block.getLocation());
        String[] members = utils.getMembers(claimID);
        if (claimID != null && members != null && !utils.isMemberOfClaim(members, (OfflinePlayer)player)) {
            Bukkit.getLogger().info("Player does not have permission to fertilize here. Cancelling event.");
            event.setCancelled(true);
            return;
        }
        if (block.getType() == Material.NETHERRACK) {
            Material nyliumType = this.getDominantNyliumNearby(block);
            block.setType(nyliumType);
            this.spawnDustParticle(block, nyliumType);
            this.scheduleSpreadNylium(block, 0);
        }
    }

    private List<Block> getNearbyNetherrack(Block block) {
        ArrayList<Block> nearby = new ArrayList<Block>();
        for (int[] offset : this.OFFSETS) {
            Block relative = block.getRelative(offset[0], offset[1], offset[2]);
            Block blockAbove = relative.getRelative(0, 1, 0);
            if (relative.getType() != Material.NETHERRACK || !this.isNonBlockingAbove(blockAbove)) continue;
            nearby.add(relative);
        }
        return nearby;
    }

    private boolean isNonBlockingAbove(Block blockAbove) {
        Material type = blockAbove.getType();
        if (!blockAbove.getBlockData().isOccluding()) {
            return true;
        }
        if (this.isAllowedByTypeName(type.toString())) {
            return true;
        }
        return this.isExplicitlyAllowed(type);
    }

    private boolean isAllowedByTypeName(String typeName) {
        String[] allowedSuffixes;
        for (String suffix : allowedSuffixes = new String[]{"_FENCE", "_GATE", "_WALL", "_PLATE"}) {
            if (!typeName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private boolean isExplicitlyAllowed(Material type) {
        switch (type) {
            case OAK_FENCE: {
                return true;
            }
        }
        return false;
    }

    private void scheduleSpreadNylium(Block block, int depth) {
        Material nyliumType = block.getType();
        int maxDepth = this.getMaxDepth(nyliumType);
        if (depth < maxDepth) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.spreadNylium(block, depth + 1), (long)this.getRandomDelay());
        }
    }

    private void spreadNylium(Block block, int depth) {
        Material nyliumType = block.getType();
        double chance = nyliumType == Material.WARPED_NYLIUM ? 0.2 : 0.8;
        List<Block> netherrackBlocks = this.getNearbyNetherrack(block);
        for (Block netherrack : netherrackBlocks) {
            if (!(this.random.nextDouble() < chance)) continue;
            netherrack.setType(nyliumType);
            this.spawnDustParticle(netherrack, nyliumType);
            this.scheduleSpreadNylium(netherrack, depth);
        }
    }

    private int getMaxDepth(Material nyliumType) {
        if (nyliumType == Material.WARPED_NYLIUM) {
            return this.MAX_SPREAD_DEPTH_WARPED;
        }
        if (nyliumType == Material.CRIMSON_NYLIUM) {
            return this.MAX_SPREAD_DEPTH_CRIMSON;
        }
        return 0;
    }

    private void spawnDustParticle(Block block, Material nyliumType) {
        int i;
        Color[] warpedColors = new Color[]{Color.BLUE, Color.LIME};
        Color crimsonColor = Color.RED;
        Location center = block.getLocation().add(0.5, 1.0, 0.5);
        World world = block.getWorld();
        int particleCount = 20;
        double offsetX = 0.5;
        double offsetY = 0.5;
        double offsetZ = 0.5;
        for (i = 0; i < particleCount; ++i) {
            float particleSize = 0.3f + this.random.nextFloat() * 0.5f;
            Color particleColor = nyliumType == Material.WARPED_NYLIUM ? warpedColors[this.random.nextInt(warpedColors.length)] : crimsonColor;
            Particle.DustOptions dustOptions = new Particle.DustOptions(particleColor, particleSize);
            double randomX = (this.random.nextDouble() - 0.5) * offsetX * 2.0;
            double randomY = this.random.nextDouble() * offsetY * 0.7;
            double randomZ = (this.random.nextDouble() - 0.5) * offsetZ * 2.0;
            world.spawnParticle(Particle.DUST, center.clone().add(randomX, randomY, randomZ), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
        for (i = 0; i < 5; ++i) {
            float largeParticleSize = 0.6f + this.random.nextFloat() * 0.5f;
            Color largeParticleColor = nyliumType == Material.WARPED_NYLIUM ? warpedColors[this.random.nextInt(warpedColors.length)] : crimsonColor;
            Particle.DustOptions largeDustOptions = new Particle.DustOptions(largeParticleColor, largeParticleSize);
            double driftX = (this.random.nextDouble() - 0.5) * 0.2;
            double driftY = this.random.nextDouble() * 0.2;
            double driftZ = (this.random.nextDouble() - 0.5) * 0.2;
            world.spawnParticle(Particle.DUST, center.clone().add(driftX, driftY, driftZ), 1, 0.0, 0.0, 0.0, 0.0, (Object)largeDustOptions);
        }
    }

    private Material getDominantNyliumNearby(Block block) {
        int warpedCount = 0;
        int crimsonCount = 0;
        for (int[] offset : this.OFFSETS) {
            Block relative = block.getRelative(offset[0], offset[1], offset[2]);
            if (relative.getType() == Material.WARPED_NYLIUM) {
                ++warpedCount;
                continue;
            }
            if (relative.getType() != Material.CRIMSON_NYLIUM) continue;
            ++crimsonCount;
        }
        if (crimsonCount > warpedCount) {
            return Material.CRIMSON_NYLIUM;
        }
        if (warpedCount > crimsonCount) {
            return Material.WARPED_NYLIUM;
        }
        return this.random.nextBoolean() ? Material.WARPED_NYLIUM : Material.CRIMSON_NYLIUM;
    }
}

