/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.BlockPlaceInClaimEvent;
import hasjamon.block4block.utils.GracePeriod;
import hasjamon.block4block.utils.utils;
import java.util.HashMap;
import java.util.Optional;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockPlace
implements Listener {
    private final Block4Block plugin;
    private final HashMap<EntityType, EntityType> netherSpawnTypeTransformations = new HashMap();
    private final HashMap<EntityType, EntityType> nonNetherSpawnTypeTransformations = new HashMap();

    public BlockPlace(Block4Block plugin) {
        this.netherSpawnTypeTransformations.put(EntityType.SLIME, EntityType.MAGMA_CUBE);
        this.nonNetherSpawnTypeTransformations.put(EntityType.MAGMA_CUBE, EntityType.SLIME);
        this.netherSpawnTypeTransformations.put(EntityType.BREEZE, EntityType.BLAZE);
        this.nonNetherSpawnTypeTransformations.put(EntityType.BLAZE, EntityType.BREEZE);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent event) {
        Block block = event.getBlockPlaced();
        Player player = event.getPlayer();
        Material blockType = block.getType();
        ItemMeta itemMeta = event.getItemInHand().getItemMeta();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (this.plugin.cfg.getClaimData().contains(utils.getClaimID(event.getBlockPlaced().getLocation()))) {
            String[] members = utils.getMembers(block.getLocation());
            if (!utils.isClaimBlock(block) && !this.isEasilyBreakableCrop(block.getType())) {
                boolean isMember = utils.isMemberOfClaim(members, (OfflinePlayer)player);
                this.plugin.pluginManager.callEvent((Event)new BlockPlaceInClaimEvent(player, block, isMember));
                if (!isMember) {
                    event.setCancelled(true);
                    player.sendMessage(utils.chat("&cYou cannot place blocks in this claim"));
                    return;
                }
            }
        }
        if (block.getWorld().getEnvironment() == World.Environment.NETHER) {
            if (blockType == Material.SPAWNER) {
                spawner = (CreatureSpawner)block.getState();
                Optional<EntityType> spawnTypeOpt = this.getSpawnerType(itemMeta);
                spawnTypeOpt.ifPresent(spawnType -> {
                    this.transformSpawnerType(spawner, (EntityType)spawnType, this.netherSpawnTypeTransformations);
                    NamespacedKey placedKey = new NamespacedKey((Plugin)this.plugin, "playerPlaced");
                    spawner.getPersistentDataContainer().set(placedKey, PersistentDataType.BYTE, (Object)1);
                    spawner.update();
                });
            }
        } else {
            switch (blockType) {
                case CRIMSON_NYLIUM: 
                case WARPED_NYLIUM: {
                    event.setCancelled(true);
                    player.sendMessage(utils.chat("&cYou cannot place " + blockType.name() + " outside the Nether"));
                    return;
                }
                case SPAWNER: {
                    spawner = (CreatureSpawner)block.getState();
                    Optional<EntityType> spawnTypeOpt = this.getSpawnerType(itemMeta);
                    if (!spawnTypeOpt.isPresent()) break;
                    EntityType spawnType2 = spawnTypeOpt.get();
                    this.transformSpawnerType(spawner, spawnType2, this.nonNetherSpawnTypeTransformations);
                    NamespacedKey placedKey = new NamespacedKey((Plugin)this.plugin, "playerPlaced");
                    spawner.getPersistentDataContainer().set(placedKey, PersistentDataType.BYTE, (Object)1);
                    spawner.update();
                }
            }
        }
        switch (event.getBlockReplacedState().getType()) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: 
            case WATER: 
            case LAVA: 
            case SHORT_GRASS: 
            case TALL_GRASS: {
                utils.b4bGracePeriods.put(block, new GracePeriod(System.nanoTime(), block.getType()));
            }
        }
        boolean isInsideClaim = this.plugin.cfg.getClaimData().contains(utils.getClaimID(block.getLocation()));
        if (isInsideClaim && utils.isAdjacentToClaimBlock(block)) {
            String claimID = utils.getClaimID(block.getLocation());
            utils.updateBossBar(player, claimID);
        }
    }

    private void transformSpawnerType(CreatureSpawner spawner, EntityType spawnType, HashMap<EntityType, EntityType> transforms) {
        spawner.setSpawnedType(transforms.getOrDefault(spawnType, spawnType));
        spawner.update();
    }

    private Optional<EntityType> getSpawnerType(ItemMeta itemMeta) {
        PersistentDataContainer container;
        if (itemMeta != null && (container = itemMeta.getPersistentDataContainer()).has(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING)) {
            String spawnTypeName = (String)container.get(new NamespacedKey((Plugin)this.plugin, "spawnType"), PersistentDataType.STRING);
            return Optional.of(EntityType.valueOf((String)spawnTypeName));
        }
        return Optional.empty();
    }

    @EventHandler(ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        String[] members;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        String claimID = utils.getClaimID(block.getLocation());
        if (this.plugin.cfg.getClaimData().contains(claimID) && (members = utils.getMembers(block.getLocation())) != null) {
            boolean isMember = utils.isMemberOfClaim(members, (OfflinePlayer)player);
            this.plugin.pluginManager.callEvent((Event)new BlockPlaceInClaimEvent(player, block, isMember));
            if (!isMember) {
                event.setCancelled(true);
                player.sendMessage(utils.chat("&cYou cannot empty buckets in this claim"));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBucketEmptyMonitor(PlayerBucketEmptyEvent event) {
        Block block = event.getBlock();
        Material bucket = event.getBucket();
    }

    private boolean isEasilyBreakableCrop(Material material) {
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        String[] members;
        boolean isMember;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material signType = block.getType();
        if (this.plugin.cfg.getClaimData().contains(utils.getClaimID(location)) && !(isMember = utils.isMemberOfClaim(members = utils.getMembers(location), (OfflinePlayer)player))) {
            Material requiredSign = this.getSubstitutionFromConfig(signType);
            if (requiredSign == null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(utils.chat("&cNo valid substitution found for this sign!")));
                event.setCancelled(true);
                return;
            }
            int itemSlot = this.findItemSlot(player, requiredSign);
            if (itemSlot != -1) {
                this.removeItem(player, itemSlot);
            } else {
                String message = utils.chat("&cIntruding on Claim &aunclaim the area or spend &c" + String.valueOf(requiredSign) + " &afrom your hotbar to break this!");
                event.setCancelled(true);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            }
        }
    }

    private Material getSubstitutionFromConfig(Material signType) {
        String materialName = signType.name();
        String substituteName = this.plugin.getConfig().getString("b4b-substitutions." + materialName);
        if (substituteName != null) {
            try {
                return Material.valueOf((String)substituteName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material in b4b-substitutions for: " + materialName);
            }
        }
        return null;
    }

    private int findItemSlot(Player player, Material material) {
        for (int i = 0; i < 9; ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || item.getType() != material || item.getAmount() <= 0) continue;
            return i;
        }
        ItemStack offhandItem = player.getInventory().getItemInOffHand();
        if (offhandItem != null && offhandItem.getType() == material && offhandItem.getAmount() > 0) {
            return -2;
        }
        return -1;
    }

    private void removeItem(Player player, int itemSlot) {
        if (itemSlot == -2) {
            ItemStack offhandItem = player.getInventory().getItemInOffHand();
            offhandItem.setAmount(offhandItem.getAmount() - 1);
            player.getInventory().setItemInOffHand((ItemStack)(offhandItem.getAmount() > 0 ? offhandItem : null));
        } else if (itemSlot >= 0) {
            ItemStack itemToRemove = player.getInventory().getItem(itemSlot);
            itemToRemove.setAmount(itemToRemove.getAmount() - 1);
            player.getInventory().setItem(itemSlot, (ItemStack)(itemToRemove.getAmount() > 0 ? itemToRemove : null));
        }
    }
}

