/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.MasterBookCreatedEvent;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookEdit
implements Listener {
    private final Block4Block plugin;

    public BookEdit(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onOpenBook(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        Block clickedBlock = e.getClickedBlock();
        if (!(e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK || clickedBlock != null && clickedBlock.getType() == Material.LECTERN || item == null)) {
            BookMeta meta;
            if (item.getType() == Material.WRITABLE_BOOK) {
                if (!utils.hasClaims(p)) {
                    p.sendMessage(utils.chat("&cNOTE: &7To make a claim book, type &a\"claim\" &7at the top of the book!"));
                    p.sendMessage(utils.chat("&aThen write a player's ign on each line to add a member!"));
                    p.spigot().sendMessage(new ComponentBuilder(utils.chat("&aCLICK HERE to see an example")).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://hasjamon.github.io/b4block/lists.html")).create());
                }
            } else if (item.getType() == Material.WRITTEN_BOOK && (meta = (BookMeta)item.getItemMeta()) != null && meta.getLore() != null) {
                if (!meta.hasGeneration() || meta.getGeneration() == BookMeta.Generation.ORIGINAL) {
                    item.setType(Material.WRITABLE_BOOK);
                    item.addUnsafeEnchantment(Enchantment.BINDING_CURSE, 1);
                    BookMeta newMeta = (BookMeta)item.getItemMeta();
                    newMeta.setPages(meta.getPages());
                    newMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    item.setItemMeta((ItemMeta)newMeta);
                } else {
                    String bookID;
                    FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
                    if (masterBooks.contains((bookID = String.join((CharSequence)"", meta.getLore()).substring(17)) + ".pages")) {
                        if (this.plugin.getConfig().getBoolean("enable-master-books")) {
                            meta.setPages(masterBooks.getStringList(bookID + ".pages"));
                        }
                        item.setItemMeta((ItemMeta)meta);
                        p.openBook(item);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onSaveBook(PlayerEditBookEvent e) {
        Player p = e.getPlayer();
        FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
        BookMeta meta = e.getNewBookMeta();
        BookMeta prevMeta = e.getPreviousBookMeta();
        List lore = meta.getLore();
        if (!this.plugin.getConfig().getBoolean("enable-master-books")) {
            return;
        }
        if (lore == null) {
            if (e.isSigning()) {
                if (meta.getPages().size() > 0 && ((String)meta.getPages().get(0)).contains("claim")) {
                    long nextID = this.getNextMasterBookID(false);
                    ArrayList<String> newLore = new ArrayList<String>();
                    newLore.add(utils.chat("&6Master Book &7#" + nextID));
                    meta.setLore(newLore);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    e.setNewBookMeta(meta);
                    masterBooks.set(nextID + ".pages", (Object)meta.getPages());
                    this.plugin.cfg.saveMasterBooks();
                    this.plugin.pluginManager.callEvent((Event)new MasterBookCreatedEvent(p));
                } else {
                    e.setNewBookMeta(meta);
                }
            }
        } else {
            String bookID = String.join((CharSequence)"", lore).substring(17);
            boolean isClaimBook = utils.isClaimBook(meta);
            boolean wasClaimBook = utils.isClaimBook(prevMeta);
            masterBooks.set(bookID + ".pages", (Object)meta.getPages());
            this.plugin.cfg.saveMasterBooks();
            if (isClaimBook || wasClaimBook) {
                FileConfiguration claimData = this.plugin.cfg.getClaimData();
                HashSet<Block> toBeUnclaimed = new HashSet<Block>();
                HashSet<Block> toBeClaimed = new HashSet<Block>();
                HashSet<String> chunksToBeClaimed = new HashSet<String>();
                for (String copy : masterBooks.getStringList(bookID + ".copies-on-lecterns")) {
                    String[] parts = copy.split("!");
                    String claimID = parts[0];
                    CharSequence[] xyz = parts[1].split(",");
                    String environment = claimID.split("\\|")[0];
                    World.Environment env = World.Environment.valueOf((String)environment);
                    if (!wasClaimBook && (claimData.contains(claimID) || chunksToBeClaimed.contains(claimID))) {
                        if (!this.plugin.getConfig().getBoolean("hide-coords-globally") && utils.showCoordsInMsgs(p)) {
                            p.sendMessage(String.valueOf(ChatColor.GRAY) + "A copy of the master book at (" + String.join((CharSequence)", ", xyz) + ") in " + utils.getWorldName(env) + " was in a claimed chunk and has been corrupted!");
                            continue;
                        }
                        p.sendMessage(String.valueOf(ChatColor.GRAY) + "A copy of the master book at [hidden] in " + utils.getWorldName(env) + " was in a claimed chunk and has been corrupted!");
                        continue;
                    }
                    int x = Integer.parseInt(xyz[0]);
                    int y = Integer.parseInt(xyz[1]);
                    int z = Integer.parseInt(xyz[2]);
                    List worlds = Bukkit.getWorlds();
                    Optional<World> world = worlds.stream().filter(w -> w.getEnvironment().name().equals(environment)).findFirst();
                    if (world.isPresent()) {
                        Block lectern = world.get().getBlockAt(x, y, z);
                        if (!(!claimData.contains(claimID) && !chunksToBeClaimed.contains(claimID) || Math.round(claimData.getDouble(claimID + ".location.X")) == (long)x && Math.round(claimData.getDouble(claimID + ".location.Y")) == (long)y && Math.round(claimData.getDouble(claimID + ".location.Z")) == (long)z)) continue;
                        toBeUnclaimed.add(lectern);
                        if (!isClaimBook) continue;
                        chunksToBeClaimed.add(claimID);
                        toBeClaimed.add(lectern);
                        continue;
                    }
                    p.sendMessage("Something went wrong. Please contact a server admin.");
                }
                if (toBeUnclaimed.size() > 0) {
                    utils.unclaimChunkBulk(toBeUnclaimed, bookID, meta);
                }
                if (toBeClaimed.size() > 0) {
                    utils.claimChunkBulk(toBeClaimed, meta, bookID);
                }
            }
        }
    }

    private long getNextMasterBookID(boolean saveConfig) {
        FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
        long nextID = masterBooks.getLong("next-id", 0L);
        masterBooks.set("next-id", (Object)(nextID + 1L));
        if (saveConfig) {
            this.plugin.cfg.saveMasterBooks();
        }
        return nextID;
    }
}

