/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.command.ClaimContestCommand;
import hasjamon.block4block.events.ClaimBookPlacedEvent;
import hasjamon.block4block.events.ClaimRemovedEvent;
import hasjamon.block4block.events.ContestChunkClaimedEvent;
import hasjamon.block4block.utils.utils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.Lectern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookPlaceTake
implements Listener {
    private final Block4Block plugin;
    private final ClaimContestCommand claimContestCommand;

    public BookPlaceTake(Block4Block plugin, ClaimContestCommand claimContestCommand) {
        this.plugin = plugin;
        this.claimContestCommand = claimContestCommand;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlace(PlayerInteractEvent e) {
        Block b = e.getClickedBlock();
        Player p = e.getPlayer();
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && b != null && b.getType() == Material.LECTERN && e.hasItem()) {
            BookMeta meta;
            ItemStack item = e.getItem();
            Material type = item.getType();
            boolean isBook = type == Material.WRITTEN_BOOK || type == Material.WRITABLE_BOOK;
            boolean canPlace = true;
            Location bLoc = b.getLocation();
            String claimID = utils.getClaimID(bLoc);
            FileConfiguration claimData = this.plugin.cfg.getClaimData();
            boolean isClaimed = claimData.contains(claimID);
            if (isBook && (meta = (BookMeta)item.getItemMeta()) != null) {
                if (meta.getLore() != null) {
                    FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
                    String bookID = String.join((CharSequence)"", meta.getLore()).substring(17);
                    if (this.plugin.getConfig().getBoolean("enable-master-books") && masterBooks.contains(bookID + ".pages")) {
                        meta.setPages(masterBooks.getStringList(bookID + ".pages"));
                    }
                }
                if (meta.getPageCount() > 0 && utils.isClaimPage(meta.getPage(1))) {
                    if (isClaimed) {
                        canPlace = false;
                        p.sendMessage(utils.chat("&cThis chunk is already claimed! Find the claim book or remove \"claim\" from your book to place it."));
                    } else {
                        canPlace = utils.claimChunk(b, utils.findMembersInBook(meta), arg_0 -> ((Player)p).sendMessage(arg_0));
                        if (canPlace) {
                            ClaimContestCommand.Phase currentContestPhase = this.claimContestCommand.getCurrentPhase();
                            boolean isContestModeHold = this.claimContestCommand.isModeHold();
                            String contestClaimId = this.claimContestCommand.getCurrentContestClaimId();
                            this.plugin.getLogger().info("BookPlaceTake: Checking contest conditions for claim " + claimID + ". Contest State (Live): Phase=" + String.valueOf((Object)currentContestPhase) + ", ModeHold=" + isContestModeHold + ", ContestClaimID=" + contestClaimId);
                            if (currentContestPhase == ClaimContestCommand.Phase.ACTIVE && isContestModeHold && contestClaimId != null && claimID.equals(contestClaimId)) {
                                this.plugin.pluginManager.callEvent((Event)new ContestChunkClaimedEvent(p.getName()));
                                this.plugin.getLogger().info("BookPlaceTake: ContestChunkClaimedEvent fired for player " + p.getName() + " claiming contest chunk " + claimID);
                            } else {
                                this.plugin.getLogger().info("BookPlaceTake: Claimed chunk " + claimID + " does not meet contest transition conditions. Live State: Phase=" + String.valueOf((Object)currentContestPhase) + ", ModeHold=" + isContestModeHold + ", ContestClaimID=" + contestClaimId);
                            }
                        }
                    }
                }
            }
            if (canPlace) {
                if (isBook && (meta = (BookMeta)item.getItemMeta()) != null) {
                    List lore = meta.getLore();
                    boolean isMasterBook = false;
                    boolean isMember = utils.findMembersInBook(meta).stream().anyMatch(member -> member.equalsIgnoreCase(p.getName()));
                    if (isMember) {
                        p.playSound((Entity)p, Sound.UI_TOAST_CHALLENGE_COMPLETE, SoundCategory.RECORDS, 1.0f, 1.0f);
                    }
                    this.plugin.pluginManager.callEvent((Event)new ClaimBookPlacedEvent(p, b, isMasterBook, isMember));
                    if (lore != null) {
                        isMasterBook = true;
                        FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
                        String bookID = String.join((CharSequence)"", lore).substring(17);
                        String xyz = bLoc.getBlockX() + "," + bLoc.getBlockY() + "," + bLoc.getBlockZ();
                        List<CallSite> copies = new ArrayList<CallSite>();
                        if (masterBooks.contains(bookID + ".copies-on-lecterns")) {
                            copies = masterBooks.getStringList(bookID + ".copies-on-lecterns");
                        }
                        copies.add((CallSite)((Object)(claimID + "!" + xyz)));
                        masterBooks.set(bookID + ".copies-on-lecterns", copies);
                        this.plugin.cfg.saveMasterBooks();
                    }
                }
                utils.updateBossBar(p, claimID);
            } else {
                e.setCancelled(true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBookTake(PlayerTakeLecternBookEvent e) {
        block12: {
            lecternBlock = e.getLectern().getBlock();
            lectern = (Lectern)lecternBlock.getState();
            claimID = utils.getClaimID(lectern.getLocation());
            book = e.getBook();
            meta = (BookMeta)book.getItemMeta();
            p = e.getPlayer();
            if (book.getType() == Material.WRITTEN_BOOK) {
                if (meta != null && meta.getLore() != null && (masterBooks = this.plugin.cfg.getMasterBooks()).contains((bookID = String.join((CharSequence)"", meta.getLore()).substring(17)) + ".pages")) {
                    masterBookPages = masterBooks.getStringList(bookID + ".pages");
                    if (!masterBookPages.isEmpty() && utils.isClaimPage((String)masterBookPages.getFirst())) {
                        claimData = this.plugin.cfg.getClaimData();
                        bLoc = lectern.getLocation();
                        v0 = isCorrupted = claimData.contains(claimID + ".location") == false || claimData.get(claimID + ".location.X").equals(bLoc.getX()) == false || claimData.get(claimID + ".location.Y").equals(bLoc.getY()) == false || claimData.get(claimID + ".location.Z").equals(bLoc.getZ()) == false;
                        if (isCorrupted) {
                            lectern.getInventory().clear();
                            copies = masterBooks.getStringList(bookID + ".copies-on-lecterns");
                            xyz = bLoc.getBlockX() + "," + bLoc.getBlockY() + "," + bLoc.getBlockZ();
                            copies.remove(claimID + "!" + xyz);
                            masterBooks.set(bookID + ".copies-on-lecterns", (Object)copies);
                            this.plugin.cfg.saveMasterBooks();
                            p.sendMessage(String.valueOf(ChatColor.GRAY) + "The book was corrupted and turns to dust in your hands.");
                            e.setCancelled(true);
                            return;
                        }
                    }
                    if (this.plugin.getConfig().getBoolean("enable-master-books")) {
                        meta.setPages(masterBooks.getStringList(bookID + ".pages"));
                    }
                    book.setItemMeta((ItemMeta)meta);
                }
            } else if (book.getType() == Material.WRITABLE_BOOK && meta != null && this.plugin.getConfig().getBoolean("enable-claim-takeovers")) {
                claimTakeovers = this.plugin.cfg.getClaimTakeovers();
                replacements = claimTakeovers.getStringList(claimID);
                pages = new ArrayList<String>(meta.getPages());
                for (String replacement : replacements) {
                    parts = replacement.split("\\|");
                    utils.replaceInClaimPages(pages, parts[0], parts[1]);
                }
                meta.setPages(pages);
                book.setItemMeta((ItemMeta)meta);
                claimTakeovers.set(claimID, null);
                this.plugin.cfg.saveClaimTakeovers();
            }
            if (!this.plugin.cfg.getClaimData().contains(claimID) || !utils.isClaimBlock(lecternBlock)) break block12;
            player = e.getPlayer();
            isMember = utils.isMemberOfClaim(utils.getMembers(claimID), (OfflinePlayer)player);
            protectedBlockFaces = this.plugin.cfg.getClaimData().getStringList("claim-protection.protective-block-faces");
            numProtectedSides = utils.countProtectedSides(lecternBlock);
            isInvulnerable = utils.isClaimInvulnerable(lecternBlock);
            if (isMember) ** GOTO lbl55
            if (numProtectedSides == 0L && !isInvulnerable) {
lbl55:
                // 2 sources

                utils.unclaimChunk(lecternBlock, true, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, sendMessage(java.lang.String ), (Ljava/lang/String;)V)((Player)player));
                this.plugin.pluginManager.callEvent((Event)new ClaimRemovedEvent(player, lecternBlock, isMember));
                contestClaimId = this.claimContestCommand.getCurrentContestClaimId();
                if (contestClaimId != null && claimID.equals(contestClaimId)) {
                    this.plugin.getLogger().info("BookPlaceTake: Contest chunk " + claimID + " was unclaimed.");
                }
            } else {
                if (!isInvulnerable) {
                    msg = utils.chat("&aLectern is still protected from &c" + numProtectedSides + " &asides");
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(msg));
                }
                e.setCancelled(true);
            }
        }
        utils.updateBossBar(p, claimID);
    }
}

