/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BookReadLectern
implements Listener {
    private final Block4Block plugin;
    private final ProtocolManager protocolManager;
    private final Map<String, Boolean> processingLecterns = new HashMap<String, Boolean>();

    public BookReadLectern(Block4Block plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
    }

    @EventHandler
    public void onLecternRead(PlayerInteractEvent e) {
        List replacements;
        FileConfiguration claimTakeovers;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getClickedBlock() == null || e.getClickedBlock().getType() != Material.LECTERN) {
            return;
        }
        Player player = e.getPlayer();
        Block lecternBlock = e.getClickedBlock();
        String lecternKey = lecternBlock.getWorld().getName() + "," + lecternBlock.getX() + "," + lecternBlock.getY() + "," + lecternBlock.getZ();
        if (this.processingLecterns.getOrDefault(lecternKey, false).booleanValue()) {
            return;
        }
        BlockState state = lecternBlock.getState();
        if (!(state instanceof Lectern)) {
            return;
        }
        Lectern lectern = (Lectern)state;
        ItemStack book = lectern.getInventory().getItem(0);
        if (book == null || book.getType() != Material.WRITTEN_BOOK) {
            return;
        }
        BookMeta meta = (BookMeta)book.getItemMeta();
        if (meta == null) {
            return;
        }
        boolean bookNeedsUpdate = false;
        if (meta.getLore() != null) {
            try {
                FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
                String bookID = String.join((CharSequence)"", meta.getLore()).substring(17);
                if (this.plugin.getConfig().getBoolean("enable-master-books") && masterBooks.contains(bookID + ".pages")) {
                    List masterBookPages = masterBooks.getStringList(bookID + ".pages");
                    if (!meta.getPages().equals(masterBookPages)) {
                        meta.setPages(masterBookPages);
                        bookNeedsUpdate = true;
                    }
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Error processing book lore: " + ex.getMessage());
            }
        }
        String claimID = utils.getClaimID(lectern.getLocation());
        if (this.plugin.getConfig().getBoolean("enable-claim-takeovers") && (claimTakeovers = this.plugin.cfg.getClaimTakeovers()).contains(claimID) && !(replacements = claimTakeovers.getStringList(claimID)).isEmpty()) {
            List pages = meta.getPages();
            boolean contentChanged = false;
            for (String replacement : replacements) {
                String[] parts = replacement.split("\\|");
                if (parts.length != 2 || !utils.replaceInClaimPages(pages, parts[0], parts[1])) continue;
                contentChanged = true;
            }
            if (contentChanged) {
                meta.setPages(pages);
                bookNeedsUpdate = true;
                claimTakeovers.set(claimID, null);
                this.plugin.cfg.saveClaimTakeovers();
            }
        }
        if (bookNeedsUpdate) {
            e.setCancelled(true);
            this.processingLecterns.put(lecternKey, true);
            FileConfiguration claimData = this.plugin.cfg.getClaimData();
            boolean isClaimed = claimData.contains(claimID);
            boolean isClaimBlock = utils.isClaimBlock(lecternBlock);
            List<String> members = null;
            if (isClaimed && isClaimBlock) {
                members = Arrays.asList(utils.getMembers(claimID));
            }
            book.setItemMeta((ItemMeta)meta);
            lectern.getInventory().clear();
            lectern.update();
            if (isClaimed && isClaimBlock && members != null) {
                String membersString = String.join((CharSequence)"\n", members);
                claimData.set(claimID + ".members", (Object)membersString);
                this.plugin.cfg.saveClaimData();
            }
            lectern.getInventory().setItem(0, book);
            lectern.update();
            BlockPosition blockPos = new BlockPosition(lectern.getX(), lectern.getY(), lectern.getZ());
            NbtCompound bookTag = (NbtCompound)NbtFactory.fromItemTag((ItemStack)book);
            NbtCompound lecternNBT = NbtFactory.ofCompound((String)"");
            lecternNBT.put("id", "minecraft:lectern");
            lecternNBT.put("x", lectern.getX());
            lecternNBT.put("y", lectern.getY());
            lecternNBT.put("z", lectern.getZ());
            lecternNBT.put("Book", (NbtBase)bookTag);
            lecternNBT.put("HasBook", (byte)1);
            lecternNBT.put("page", 0);
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.TILE_ENTITY_DATA);
            packet.getBlockPositionModifier().write(0, (Object)blockPos);
            packet.getIntegers().write(0, (Object)1);
            packet.getNbtModifier().write(0, (Object)lecternNBT);
            try {
                this.protocolManager.sendServerPacket(player, packet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.openInventory(lectern.getInventory());
                this.processingLecterns.remove(lecternKey);
            }, 1L);
        }
    }
}

