/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ClaimVisual
implements Listener {
    private final Set<UUID> visualEnabledPlayers = new HashSet<UUID>();
    private final Block4Block block4BlockPlugin;

    public ClaimVisual(Block4Block block4BlockPlugin) {
        this.block4BlockPlugin = block4BlockPlugin;
        this.startVisualUpdater();
    }

    private void startVisualUpdater() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.block4BlockPlugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.shouldShowVisual(player)) {
                    this.showChunkBorders(player);
                    continue;
                }
                if (!this.visualEnabledPlayers.contains(player.getUniqueId())) continue;
                this.visualEnabledPlayers.remove(player.getUniqueId());
                String message = utils.chat("&cClaim visual disabled due to book removal or command.");
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            }
        }, 0L, 10L);
    }

    private boolean shouldShowVisual(Player player) {
        Material type;
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (offHandItem != null && ((type = offHandItem.getType()) == Material.WRITTEN_BOOK || type == Material.WRITABLE_BOOK)) {
            return true;
        }
        return this.visualEnabledPlayers.contains(player.getUniqueId());
    }

    private void showChunkBorders(Player player) {
        Chunk playerChunk = player.getLocation().getChunk();
        int chunkX = playerChunk.getX();
        int chunkZ = playerChunk.getZ();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Chunk chunk = player.getWorld().getChunkAt(chunkX + dx, chunkZ + dz);
                String claimID = utils.getClaimID(chunk.getBlock(0, 0, 0).getLocation());
                String[] members = utils.getMembers(claimID);
                Particle.DustOptions dustOptions = members == null ? new Particle.DustOptions(Color.GRAY, 1.5f) : (utils.isMemberOfClaim(members, (OfflinePlayer)player) ? new Particle.DustOptions(Color.GREEN, 1.5f) : new Particle.DustOptions(Color.RED, 1.5f));
                this.showChunkOutline(chunk, player, dustOptions);
            }
        }
    }

    private void showChunkOutline(Chunk chunk, Player player, Particle.DustOptions dustOptions) {
        int minX = chunk.getX() << 4;
        int minZ = chunk.getZ() << 4;
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        int y = player.getLocation().getBlockY();
        for (int x = minX; x <= maxX; ++x) {
            this.drawParticle(player, x, y, minZ, dustOptions);
            this.drawParticle(player, x, y, maxZ, dustOptions);
        }
        for (int z = minZ; z <= maxZ; ++z) {
            this.drawParticle(player, minX, y, z, dustOptions);
            this.drawParticle(player, maxX, y, z, dustOptions);
        }
    }

    private void drawParticle(Player player, int x, int y, int z, Particle.DustOptions dustOptions) {
        Location particleLocation = new Location(player.getWorld(), (double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
        player.spawnParticle(Particle.DUST, particleLocation, 1, (Object)dustOptions);
    }

    public void disableVisualUpdater() {
        this.visualEnabledPlayers.clear();
    }

    public Set<UUID> getVisualEnabledPlayers() {
        return this.visualEnabledPlayers;
    }
}

