/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ComplimentaryBed
implements Listener {
    private final Block4Block plugin;

    public ComplimentaryBed(Block4Block plugin) {
        this.plugin = plugin;
    }

    private void giveComplimentaryBed(Player player) {
        String pID = player.getUniqueId().toString();
        FileConfiguration bedUsage = this.plugin.cfg.getComplimentaryBedUsage();
        Object existing = bedUsage.get(pID);
        if (existing instanceof Number) {
            long legacyNextAvailable = ((Number)existing).longValue();
            bedUsage.set(pID, null);
            bedUsage.set(pID + ".nextAvailable", (Object)legacyNextAvailable);
            bedUsage.set(pID + ".bedCount", (Object)0);
            bedUsage.set(pID + ".name", (Object)player.getName());
            this.plugin.getLogger().info("Migrated old complimentary bed data for " + player.getName());
        }
        long now = System.currentTimeMillis();
        long nextAvailable = bedUsage.getLong(pID + ".nextAvailable", 0L);
        Object intervalConfig = this.plugin.getConfig().get("complimentary-bed.interval");
        long cooldownDuration = this.getCooldownDuration(intervalConfig);
        int currentBedCount = bedUsage.getInt(pID + ".bedCount", 0);
        int newBedCount = currentBedCount + 1;
        this.plugin.getLogger().info("Current bed count: " + currentBedCount + " | Giving bed #" + newBedCount + " | Next available: " + nextAvailable + " | Current time: " + now);
        if (now < nextAvailable) {
            double diff = (double)(nextAvailable - now) / 3600000.0;
            DecimalFormat decimals = new DecimalFormat("#.#");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Next Complimentary Bed available in " + decimals.format(diff) + " hours.");
            return;
        }
        ItemStack bed = new ItemStack(Material.WHITE_BED, 1);
        ItemMeta meta = bed.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Complimentary Bed");
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Received " + newBedCount + " times")));
        meta.setLore(lore);
        bed.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{bed});
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Complimentary Bed #" + newBedCount + " collected.");
        bedUsage.set(pID + ".name", (Object)player.getName());
        bedUsage.set(pID + ".nextAvailable", (Object)(now + cooldownDuration));
        bedUsage.set(pID + ".bedCount", (Object)newBedCount);
        this.plugin.cfg.saveComplimentaryBedUsage();
    }

    private long getCooldownDuration(Object intervalConfig) {
        if (intervalConfig instanceof Number) {
            long minutes = ((Number)intervalConfig).longValue();
            return minutes * 60L * 1000L;
        }
        if (intervalConfig instanceof String) {
            String interval;
            switch (interval = ((String)intervalConfig).toLowerCase()) {
                case "hourly": {
                    return 3600000L;
                }
                case "daily": {
                    return 86400000L;
                }
                case "weekly": {
                    return 604800000L;
                }
                case "monthly": {
                    return 2592000000L;
                }
            }
            this.plugin.getLogger().warning("Invalid interval '" + interval + "'. Defaulting to 1 day.");
            return 86400000L;
        }
        this.plugin.getLogger().warning("Invalid interval format in config. Defaulting to 1 day.");
        return 86400000L;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        this.plugin.getLogger().info("Respawn event triggered for: " + player.getName());
        if (player.getBedSpawnLocation() == null) {
            String pID = player.getUniqueId().toString();
            FileConfiguration bedUsage = this.plugin.cfg.getComplimentaryBedUsage();
            long now = System.currentTimeMillis();
            long nextAvailable = bedUsage.getLong(pID + ".nextAvailable", 0L);
            int currentBedCount = bedUsage.getInt(pID + ".bedCount", 0);
            this.plugin.getLogger().info("Checking conditions for Complimentary Bed: currentBedCount=" + currentBedCount + ", nextAvailable=" + nextAvailable + ", now=" + now);
            if (now < nextAvailable) {
                double diff = (double)(nextAvailable - now) / 3600000.0;
                DecimalFormat decimals = new DecimalFormat("#.#");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "You did not receive a Complimentary Bed. Next (Bed #" + (currentBedCount + 1) + ") available in " + decimals.format(diff) + " hours.");
            } else {
                this.giveComplimentaryBed(player);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String pID = player.getUniqueId().toString();
        FileConfiguration bedUsage = this.plugin.cfg.getComplimentaryBedUsage();
        long nextAvailable = bedUsage.getLong(pID + ".nextAvailable", 0L);
        if (!player.hasPlayedBefore()) {
            this.plugin.getLogger().info("Player joining for the first time: " + player.getName());
            if (player.getBedSpawnLocation() == null) {
                this.giveComplimentaryBed(player);
            }
        }
    }
}

