/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;

public class Explode
implements Listener {
    private final Block4Block plugin;

    public Explode(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        World.Environment environment = event.getEntity().getWorld().getEnvironment();
        String dimension = switch (environment) {
            default -> throw new MatchException(null, null);
            case World.Environment.NORMAL -> "overworld";
            case World.Environment.NETHER -> "nether";
            case World.Environment.THE_END -> "end";
            case World.Environment.CUSTOM -> "custom";
        };
        List claimImmunity = this.plugin.getConfig().getStringList("claim-explosion-immunity." + dimension);
        EntityType entityType = event.getEntityType();
        if (claimImmunity.contains(entityType.toString())) {
            FileConfiguration claimData = this.plugin.cfg.getClaimData();
            event.blockList().removeIf(block -> claimData.contains(utils.getClaimID(block.getLocation())));
        }
        event.blockList().removeIf(block -> !utils.getClaimBlocksProtectedBy(block).isEmpty());
        if (entityType == EntityType.TNT || entityType == EntityType.TNT_MINECART) {
            List tntDropsEnabled = this.plugin.getConfig().getStringList("tnt-drops-enabled");
            for (Block block2 : event.blockList()) {
                if (tntDropsEnabled.contains(block2.getType().toString())) continue;
                block2.setType(Material.AIR);
            }
        } else if (entityType == EntityType.CREEPER) {
            Location location = event.getLocation();
            Optional<World> worldOpt = Optional.ofNullable(location.getWorld());
            worldOpt.ifPresent(world -> world.dropItemNaturally(location, new ItemStack(Material.GUNPOWDER)));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        FileConfiguration claimData = this.plugin.cfg.getClaimData();
        List<Material> explodableBlockTypes = this.plugin.getConfig().getStringList("explodable-by-intended-game-mechanics").stream().map(Material::valueOf).toList();
        boolean isNether = event.getBlock().getWorld().getEnvironment() == World.Environment.NETHER;
        event.blockList().removeIf(block -> {
            boolean isProtectedByLectern;
            boolean isExplodable = explodableBlockTypes.contains(block.getType());
            boolean isInClaim = claimData.contains(utils.getClaimID(block.getLocation()));
            boolean bl = isProtectedByLectern = !utils.getClaimBlocksProtectedBy(block).isEmpty();
            if (isExplodable && isNether) {
                return isProtectedByLectern;
            }
            return !isExplodable || isInClaim || isProtectedByLectern;
        });
    }
}

