/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.ClaimRemovedEvent;
import hasjamon.block4block.utils.utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class LecternBreak
implements Listener {
    private final Block4Block plugin;

    public LecternBreak(Block4Block plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        boolean isInvulnerable;
        long numProtectedSides;
        Player player;
        block5: {
            boolean isMember;
            Block block;
            block4: {
                block = event.getBlock();
                if (block.getType() != Material.LECTERN) return;
                String claimID = utils.getClaimID(block.getLocation());
                if (!this.plugin.cfg.getClaimData().contains(claimID)) return;
                if (!utils.isClaimBlock(block)) return;
                player = event.getPlayer();
                isMember = utils.isMemberOfClaim(utils.getMembers(claimID), (OfflinePlayer)player);
                numProtectedSides = utils.countProtectedSides(block);
                isInvulnerable = utils.isClaimInvulnerable(block);
                if (isMember) break block4;
                if (numProtectedSides != 0L || isInvulnerable) break block5;
            }
            utils.unclaimChunk(block, true, arg_0 -> ((Player)player).sendMessage(arg_0));
            this.plugin.pluginManager.callEvent((Event)new ClaimRemovedEvent(player, block, isMember));
            return;
        }
        if (!isInvulnerable) {
            String msg = utils.chat("&aLectern is still protected from &c" + numProtectedSides + " &asides");
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(msg));
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        e.blockList().removeIf(utils::isProtectedClaimLectern);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent e) {
        Block block = e.getBlock();
        if (utils.isProtectedClaimLectern(block)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreakMonitor(BlockBreakEvent e) {
        Block b = e.getBlock();
        if (b.getType() == Material.LECTERN) {
            String claimID = utils.getClaimID(b.getLocation());
            if (this.plugin.cfg.getClaimData().contains(claimID) && utils.isClaimBlock(b)) {
                Player p = e.getPlayer();
                boolean isMember = utils.isMemberOfClaim(utils.getMembers(claimID), (OfflinePlayer)p);
                utils.unclaimChunk(b, true, arg_0 -> ((Player)p).sendMessage(arg_0));
                this.plugin.pluginManager.callEvent((Event)new ClaimRemovedEvent(p, b, isMember));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplodeMonitor(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (!utils.isUnprotectedClaimLectern(block)) continue;
            utils.unclaimChunk(block, false, msg -> {});
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplodeMonitor(BlockExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (!utils.isUnprotectedClaimLectern(block)) continue;
            utils.unclaimChunk(block, false, msg -> {});
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurnMonitor(BlockBurnEvent e) {
        Block block = e.getBlock();
        if (utils.isUnprotectedClaimLectern(block)) {
            utils.unclaimChunk(block, false, msg -> {});
        }
    }
}

