/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class PlayerDeath
implements Listener {
    private final Block4Block plugin;

    public PlayerDeath(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        String claimID = utils.getClaimID(p.getLocation());
        utils.onIntruderLeaveClaim(p, claimID);
        if (utils.canUseReflection) {
            utils.restorePlayerSkin(p);
            utils.onLoseDisguise(p);
        }
        Player killer = p.getKiller();
        if (this.plugin.getConfig().getBoolean("enable-claim-takeovers") && killer != null && p != killer) {
            FileConfiguration claimData = this.plugin.cfg.getClaimData();
            FileConfiguration masterBooks = this.plugin.cfg.getMasterBooks();
            FileConfiguration claimTakeovers = this.plugin.cfg.getClaimTakeovers();
            String victimName = p.getName().toLowerCase();
            String killerName = killer.getName().toLowerCase();
            for (String claim : claimData.getKeys(false)) {
                String members = claimData.getString(claim + ".members");
                if (members == null) continue;
                Object[] membersBefore = members.split("\\n");
                Object[] membersAfter = members.split("\\n");
                String replacementName = utils.isMemberOfClaim((String[])membersBefore, (OfflinePlayer)killer) ? "" : killerName;
                for (int i = 0; i < membersAfter.length; ++i) {
                    if (!membersAfter[i].equalsIgnoreCase(victimName)) continue;
                    membersAfter[i] = replacementName;
                    String searchReplace = victimName + "|" + replacementName;
                    List replacements = claimTakeovers.getStringList(claim);
                    replacements.add(searchReplace);
                    claimTakeovers.set(claim, (Object)replacements);
                }
                claimData.set(claim + ".members", (Object)String.join((CharSequence)"\n", (CharSequence[])membersAfter));
                if (Arrays.equals(membersAfter, membersBefore)) continue;
                double x = claimData.getDouble(claim + ".location.X");
                double y = claimData.getDouble(claim + ".location.Y");
                double z = claimData.getDouble(claim + ".location.Z");
                String xyz = x + ", " + y + ", " + z;
                String[] membersRemoved = (String[])Arrays.stream(membersBefore).filter(arg_0 -> PlayerDeath.lambda$onPlayerDeath$0((String[])membersAfter, arg_0)).toArray(String[]::new);
                utils.onChunkUnclaim(claim, membersRemoved, xyz, null);
                utils.onChunkClaim(claim, Arrays.stream(membersAfter).toList(), null, null);
                this.plugin.cfg.saveOfflineClaimNotifications();
            }
            for (String key : masterBooks.getKeys(false)) {
                if (!masterBooks.contains(key + ".pages")) continue;
                List pages = masterBooks.getStringList(key + ".pages");
                String[] members = (String[])utils.findMembersInBook(pages).toArray(String[]::new);
                if (utils.isMemberOfClaim(members, (OfflinePlayer)killer)) {
                    utils.replaceInClaimPages(pages, victimName, "");
                } else {
                    utils.replaceInClaimPages(pages, victimName, killerName);
                }
                masterBooks.set(key + ".pages", (Object)pages);
            }
            this.plugin.cfg.saveClaimData();
            this.plugin.cfg.saveMasterBooks();
            this.plugin.cfg.saveClaimTakeovers();
            utils.updateClaimCount();
        }
    }

    private static /* synthetic */ boolean lambda$onPlayerDeath$0(String[] membersAfter, String mb) {
        return Arrays.stream(membersAfter).anyMatch(mb::equalsIgnoreCase);
    }
}

