/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import com.mojang.authlib.properties.Property;
import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.ClaimLostWhileOfflineEvent;
import hasjamon.block4block.utils.utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoin
implements Listener {
    private final Block4Block plugin;

    public PlayerJoin(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!p.hasPlayedBefore()) {
            utils.sendWelcomeMsg(p);
        }
        utils.knownPlayers.add(p.getName().toLowerCase());
        utils.populatePlayerClaimsIntruded(p);
        utils.updateClaimCount();
        String claimID = utils.getClaimID(p.getLocation());
        utils.updateBossBar(p, claimID);
        if (utils.isIntruder(p, claimID)) {
            utils.onIntruderEnterClaim(p, claimID);
        }
        String pName = p.getName().toLowerCase();
        FileConfiguration offlineClaimNotifications = this.plugin.cfg.getOfflineClaimNotifications();
        ConfigurationSection claimsLost = offlineClaimNotifications.getConfigurationSection(pName + ".chunks");
        ConfigurationSection masterBooksRemovedFrom = offlineClaimNotifications.getConfigurationSection(pName + ".masterbooks");
        if (claimsLost != null) {
            Set claimIDs = claimsLost.getKeys(false);
            int i = 0;
            Iterator iterator = claimIDs.iterator();
            while (iterator.hasNext()) {
                String cID = (String)iterator.next();
                if (++i >= 10 && claimIDs.size() > 10) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "... and " + (claimIDs.size() - 9) + " other claims");
                    break;
                }
                String xyz = claimsLost.getString(cID);
                String worldName = utils.getWorldName(World.Environment.valueOf((String)claimID.split("\\|")[0]));
                if (!this.plugin.getConfig().getBoolean("hide-coords-globally") && utils.showCoordsInMsgs(p)) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "You have lost a claim! Location: " + xyz + " in " + worldName);
                    continue;
                }
                p.sendMessage(String.valueOf(ChatColor.RED) + "You have lost a claim! Location: [hidden] in " + worldName);
            }
            this.plugin.pluginManager.callEvent((Event)new ClaimLostWhileOfflineEvent(p));
        }
        if (masterBooksRemovedFrom != null) {
            for (String mbID : masterBooksRemovedFrom.getKeys(false)) {
                if (!masterBooksRemovedFrom.getBoolean(mbID)) continue;
                p.sendMessage(String.valueOf(ChatColor.RED) + "Your name has been removed from Master Book #" + mbID + " and all related claims!");
                this.plugin.pluginManager.callEvent((Event)new ClaimLostWhileOfflineEvent(p));
            }
        }
        offlineClaimNotifications.set(pName, null);
        this.plugin.cfg.saveOfflineClaimNotifications();
        Collection<Property> textures = utils.getTextures((OfflinePlayer)p);
        if (textures != null && !textures.isEmpty()) {
            Property prop = textures.iterator().next();
            ArrayList<String> copy = new ArrayList<String>();
            copy.add(prop.name());
            copy.add(prop.value());
            if (prop.hasSignature()) {
                copy.add(prop.signature());
            }
            this.plugin.cfg.getPlayerTextures().set(p.getUniqueId().toString(), copy);
            this.plugin.cfg.savePlayerTextures();
        }
    }
}

