/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class PlayerLavaDamage
implements Listener {
    private final Map<Player, Long> lastImmunityMessageReceived = new HashMap<Player, Long>();
    private final int minSecBetweenMsgs;

    public PlayerLavaDamage(Block4Block plugin) {
        this.minSecBetweenMsgs = plugin.getConfig().getInt("seconds-between-lava-immunity-msgs", 60);
    }

    @EventHandler
    public void onPlayerLavaDamage(EntityDamageByBlockEvent e) {
        Player p;
        if (e.getCause() == EntityDamageEvent.DamageCause.LAVA && e.getEntityType() == EntityType.PLAYER && Arrays.stream((p = (Player)e.getEntity()).getInventory().getContents()).noneMatch(Objects::nonNull)) {
            long now = System.nanoTime();
            if ((double)(now - this.lastImmunityMessageReceived.getOrDefault(p, 0L)) >= (double)this.minSecBetweenMsgs * 1.0E9) {
                String msg = "The lava wants to burn your items, but you have none, so it will let you go unharmed.";
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + msg);
                this.lastImmunityMessageReceived.put(p, now);
            }
            e.setCancelled(true);
        }
    }
}

