/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import hasjamon.block4block.Block4Block;
import hasjamon.block4block.utils.utils;
import org.bukkit.GameMode;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMove
implements Listener {
    private final Block4Block plugin;

    public PlayerMove(Block4Block plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (e.getTo() != null) {
            String currentChunkID;
            String prevChunkID = utils.getChunkID(e.getFrom());
            if (!prevChunkID.equals(currentChunkID = utils.getChunkID(e.getTo()))) {
                boolean isIntruder;
                String prevClaimID = utils.getClaimID(e.getFrom());
                String currentClaimID = utils.getClaimID(e.getTo());
                boolean bl = isIntruder = utils.isIntruder(p, currentClaimID) && p.getGameMode() == GameMode.SURVIVAL;
                if (!prevClaimID.equals(currentClaimID)) {
                    utils.onIntruderLeaveClaim(p, prevClaimID);
                    if (isIntruder) {
                        utils.onIntruderEnterClaim(p, currentClaimID);
                    }
                }
                if (isIntruder && this.plugin.getConfig().getBoolean("golems-guard-claims")) {
                    for (IronGolem golem : utils.ironGolems.keySet()) {
                        if (!currentChunkID.equals(utils.getChunkID(golem.getLocation()))) continue;
                        golem.setTarget((LivingEntity)p);
                    }
                }
                utils.updateBossBar(p, currentClaimID);
            }
            utils.lastPlayerMoves.put(p, System.nanoTime());
        }
    }
}

