/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.listener;

import java.util.Random;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class SpawnEggThrow
implements Listener {
    private final NamespacedKey eggKey;
    private final Random random = new Random();

    public SpawnEggThrow(NamespacedKey eggKey) {
        this.eggKey = eggKey;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() == null || !event.getItem().getType().name().endsWith("_SPAWN_EGG")) {
            return;
        }
        ItemStack item = event.getItem();
        Material spawnEggType = item.getType();
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        event.setCancelled(true);
        Snowball snowball = (Snowball)player.launchProjectile(Snowball.class);
        snowball.getPersistentDataContainer().set(this.eggKey, PersistentDataType.STRING, (Object)spawnEggType.name());
        ItemStack eggVisual = new ItemStack(spawnEggType);
        snowball.setItem(eggVisual);
        float pitch = 0.2f + this.random.nextFloat() * 0.2f;
        player.playSound(player.getLocation(), Sound.ENTITY_EGG_THROW, 0.5f, pitch);
        ItemStack handItem = player.getInventory().getItem(event.getHand());
        if (handItem != null) {
            if (handItem.getAmount() > 1) {
                handItem.setAmount(handItem.getAmount() - 1);
            } else {
                player.getInventory().setItem(event.getHand(), null);
            }
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Snowball)) {
            return;
        }
        Snowball snowball = (Snowball)event.getEntity();
        if (!snowball.getPersistentDataContainer().has(this.eggKey, PersistentDataType.STRING)) {
            return;
        }
        String spawnEggName = (String)snowball.getPersistentDataContainer().get(this.eggKey, PersistentDataType.STRING);
        if (spawnEggName == null) {
            return;
        }
        EntityType entityType = this.getEntityTypeFromEgg(spawnEggName);
        if (entityType != null) {
            snowball.getWorld().spawnEntity(snowball.getLocation(), entityType);
        }
    }

    private EntityType getEntityTypeFromEgg(String eggName) {
        try {
            return EntityType.valueOf((String)eggName.replace("_SPAWN_EGG", ""));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

