/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block.utils;

import com.comphenix.protocol.utility.MinecraftReflection;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import hasjamon.block4block.Block4Block;
import hasjamon.block4block.events.B4BlockBreakEvent;
import hasjamon.block4block.events.IntruderEnteredClaimEvent;
import hasjamon.block4block.events.PlayerClaimsCountedEvent;
import hasjamon.block4block.events.WelcomeMsgSentEvent;
import hasjamon.block4block.utils.ChickenBonuses;
import hasjamon.block4block.utils.Coords2D;
import hasjamon.block4block.utils.GracePeriod;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;

public class utils {
    private static final Block4Block plugin = Block4Block.getInstance();
    public static final Map<Block, GracePeriod> b4bGracePeriods = new LinkedHashMap<Block, GracePeriod>();
    public static final Map<Location, GracePeriod> blockChangeGracePeriods = new LinkedHashMap<Location, GracePeriod>();
    public static final Map<String, Set<Player>> intruders = new HashMap<String, Set<Player>>();
    public static final Map<IronGolem, String> ironGolems = new HashMap<IronGolem, String>();
    public static final Map<Player, Set<String>> playerClaimsIntruded = new HashMap<Player, Set<String>>();
    public static final Map<Player, Long> lastIntrusionMsgReceived = new HashMap<Player, Long>();
    public static final Map<Player, BukkitTask> undisguiseTasks = new HashMap<Player, BukkitTask>();
    public static final Map<OfflinePlayer, String> activeDisguises = new HashMap<OfflinePlayer, String>();
    public static final Map<Player, Long> lastPlayerMoves = new HashMap<Player, Long>();
    public static final Map<Player, BossBar> bossBars = new HashMap<Player, BossBar>();
    public static final Map<Location, Long> claimInvulnerabilityStartTick = new HashMap<Location, Long>();
    public static final Set<String> knownPlayers = new HashSet<String>();
    public static final Set<Material> nonProtectiveBlockTypes = new HashSet<Material>();
    public static final Set<BlockFace> protectiveBlockFaces = new HashSet<BlockFace>();
    private static final Set<Material> airTypes = Set.of(Material.AIR, Material.VOID_AIR, Material.CAVE_AIR);
    public static int minSecBetweenAlerts;
    public static int claimWidth;
    public static int lavaFlowMaxY;
    private static boolean masterBookChangeMsgSent;
    public static boolean isPaperServer;
    public static boolean canUseReflection;
    public static long lastClaimUpdate;
    public static int gracePeriod;
    public static long currentTick;

    public static String chat(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String getChunkID(int blockX, int blockZ, World.Environment environment) {
        return environment.name() + "|" + (blockX >> 4) + "," + (blockZ >> 4);
    }

    public static String getChunkID(Location loc) {
        return utils.getChunkID(loc.getBlockX(), loc.getBlockZ(), loc.getWorld().getEnvironment());
    }

    public static String getClaimID(int blockX, int blockZ, World.Environment environment) {
        int chunkX;
        int claimX = (chunkX - ((chunkX = blockX >> 4) < 0 ? claimWidth - 1 : 0)) / claimWidth;
        int chunkZ = blockZ >> 4;
        int claimZ = (chunkZ - (chunkZ < 0 ? claimWidth - 1 : 0)) / claimWidth;
        return environment.name() + "|" + claimX + "," + claimZ;
    }

    public static String getClaimID(String chunkID) {
        String[] parts = chunkID.split("\\|");
        String envName = parts[0];
        String[] xz = parts[1].split(",");
        int chunkX = Integer.parseInt(xz[0]);
        int chunkZ = Integer.parseInt(xz[1]);
        int claimX = (chunkX - (chunkX < 0 ? claimWidth - 1 : 0)) / claimWidth;
        int claimZ = (chunkZ - (chunkZ < 0 ? claimWidth - 1 : 0)) / claimWidth;
        return envName + "|" + claimX + "," + claimZ;
    }

    public static String getClaimID(Location loc) {
        return utils.getClaimID(loc.getBlockX(), loc.getBlockZ(), loc.getWorld().getEnvironment());
    }

    public static String[] getMembers(Location loc) {
        return utils.getMembers(utils.getClaimID(loc));
    }

    public static String[] getMembers(String claimID) {
        String members = utils.plugin.cfg.getClaimData().getString(claimID + ".members");
        if (members != null) {
            return members.split("\\n");
        }
        return null;
    }

    public static boolean isProtectedClaimLectern(Block block) {
        return block.getType() == Material.LECTERN && utils.isClaimBlock(block) && (utils.countProtectedSides(block) > 0L || utils.isClaimInvulnerable(block));
    }

    public static boolean isUnprotectedClaimLectern(Block block) {
        return block.getType() == Material.LECTERN && utils.isClaimBlock(block) && utils.countProtectedSides(block) == 0L && !utils.isClaimInvulnerable(block);
    }

    public static long countProtectedSides(Block block) {
        return protectiveBlockFaces.stream().filter(direction -> {
            Block adjacent = block.getRelative(direction);
            boolean isProtectiveNonClaimBlock = !nonProtectiveBlockTypes.contains(adjacent.getType()) && !utils.isClaimBlock(adjacent);
            long numFallingBlocksAbove = adjacent.getWorld().getNearbyEntities(BoundingBox.of((Block)adjacent).resize(0.0, 0.0, 0.0, 0.0, 320.0, 0.0), entity -> entity.getType() == EntityType.FALLING_BLOCK).size();
            boolean hasGravityAffectedBlockAbove = adjacent.getRelative(BlockFace.UP).getType().hasGravity();
            return isProtectiveNonClaimBlock || numFallingBlocksAbove > 0L || hasGravityAffectedBlockAbove;
        }).count();
    }

    public static boolean isClaimInvulnerable(Block block) {
        return currentTick - claimInvulnerabilityStartTick.getOrDefault(block.getLocation(), 0L) <= 10L;
    }

    public static boolean isClaimBlock(Block b) {
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        String cID = utils.getClaimID(b.getLocation());
        double lecternX = claimData.getDouble(cID + ".location.X", Double.MAX_VALUE);
        double lecternY = claimData.getDouble(cID + ".location.Y", Double.MAX_VALUE);
        double lecternZ = claimData.getDouble(cID + ".location.Z", Double.MAX_VALUE);
        if (lecternX == Double.MAX_VALUE || lecternY == Double.MAX_VALUE || lecternZ == Double.MAX_VALUE) {
            return false;
        }
        return lecternX == b.getLocation().getX() && lecternY == b.getLocation().getY() && lecternZ == b.getLocation().getZ();
    }

    public static boolean isAdjacentToClaimBlock(Block b) {
        for (BlockFace face : utils.plugin.cfg.getProtectiveBlockFaces()) {
            Block adjacent = b.getRelative(face);
            if (!utils.isClaimBlock(adjacent)) continue;
            return true;
        }
        return false;
    }

    public static boolean claimChunk(Block block, List<String> members, Consumer<String> sendMessage) {
        if (!members.isEmpty()) {
            if (utils.isTooCloseToBedrock(block)) {
                sendMessage.accept(utils.chat("&cYou cannot place a claim next to bedrock"));
                return false;
            }
            utils.setChunkClaim(block, members, sendMessage, null);
            utils.updateClaimCount();
            utils.plugin.cfg.saveClaimData();
            utils.plugin.cfg.saveOfflineClaimNotifications();
        } else {
            sendMessage.accept(utils.chat("&cHINT: Add \"claim\" at the top of the first page, followed by a list members, to claim this area!"));
        }
        return true;
    }

    public static void claimChunkBulk(Set<Block> blocks, BookMeta meta, String masterBookID) {
        List<String> members;
        if (meta != null && !(members = utils.findMembersInBook(meta)).isEmpty()) {
            for (Block block : blocks) {
                if (utils.isTooCloseToBedrock(block)) continue;
                utils.setChunkClaim(block, members, masterBookID);
            }
            utils.updateClaimCount();
            utils.plugin.cfg.saveClaimData();
            utils.plugin.cfg.saveOfflineClaimNotifications();
        }
    }

    private static void setChunkClaim(Block block, List<String> members, String masterBookID) {
        utils.setChunkClaim(block, members, null, masterBookID);
    }

    private static void setChunkClaim(Block block, List<String> members, @Nullable Consumer<String> sendMessage, String masterBookID) {
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        Location blockLoc = block.getLocation();
        String claimID = utils.getClaimID(blockLoc);
        String membersString = String.join((CharSequence)"\n", members);
        claimData.set(claimID + ".location.X", (Object)blockLoc.getX());
        claimData.set(claimID + ".location.Y", (Object)blockLoc.getY());
        claimData.set(claimID + ".location.Z", (Object)blockLoc.getZ());
        claimData.set(claimID + ".members", (Object)membersString);
        utils.onChunkClaim(claimID, members, sendMessage, masterBookID);
    }

    public static void onChunkClaim(String claimID, List<String> members, @Nullable Consumer<String> sendMessage, String masterBookID) {
        if (sendMessage == null) {
            sendMessage = msg -> {};
        }
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        Map<Boolean, List<String>> doMembersExist = members.stream().collect(Collectors.partitioningBy(m -> knownPlayers.contains(m.toLowerCase())));
        sendMessage.accept(utils.chat("&eThis chunk has now been claimed!"));
        sendMessage.accept(utils.chat("&aMembers who can access this chunk:"));
        for (String knownMember : doMembersExist.get(true)) {
            sendMessage.accept(String.valueOf(ChatColor.GRAY) + " - " + knownMember);
            boolean isOffline = onlinePlayers.stream().noneMatch(op -> op.getName().equalsIgnoreCase(knownMember));
            if (!isOffline) continue;
            String name = knownMember.toLowerCase();
            FileConfiguration offlineClaimNotifications = utils.plugin.cfg.getOfflineClaimNotifications();
            if (masterBookID != null) {
                offlineClaimNotifications.set(name + ".masterbooks." + masterBookID, (Object)false);
                continue;
            }
            offlineClaimNotifications.set(name + ".chunks." + claimID, null);
        }
        for (String unknownMember : doMembersExist.get(false)) {
            sendMessage.accept(String.valueOf(ChatColor.GRAY) + " - " + unknownMember + String.valueOf(ChatColor.RED) + " (unknown player)");
        }
        for (Player player : onlinePlayers) {
            if (!claimID.equals(utils.getClaimID(player.getLocation()))) continue;
            utils.updateBossBar(player, claimID);
            if (!utils.isIntruder(player, claimID)) continue;
            utils.onIntruderEnterClaim(player, claimID);
        }
        lastClaimUpdate = System.nanoTime();
    }

    public static void onChunkUnclaim(String claimID, String[] members, Location lecternLoc, String masterBookID) {
        String xyz = lecternLoc.getBlockX() + ", " + lecternLoc.getBlockY() + ", " + lecternLoc.getBlockZ();
        utils.onChunkUnclaim(claimID, members, xyz, masterBookID);
    }

    public static void onChunkUnclaim(String claimID, String[] members, String lecternXYZ, String masterBookID) {
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        if (members != null) {
            for (String member : members) {
                if (!knownPlayers.contains(member.toLowerCase())) continue;
                boolean isOffline = true;
                for (Player player : onlinePlayers) {
                    if (!player.getName().equalsIgnoreCase(member)) continue;
                    isOffline = false;
                    if (masterBookID != null) {
                        if (masterBookChangeMsgSent) break;
                        String msg = "Your name has been removed from Master Book #" + masterBookID + " and all related claims!";
                        player.sendMessage(String.valueOf(ChatColor.RED) + msg);
                        masterBookChangeMsgSent = true;
                        break;
                    }
                    String worldName = utils.getWorldName(World.Environment.valueOf((String)claimID.split("\\|")[0]));
                    if (!plugin.getConfig().getBoolean("hide-coords-globally") && utils.showCoordsInMsgs(player)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You have lost a claim! Location: " + lecternXYZ + " in " + worldName);
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You have lost a claim! Location: [hidden] in " + worldName);
                    break;
                }
                if (!isOffline) continue;
                String name = member.toLowerCase();
                FileConfiguration offlineClaimNotifications = utils.plugin.cfg.getOfflineClaimNotifications();
                if (masterBookID != null) {
                    offlineClaimNotifications.set(name + ".masterbooks." + masterBookID, (Object)true);
                    continue;
                }
                offlineClaimNotifications.set(name + ".chunks." + claimID, (Object)lecternXYZ);
            }
        }
        for (Player player : onlinePlayers) {
            if (!claimID.equals(utils.getClaimID(player.getLocation()))) continue;
            utils.updateBossBar(player, claimID);
        }
        HashMap<Player, String> intrudersThatLeft = new HashMap<Player, String>();
        if (intruders.containsKey(claimID)) {
            for (Player intruder : intruders.get(claimID)) {
                intrudersThatLeft.put(intruder, claimID);
            }
        }
        for (Player intruder : intrudersThatLeft.keySet()) {
            utils.onIntruderLeaveClaim(intruder, (String)intrudersThatLeft.get(intruder));
        }
        lastClaimUpdate = System.nanoTime();
    }

    public static List<String> findMembersInBook(BookMeta meta) {
        List pages = meta.getPages();
        return utils.findMembersInBook(pages);
    }

    public static List<String> findMembersInBook(List<String> pages) {
        LinkedHashMap<String, String> members = new LinkedHashMap<String, String>();
        for (String page : pages) {
            if (!utils.isClaimPage(page)) break;
            String[] lines = page.split("\\n");
            for (int i = 1; i < lines.length; ++i) {
                String member = lines[i].trim();
                if (member.contains(" ") || member.isEmpty() || members.containsKey(member.toLowerCase())) continue;
                members.put(member.toLowerCase(), member);
            }
        }
        return ((HashMap)members).values().stream().toList();
    }

    private static boolean isTooCloseToBedrock(Block block) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (block.getRelative(x, y, z).getType() != Material.BEDROCK) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isClaimPage(String page) {
        return page.length() >= 5 && page.substring(0, 5).equalsIgnoreCase("claim");
    }

    public static boolean isClaimBook(BookMeta meta) {
        return meta.hasPages() && utils.isClaimPage(meta.getPage(1));
    }

    public static void unclaimChunk(Block block, boolean causedByPlayer, Consumer<String> sendMessage) {
        String bookID;
        FileConfiguration masterBooks;
        List lore;
        BookMeta meta;
        Lectern lectern;
        ItemStack book;
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        Location blockLoc = block.getLocation();
        String claimID = utils.getClaimID(blockLoc);
        String[] members = utils.getMembers(claimID);
        if (block.getType() == Material.LECTERN && (book = (lectern = (Lectern)block.getState()).getInventory().getItem(0)) != null && (meta = (BookMeta)book.getItemMeta()) != null && (lore = meta.getLore()) != null && (masterBooks = utils.plugin.cfg.getMasterBooks()).contains((bookID = String.join((CharSequence)"", lore).substring(17)) + ".copies-on-lecterns")) {
            List copies = masterBooks.getStringList(bookID + ".copies-on-lecterns");
            String xyz = blockLoc.getBlockX() + "," + blockLoc.getBlockY() + "," + blockLoc.getBlockZ();
            copies.remove(claimID + "!" + xyz);
            masterBooks.set(bookID + ".copies-on-lecterns", (Object)copies);
            utils.plugin.cfg.saveMasterBooks();
        }
        claimData.set(claimID, null);
        utils.plugin.cfg.saveClaimData();
        if (causedByPlayer) {
            sendMessage.accept(String.valueOf(ChatColor.RED) + "You have removed this claim!");
        }
        utils.onChunkUnclaim(claimID, members, blockLoc, null);
        utils.plugin.cfg.saveOfflineClaimNotifications();
        utils.plugin.cfg.getClaimTakeovers().set(claimID, null);
        utils.plugin.cfg.saveClaimTakeovers();
        utils.updateClaimCount();
    }

    public static void unclaimChunkBulk(Set<Block> blocks, String masterBookID, BookMeta meta) {
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        for (Block b : blocks) {
            Location bLoc = b.getLocation();
            String claimID = utils.getClaimID(bLoc);
            String[] membersBefore = utils.getMembers(claimID);
            List<String> membersAfter = utils.findMembersInBook(meta);
            String[] membersRemoved = null;
            if (membersBefore != null) {
                membersRemoved = (String[])Arrays.stream(membersBefore).filter(mb -> !membersAfter.contains(mb)).toArray(String[]::new);
            }
            claimData.set(claimID, null);
            utils.onChunkUnclaim(claimID, membersRemoved, bLoc, masterBookID);
        }
        utils.plugin.cfg.saveClaimData();
        utils.plugin.cfg.saveOfflineClaimNotifications();
        masterBookChangeMsgSent = false;
        utils.updateClaimCount();
    }

    public static void updateClaimCount() {
        HashMap<String, Integer> membersNumClaims = utils.countMemberClaims();
        for (Player p : Bukkit.getOnlinePlayers()) {
            Integer pClaims = membersNumClaims.get(p.getName().toLowerCase());
            if (pClaims == null) {
                p.setPlayerListName(p.getName() + utils.chat(" - &c0"));
                continue;
            }
            p.setPlayerListName(p.getName() + utils.chat(" - &c" + pClaims));
            utils.plugin.pluginManager.callEvent((Event)new PlayerClaimsCountedEvent(p, pClaims));
        }
    }

    public static HashMap<String, Integer> countMemberClaims() {
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (String key : claimData.getKeys(false)) {
            String currentMembers;
            ConfigurationSection chunk = claimData.getConfigurationSection(key);
            if (chunk == null || (currentMembers = chunk.getString("members")) == null) continue;
            for (String cm : currentMembers.toLowerCase().split("\\n")) {
                count.merge(cm, 1, Integer::sum);
            }
        }
        return count;
    }

    public static boolean hasClaims(Player p) {
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        String playerName = p.getName().toLowerCase();
        for (String key : claimData.getKeys(false)) {
            String currentMembers;
            ConfigurationSection chunk = claimData.getConfigurationSection(key);
            if (chunk == null || (currentMembers = chunk.getString("members")) == null) continue;
            for (String member : currentMembers.toLowerCase().split("\\n")) {
                if (!member.equals(playerName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void b4bCheck(Player p, Block b, BlockBreakEvent e, List<?> lootDisabledTypes, boolean requiresBlock, boolean isFreeToBreakInClaim) {
        boolean noloot = lootDisabledTypes.contains(b.getType().toString());
        if (requiresBlock) {
            Material requiredType = b.getType();
            ConfigurationSection substitutions = plugin.getConfig().getConfigurationSection("b4b-substitutions");
            if (substitutions != null && substitutions.contains(requiredType.name())) {
                requiredType = Material.valueOf((String)substitutions.getString(requiredType.name()));
            }
            if (p.getInventory().getItemInOffHand().getType() == requiredType) {
                p.getInventory().getItemInOffHand().setAmount(p.getInventory().getItemInOffHand().getAmount() - 1);
            } else {
                boolean itemInInventory = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = p.getInventory().getItem(i);
                    if (item == null || item.getType() != requiredType) continue;
                    item.setAmount(item.getAmount() - 1);
                    itemInInventory = true;
                    break;
                }
                if (!itemInInventory) {
                    String message = utils.chat(isFreeToBreakInClaim ? "&cClaim &athe area or spend &c" + String.valueOf(requiredType) + " &afrom your hotbar to break this!" : "&aSpend &c" + String.valueOf(requiredType) + " &afrom your hotbar to break this!");
                    e.setCancelled(true);
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                    utils.plugin.pluginManager.callEvent((Event)new B4BlockBreakEvent(p, b, false, isFreeToBreakInClaim));
                    return;
                }
            }
            utils.plugin.pluginManager.callEvent((Event)new B4BlockBreakEvent(p, b, true, isFreeToBreakInClaim));
            utils.getClaimBlocksProtectedBy(b).forEach(claimBlock -> claimInvulnerabilityStartTick.put(claimBlock.getLocation(), currentTick));
        }
        if (noloot) {
            utils.dropInventory(b);
            if (b.getType() == Material.PISTON_HEAD) {
                PistonHead pistonHead = (PistonHead)b.getBlockData();
                Block piston = b.getRelative(pistonHead.getFacing().getOppositeFace());
                piston.setType(Material.AIR);
            }
            b.setType(Material.AIR);
            e.setCancelled(true);
        }
    }

    public static List<Block> getClaimBlocksProtectedBy(Block protectingBlock) {
        LinkedList<Block> result = new LinkedList<Block>();
        for (BlockFace face : protectiveBlockFaces) {
            Block adjacent = protectingBlock.getRelative(face.getOppositeFace());
            if (!utils.isClaimBlock(adjacent)) continue;
            result.add(adjacent);
        }
        return result;
    }

    private static void dropInventory(Block b) {
        BlockState blockState = b.getState();
        if (blockState instanceof BlockInventoryHolder) {
            BlockInventoryHolder bInv = (BlockInventoryHolder)blockState;
            Inventory inv = bInv.getInventory();
            for (ItemStack item : inv.getStorageContents()) {
                if (item == null) continue;
                b.getWorld().dropItemNaturally(b.getLocation(), item);
            }
        }
    }

    public static double calcGeneralChickenBonus(double numNamedChickens) {
        return Math.log(numNamedChickens + 2.0) / Math.log(2.0);
    }

    public static ChickenBonuses calcChickenBonuses(Entity center) {
        double radius = (double)plugin.getConfig().getInt("named-chicken-radius") + 0.5;
        List nearbyEntities = center.getNearbyEntities(radius, radius, radius);
        HashSet<CallSite> namedChickensPos = new HashSet<CallSite>();
        HashMap<Character, Integer> letterBonuses = new HashMap<Character, Integer>();
        for (Entity ne : nearbyEntities) {
            Location loc;
            String pos;
            String chickenName;
            if (ne.getType() != EntityType.CHICKEN || (chickenName = ne.getCustomName()) == null || namedChickensPos.contains(pos = (loc = ne.getLocation()).getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ())) continue;
            namedChickensPos.add((CallSite)((Object)pos));
            letterBonuses.merge(Character.valueOf(chickenName.toLowerCase().charAt(0)), 1, Integer::sum);
        }
        return new ChickenBonuses(letterBonuses, namedChickensPos.size());
    }

    public static void onIntruderEnterClaim(Player intruder, String claimID) {
        if (intruder.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        double x = claimData.getDouble(claimID + ".location.X");
        double y = claimData.getDouble(claimID + ".location.Y");
        double z = claimData.getDouble(claimID + ".location.Z");
        if (!intruders.containsKey(claimID)) {
            intruders.put(claimID, new HashSet());
        }
        intruders.get(claimID).add(intruder);
        String[] members = utils.getMembers(claimID);
        if (members != null) {
            for (String m : members) {
                Player p = Bukkit.getPlayerExact((String)m);
                if (p == null) continue;
                long now = System.nanoTime();
                if (!playerClaimsIntruded.containsKey(p)) {
                    playerClaimsIntruded.put(p, new HashSet());
                }
                playerClaimsIntruded.get(p).add(claimID);
                if (!((double)(now - lastIntrusionMsgReceived.getOrDefault(p, 0L)) >= (double)minSecBetweenAlerts * 1.0E9)) continue;
                String worldName = utils.getWorldName(World.Environment.valueOf((String)claimID.split("\\|")[0]));
                if (!plugin.getConfig().getBoolean("hide-coords-globally") && utils.showCoordsInMsgs(p)) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "An intruder has entered your claim at " + x + ", " + y + ", " + z + " in " + worldName);
                } else {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "An intruder has entered your claim at [hidden] in " + worldName);
                }
                lastIntrusionMsgReceived.put(p, now);
                utils.plugin.pluginManager.callEvent((Event)new IntruderEnteredClaimEvent(p));
            }
        }
    }

    public static boolean showCoordsInMsgs(Player p) {
        String playerSetting = utils.plugin.cfg.getCoordsSettings().getString(p.getUniqueId().toString());
        return playerSetting == null || playerSetting.equals("on");
    }

    public static void onIntruderLeaveClaim(Player intruder, String claimID) {
        if (intruders.containsKey(claimID)) {
            intruders.get(claimID).remove(intruder);
            if (intruders.get(claimID).isEmpty()) {
                intruders.remove(claimID);
            }
        }
    }

    public static boolean isIntruder(Player p, String claimID) {
        String[] members = utils.getMembers(claimID);
        return members != null && !utils.isMemberOfClaim(members, (OfflinePlayer)p);
    }

    public static void updateGolemHostility() {
        for (Map.Entry<IronGolem, String> entry : ironGolems.entrySet()) {
            String prevChunkID;
            IronGolem golem = entry.getKey();
            String currentChunkID = utils.getChunkID(golem.getLocation());
            if (currentChunkID.equals(prevChunkID = entry.getValue())) continue;
            entry.setValue(currentChunkID);
            String claimID = utils.getClaimID(golem.getLocation());
            if (!intruders.containsKey(claimID)) continue;
            for (Player intruder : intruders.get(claimID)) {
                if (!currentChunkID.equals(utils.getChunkID(intruder.getLocation()))) continue;
                golem.setTarget((LivingEntity)intruder);
            }
        }
    }

    public static void populatePlayerClaimsIntruded(Player p) {
        for (String claimID : intruders.keySet()) {
            String[] members = utils.getMembers(claimID);
            if (members == null || !utils.isMemberOfClaim(members, (OfflinePlayer)p, false)) continue;
            if (!playerClaimsIntruded.containsKey(p)) {
                playerClaimsIntruded.put(p, new HashSet());
            }
            playerClaimsIntruded.get(p).add(claimID);
        }
    }

    public static boolean isMemberOfClaim(String[] members, OfflinePlayer p) {
        if (members != null && p != null) {
            return utils.isMemberOfClaim(members, p, true);
        }
        return false;
    }

    public static boolean isMemberOfClaim(String[] members, OfflinePlayer p, boolean allowDisguise) {
        if (members != null && p != null) {
            for (String member : members) {
                boolean disguisedAsMember = member.equalsIgnoreCase(activeDisguises.getOrDefault(p, ""));
                if (!member.equalsIgnoreCase(p.getName()) && (!allowDisguise || !disguisedAsMember)) continue;
                return true;
            }
        }
        return false;
    }

    public static void disguisePlayer(Player disguiser, OfflinePlayer disguisee) {
        Collection<Property> textures = utils.getCachedTextures(disguisee);
        activeDisguises.put((OfflinePlayer)disguiser, disguisee.getName());
        utils.applyDisguise(disguiser, textures);
    }

    private static void applyDisguise(Player disguiser, Collection<Property> textures) {
        String claimID = utils.getClaimID(disguiser.getLocation());
        utils.setTextures(disguiser, textures);
        utils.updateTexturesForOthers(disguiser);
        utils.updateTexturesForSelf(disguiser);
        utils.updateBossBar(disguiser, claimID);
    }

    public static Collection<Property> getTextures(OfflinePlayer p) {
        if (canUseReflection) {
            try {
                Method getProfile = MinecraftReflection.getCraftPlayerClass().getDeclaredMethod("getProfile", new Class[0]);
                GameProfile gp = (GameProfile)getProfile.invoke((Object)p, new Object[0]);
                return gp.getProperties().get((Object)"textures");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Collection<Property> getCachedTextures(OfflinePlayer p) {
        List strs = utils.plugin.cfg.getPlayerTextures().getStringList(p.getUniqueId().toString());
        ArrayList<Property> textures = new ArrayList<Property>();
        if (strs.size() == 3) {
            textures.add(new Property((String)strs.get(0), (String)strs.get(1), (String)strs.get(2)));
        } else if (strs.size() == 2) {
            textures.add(new Property((String)strs.get(0), (String)strs.get(1)));
        }
        return textures;
    }

    public static void setTextures(Player p, Collection<Property> textures) {
        if (canUseReflection) {
            try {
                Method getProfile = MinecraftReflection.getCraftPlayerClass().getDeclaredMethod("getProfile", new Class[0]);
                GameProfile gp = (GameProfile)getProfile.invoke((Object)p, new Object[0]);
                gp.getProperties().removeAll((Object)"textures");
                gp.getProperties().putAll((Object)"textures", textures);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateTexturesForOthers(Player disguiser) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.hidePlayer((Plugin)plugin, disguiser);
            p.showPlayer((Plugin)plugin, disguiser);
        }
    }

    public static void updateTexturesForSelf(Player disguiser) {
        Entity vehicle = disguiser.getVehicle();
        if (vehicle != null) {
            vehicle.removePassenger((Entity)disguiser);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> vehicle.addPassenger((Entity)disguiser), 1L);
        }
        if (canUseReflection) {
            try {
                Method refreshPlayerMethod = MinecraftReflection.getCraftPlayerClass().getDeclaredMethod("refreshPlayer", new Class[0]);
                refreshPlayerMethod.setAccessible(true);
                refreshPlayerMethod.invoke((Object)disguiser, new Object[0]);
                disguiser.setExp(disguiser.getExp());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                isPaperServer = false;
            }
        }
    }

    public static void restorePlayerSkin(Player p) {
        utils.applyDisguise(p, utils.getCachedTextures((OfflinePlayer)p));
    }

    public static void onLoseDisguise(Player disguiser) {
        if (activeDisguises.containsKey(disguiser)) {
            String claimID = utils.getClaimID(disguiser.getLocation());
            activeDisguises.remove(disguiser);
            disguiser.sendMessage("Your disguise has expired!");
            utils.updateBossBar(disguiser, claimID);
            if (utils.isIntruder(disguiser, claimID)) {
                utils.onIntruderEnterClaim(disguiser, claimID);
            }
            if (undisguiseTasks.containsKey(disguiser)) {
                undisguiseTasks.get(disguiser).cancel();
                undisguiseTasks.remove(disguiser);
            }
        }
    }

    public static boolean replaceInClaimPages(List<String> pages, String search, String replace) {
        String page;
        for (int i = 0; i < pages.size() && utils.isClaimPage(page = pages.get(i)); ++i) {
            CharSequence[] membersArray = page.split("\\n");
            for (int j = 1; j < membersArray.length; ++j) {
                if (!membersArray[j].equalsIgnoreCase(search)) continue;
                membersArray[j] = replace;
            }
            pages.set(i, String.join((CharSequence)"\n", membersArray));
        }
        return false;
    }

    private static int getBlocksPerPixel(MapView.Scale scale) {
        int blocksPerPixel = 0;
        switch (scale) {
            case CLOSEST: {
                blocksPerPixel = 1;
                break;
            }
            case CLOSE: {
                blocksPerPixel = 2;
                break;
            }
            case NORMAL: {
                blocksPerPixel = 4;
                break;
            }
            case FAR: {
                blocksPerPixel = 8;
                break;
            }
            case FARTHEST: {
                blocksPerPixel = 16;
            }
        }
        return blocksPerPixel;
    }

    public static MapRenderer createClaimRenderer(final OfflinePlayer creator) {
        return new MapRenderer(){
            final OfflinePlayer owner;
            long lastUpdate;
            Map<String, Coords2D> claims;
            int blocksPerPixel;
            {
                this.owner = creator;
                this.lastUpdate = 0L;
                this.claims = null;
                this.blocksPerPixel = 0;
            }

            public void render(MapView view, MapCanvas canvas, Player p) {
                int centerX = view.getCenterX();
                int centerZ = view.getCenterZ();
                if (this.blocksPerPixel == 0) {
                    this.blocksPerPixel = utils.getBlocksPerPixel(view.getScale());
                }
                if (this.lastUpdate <= lastClaimUpdate || this.claims == null) {
                    World world = view.getWorld();
                    if (world != null) {
                        World.Environment env = world.getEnvironment();
                        Map<String, Coords2D> claimsNow = utils.findClaimsOnCanvas(env, centerX, centerZ, this.blocksPerPixel);
                        utils.addClaimsToCanvas(canvas, this.claims, claimsNow, this.owner, this.blocksPerPixel);
                        this.claims = claimsNow;
                        this.lastUpdate = System.nanoTime();
                    }
                } else if (this.lastUpdate < lastPlayerMoves.getOrDefault(p, 0L)) {
                    int px = 2 * (p.getLocation().getBlockX() - centerX) / this.blocksPerPixel;
                    int pz = 2 * (p.getLocation().getBlockZ() - centerZ) / this.blocksPerPixel;
                    if (px <= 127 && px >= -128 && pz <= 127 && pz >= -128) {
                        utils.addClaimsToCanvas(canvas, null, this.claims, this.owner, this.blocksPerPixel);
                        this.lastUpdate = System.nanoTime();
                    }
                }
            }
        };
    }

    private static Map<String, Coords2D> findClaimsOnCanvas(World.Environment env, int centerX, int centerZ, int blocksPerPixel) {
        HashMap<String, Coords2D> claims = new HashMap<String, Coords2D>();
        int x = centerX - 64 * blocksPerPixel;
        for (int i = 0; i < 128; i += 16 / blocksPerPixel) {
            int z = centerZ - 64 * blocksPerPixel;
            for (int j = 0; j < 128; j += 16 / blocksPerPixel) {
                String chunkID = utils.getChunkID(x, z, env);
                String claimID = utils.getClaimID(x, z, env);
                FileConfiguration claimData = utils.plugin.cfg.getClaimData();
                if (claimData.contains(claimID)) {
                    claims.put(chunkID, new Coords2D(i, j));
                }
                z += 16;
            }
            x += 16;
        }
        return claims;
    }

    private static void addClaimsToCanvas(MapCanvas canvas, Map<String, Coords2D> claimsBefore, Map<String, Coords2D> claimsNow, OfflinePlayer p, int blocksPerPixel) {
        int chunkPixels = 16 / blocksPerPixel;
        if (claimsBefore != null) {
            claimsBefore.values().removeAll(claimsNow.values());
            for (String string : claimsBefore.keySet()) {
                Coords2D c = claimsBefore.get(string);
                int x0 = c.x;
                int z0 = c.z;
                for (int dx = 0; dx < chunkPixels; ++dx) {
                    for (int dz = 0; dz < chunkPixels; ++dz) {
                        canvas.setPixel(x0 + dx, z0 + dz, canvas.getBasePixel(x0 + dx, z0 + dz));
                    }
                }
            }
        }
        HashMap<String, Byte> chunkColor = new HashMap<String, Byte>();
        for (String chunkID : claimsNow.keySet()) {
            Coords2D c = claimsNow.get(chunkID);
            String claimID = utils.getClaimID(chunkID);
            boolean member = utils.isMemberOfClaim(utils.getMembers(claimID), p);
            String cfg = member ? "my-claims" : "others-claims";
            int r = plugin.getConfig().getInt("claim-map-colors." + cfg + ".r");
            int n = plugin.getConfig().getInt("claim-map-colors." + cfg + ".g");
            int b = plugin.getConfig().getInt("claim-map-colors." + cfg + ".b");
            byte color = MapPalette.matchColor((int)r, (int)n, (int)b);
            chunkColor.put(chunkID, color);
        }
        HashMap<Byte, Set> hashMap = new HashMap<Byte, Set>();
        for (Map.Entry e : chunkColor.entrySet()) {
            hashMap.computeIfAbsent((Byte)e.getValue(), k -> new HashSet()).add((String)e.getKey());
        }
        for (Map.Entry grp : hashMap.entrySet()) {
            byte color = (Byte)grp.getKey();
            Set chunks = (Set)grp.getValue();
            record ChunkPos(int x, int z) {
            }
            HashMap<ChunkPos, Coords2D> posMap = new HashMap<ChunkPos, Coords2D>();
            for (String string : chunks) {
                String[] parts = string.split("\\|")[1].split(",");
                int cx = Integer.parseInt(parts[0]);
                int cz = Integer.parseInt(parts[1]);
                posMap.put(new ChunkPos(cx, cz), claimsNow.get(string));
            }
            for (Map.Entry entry : posMap.entrySet()) {
                int dx;
                int dz;
                ChunkPos cp = (ChunkPos)entry.getKey();
                Coords2D pix = (Coords2D)entry.getValue();
                int x0 = pix.x;
                int z0 = pix.z;
                int x1 = x0 + chunkPixels - 1;
                int z1 = z0 + chunkPixels - 1;
                if (!posMap.containsKey(new ChunkPos(cp.x - 1, cp.z))) {
                    for (dz = 0; dz < chunkPixels; ++dz) {
                        canvas.setPixel(x0, z0 + dz, color);
                    }
                }
                if (!posMap.containsKey(new ChunkPos(cp.x + 1, cp.z))) {
                    for (dz = 0; dz < chunkPixels; ++dz) {
                        canvas.setPixel(x1, z0 + dz, color);
                    }
                }
                if (!posMap.containsKey(new ChunkPos(cp.x, cp.z - 1))) {
                    for (dx = 0; dx < chunkPixels; ++dx) {
                        canvas.setPixel(x0 + dx, z0, color);
                    }
                }
                if (posMap.containsKey(new ChunkPos(cp.x, cp.z + 1))) continue;
                for (dx = 0; dx < chunkPixels; ++dx) {
                    canvas.setPixel(x0 + dx, z1, color);
                }
            }
        }
    }

    public static MapRenderer createIntruderRenderer(final OfflinePlayer creator) {
        return new MapRenderer(){
            final OfflinePlayer owner;
            int blocksPerPixel;
            {
                this.owner = creator;
                this.blocksPerPixel = 0;
            }

            public void render(MapView view, MapCanvas canvas, Player p) {
                if (this.blocksPerPixel == 0) {
                    this.blocksPerPixel = utils.getBlocksPerPixel(view.getScale());
                }
                if (!intruders.isEmpty()) {
                    int centerX = view.getCenterX();
                    int centerZ = view.getCenterZ();
                    utils.addIntrudersToCanvas(canvas, centerX, centerZ, this.blocksPerPixel, this.owner);
                } else {
                    canvas.setCursors(new MapCursorCollection());
                }
            }
        };
    }

    private static void addIntrudersToCanvas(MapCanvas canvas, int centerX, int centerZ, int blocksPerPixel, OfflinePlayer p) {
        MapCursorCollection cursors = new MapCursorCollection();
        for (String claimID : intruders.keySet()) {
            String[] members;
            boolean isMember;
            FileConfiguration claimData = utils.plugin.cfg.getClaimData();
            if (!claimData.contains(claimID) || !(isMember = utils.isMemberOfClaim(members = utils.getMembers(claimID), p))) continue;
            for (Player intruder : intruders.get(claimID)) {
                int px = 2 * (intruder.getLocation().getBlockX() - centerX) / blocksPerPixel;
                int pz = 2 * (intruder.getLocation().getBlockZ() - centerZ) / blocksPerPixel;
                if (px > 127 || px < -128 || pz > 127 || pz < -128 || canvas.getBasePixel((px + 128) / 2, (pz + 128) / 2) == 0) continue;
                MapCursor cursor = utils.getMapCursor(intruder, (byte)px, (byte)pz);
                cursors.addCursor(cursor);
            }
        }
        canvas.setCursors(cursors);
    }

    private static MapCursor getMapCursor(Player intruder, byte px, byte pz) {
        double yaw = intruder.getLocation().getYaw();
        byte direction = (byte)Math.min(15.0, Math.max(0.0, (yaw + 371.25) % 360.0 / 22.5));
        MapCursor.Type type = MapCursor.Type.RED_MARKER;
        String caption = intruder.getName();
        return new MapCursor(px, pz, direction, type, true, caption);
    }

    public static String getWorldName(World.Environment env) {
        return switch (env) {
            case World.Environment.NORMAL -> "The Overworld";
            case World.Environment.NETHER -> "The Nether";
            case World.Environment.THE_END -> "The End";
            default -> "Unknown World";
        };
    }

    public static void removeExpiredB4BGracePeriods() {
        HashSet<Block> expiredGracePeriods = new HashSet<Block>();
        for (Map.Entry<Block, GracePeriod> entry : b4bGracePeriods.entrySet()) {
            if (!((double)(System.nanoTime() - entry.getValue().timestamp) >= (double)gracePeriod * 1.0E9) && entry.getValue().type.equals((Object)entry.getKey().getType())) continue;
            expiredGracePeriods.add(entry.getKey());
        }
        for (Block expired : expiredGracePeriods) {
            b4bGracePeriods.remove(expired);
        }
    }

    public static void removeExpiredBlockChangeGracePeriods() {
        HashSet<Location> expiredGracePeriods = new HashSet<Location>();
        for (Map.Entry<Location, GracePeriod> entry : blockChangeGracePeriods.entrySet()) {
            if (!((double)(System.nanoTime() - entry.getValue().timestamp) >= (double)gracePeriod * 1.0E9)) continue;
            expiredGracePeriods.add(entry.getKey());
        }
        for (Location expired : expiredGracePeriods) {
            blockChangeGracePeriods.remove(expired);
        }
    }

    public static void sendWelcomeMsg(Player player) {
        List welcomeMessages = plugin.getConfig().getStringList("welcome-messages");
        for (String msg : welcomeMessages) {
            player.sendMessage(utils.chat(msg));
        }
        utils.plugin.pluginManager.callEvent((Event)new WelcomeMsgSentEvent(player));
    }

    public static void updateBossBar(final Player p, final String currentClaimID) {
        if (!bossBars.containsKey(p)) {
            utils.addBossBar(p);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                BossBar bossBar = bossBars.get(p);
                FileConfiguration claimData = utils.plugin.cfg.getClaimData();
                boolean isClaimed = claimData.contains(currentClaimID);
                if (!isClaimed) {
                    bossBar.setColor(BarColor.WHITE);
                    bossBar.setTitle(utils.hasClaims(p) ? "Unclaimed" : "Unclaimed (place book on lectern to claim)");
                    bossBar.setProgress(0.0);
                    return;
                }
                String coordsStr = utils.getCoordsString(p, currentClaimID);
                if (utils.isIntruder(p, currentClaimID)) {
                    bossBar.setColor(BarColor.RED);
                    bossBar.setTitle("Claimed at " + coordsStr + " (Intruding)");
                } else {
                    bossBar.setColor(BarColor.GREEN);
                    bossBar.setTitle("Claimed at " + coordsStr);
                }
                Set<BlockFace> protectedBlockFaces = protectiveBlockFaces;
                String claimID = utils.getClaimID(p.getLocation());
                double lecternX = claimData.getDouble(claimID + ".location.X", Double.MAX_VALUE);
                double lecternY = claimData.getDouble(claimID + ".location.Y", Double.MAX_VALUE);
                double lecternZ = claimData.getDouble(claimID + ".location.Z", Double.MAX_VALUE);
                if (lecternX == Double.MAX_VALUE || lecternY == Double.MAX_VALUE || lecternZ == Double.MAX_VALUE) {
                    plugin.getLogger().warning("No valid lectern found for claim: " + claimID);
                    return;
                }
                Location lecternLocation = new Location(p.getWorld(), lecternX, lecternY, lecternZ);
                Block claimBlock = lecternLocation.getBlock();
                long protectedCount = utils.countProtectedSides(claimBlock);
                int totalSides = protectedBlockFaces.size();
                if (totalSides == 0) {
                    bossBar.setProgress(0.0);
                    return;
                }
                double progress = (double)protectedCount / (double)totalSides;
                bossBar.setProgress(progress);
            }
        }, 2L);
    }

    private static void addBossBar(Player p) {
        boolean sendLecternMsgs = plugin.getConfig().getBoolean("lectern-message-settings.send-lectern-messages");
        BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        if (sendLecternMsgs) {
            bossBar.addPlayer(p);
        }
        bossBars.put(p, bossBar);
    }

    private static String getCoordsString(Player p, String claimID) {
        Object result;
        FileConfiguration claimData = utils.plugin.cfg.getClaimData();
        double x = claimData.getDouble(claimID + ".location.X");
        double y = claimData.getDouble(claimID + ".location.Y");
        double z = claimData.getDouble(claimID + ".location.Z");
        boolean hideCoords = plugin.getConfig().getBoolean("hide-coords-globally") || !utils.showCoordsInMsgs(p);
        boolean showExactCoords = plugin.getConfig().getBoolean("lectern-message-settings.show-exact-coords");
        boolean showY = plugin.getConfig().getBoolean("lectern-message-settings.show-y");
        if (hideCoords) {
            result = "[hidden]";
        } else if (showExactCoords) {
            result = "(" + (int)x + ", " + String.valueOf(showY ? Integer.valueOf((int)y) : "??") + ", " + (int)z + ")";
        } else {
            double signX = x == 0.0 ? 1.0 : Math.signum(x);
            double signY = y == 0.0 ? 1.0 : Math.signum(y);
            double signZ = z == 0.0 ? 1.0 : Math.signum(z);
            int chunkCenterX = (int)(x - x % 16.0 + signX * 8.0);
            int chunkCenterY = (int)(y - y % 16.0 + signY * 8.0);
            int chunkCenterZ = (int)(z - z % 16.0 + signZ * 8.0);
            result = "(" + chunkCenterX + ", " + String.valueOf(showY ? Integer.valueOf(chunkCenterY) : "??") + ", " + chunkCenterZ + ")";
        }
        return result;
    }

    public static boolean isAir(Material type) {
        return airTypes.contains(type);
    }

    public static void updateCurrentTick() {
        ++currentTick;
    }

    public static <E extends Enum<E>> String prettifyEnumName(E theEnum) {
        return WordUtils.capitalizeFully((String)theEnum.name().replaceAll("_", " "));
    }

    public static boolean willLavaFlowAt(int blockY, World.Environment dimension) {
        return blockY <= lavaFlowMaxY || dimension == World.Environment.NETHER;
    }

    public static boolean isPhantomElytra(ItemStack itemStack) {
        ItemMeta meta;
        if (itemStack != null && itemStack.getType() == Material.ELYTRA && (meta = itemStack.getItemMeta()) != null && meta.getLore() != null) {
            return ((String)meta.getLore().get(0)).equals("An inferior version that can only glide for a second");
        }
        return false;
    }

    public static boolean canOpenChest(Block block, Player player) {
        if (!(block.getState() instanceof org.bukkit.block.Chest)) {
            return false;
        }
        org.bukkit.block.Chest chestState = (org.bukkit.block.Chest)block.getState();
        ArrayList<Block> chestBlocks = new ArrayList<Block>();
        if (chestState.getInventory() instanceof DoubleChestInventory) {
            DoubleChestInventory doubleInv = (DoubleChestInventory)chestState.getInventory();
            if (doubleInv.getHolder() instanceof DoubleChest) {
                DoubleChest doubleChest = doubleInv.getHolder();
                org.bukkit.block.Chest leftChest = (org.bukkit.block.Chest)doubleChest.getLeftSide();
                org.bukkit.block.Chest rightChest = (org.bukkit.block.Chest)doubleChest.getRightSide();
                Block leftBlock = leftChest.getLocation().getBlock();
                Block rightBlock = rightChest.getLocation().getBlock();
                chestBlocks.add(leftBlock);
                chestBlocks.add(rightBlock);
            } else {
                chestBlocks.add(block);
            }
        } else {
            chestBlocks.add(block);
        }
        for (Block chestBlock : chestBlocks) {
            Block above = chestBlock.getRelative(BlockFace.UP);
            if (!above.getType().isOccluding()) continue;
            return false;
        }
        return true;
    }

    private static BlockFace getConnectedFace(Chest chestData) {
        switch (chestData.getFacing()) {
            case NORTH: {
                return chestData.getType() == Chest.Type.LEFT ? BlockFace.WEST : BlockFace.EAST;
            }
            case SOUTH: {
                return chestData.getType() == Chest.Type.LEFT ? BlockFace.EAST : BlockFace.WEST;
            }
            case EAST: {
                return chestData.getType() == Chest.Type.LEFT ? BlockFace.NORTH : BlockFace.SOUTH;
            }
            case WEST: {
                return chestData.getType() == Chest.Type.LEFT ? BlockFace.SOUTH : BlockFace.NORTH;
            }
        }
        return BlockFace.SELF;
    }

    private static boolean isDoubleChest(Block chest1, Block chest2) {
        if (chest1.getType() != Material.CHEST || chest2.getType() != Material.CHEST) {
            return false;
        }
        org.bukkit.block.Chest chestState1 = (org.bukkit.block.Chest)chest1.getState();
        org.bukkit.block.Chest chestState2 = (org.bukkit.block.Chest)chest2.getState();
        return chestState1.getInventory().getHolder() == chestState2.getInventory().getHolder();
    }

    static {
        masterBookChangeMsgSent = false;
        isPaperServer = true;
        canUseReflection = true;
        lastClaimUpdate = 0L;
        gracePeriod = 0;
        currentTick = 0L;
    }

    public static class SpawnEggUtils {
        private static final NamespacedKey eggKey = new NamespacedKey((Plugin)Block4Block.getInstance(), "black_bear_spawn_egg");

        public static ItemStack getRandomSpawnEgg(Map<Character, Integer> letterBonuses) {
            ConfigurationSection weightConfig = Block4Block.getInstance().getConfig().getConfigurationSection("spawn-egg-weights");
            Random rand = new Random();
            int totalWeight = SpawnEggUtils.calcTotalWeight(letterBonuses);
            int i = rand.nextInt(totalWeight);
            if (weightConfig != null) {
                for (String eggName : weightConfig.getKeys(false)) {
                    Character firstLetter = Character.valueOf(eggName.toLowerCase().charAt(0));
                    Integer bonus = letterBonuses.get(firstLetter);
                    int weight = weightConfig.getInt(eggName);
                    if (bonus != null) {
                        weight *= 1 + bonus;
                    }
                    i -= weight;
                    if (eggName.equalsIgnoreCase("BLACK_BEAR_SPAWN_EGG")) {
                        return SpawnEggUtils.createBlackBearEgg();
                    }
                    if (i > 0) continue;
                    return new ItemStack(Material.valueOf((String)eggName));
                }
            }
            return new ItemStack(Material.TROPICAL_FISH_SPAWN_EGG);
        }

        private static int calcTotalWeight(Map<Character, Integer> letterBonuses) {
            ConfigurationSection weightConfig = Block4Block.getInstance().getConfig().getConfigurationSection("spawn-egg-weights");
            int totalWeight = 0;
            if (weightConfig != null) {
                for (String eggName : weightConfig.getKeys(false)) {
                    Character firstLetter = Character.valueOf(eggName.toLowerCase().charAt(0));
                    Integer bonus = letterBonuses.get(firstLetter);
                    int weight = weightConfig.getInt(eggName);
                    if (bonus != null) {
                        weight *= 1 + bonus;
                    }
                    totalWeight += weight;
                }
            }
            return totalWeight;
        }

        public static ItemStack createBlackBearEgg() {
            ItemStack egg = new ItemStack(Material.COAL);
            ItemMeta meta = egg.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.WHITE) + "Black Bear Spawn Egg");
                meta.getPersistentDataContainer().set(eggKey, PersistentDataType.BYTE, (Object)1);
                egg.setItemMeta(meta);
            }
            return egg;
        }
    }
}

