/*
 * Decompiled with CFR 0.152.
 */
package com.codex.onlyvanadv;

import com.codex.onlyvanadv.config.OvaConfig;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_163;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_8781;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyVanillaAdvancements
implements ModInitializer {
    public static final String MOD_ID = "only_vanilla_advancements";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"only_vanilla_advancements");

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::filterAdvancements);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, rm, success) -> {
            if (success) {
                this.filterAdvancements(server);
            }
        });
    }

    private void filterAdvancements(MinecraftServer server) {
        try {
            boolean changed;
            class_2989 loader = server.method_3851();
            class_163 manager = loader.method_53646();
            OvaConfig cfg = OvaConfig.loadOrCreate();
            HashMap<class_2960, class_8781> nodes = new HashMap<class_2960, class_8781>();
            HashSet<class_2960> allIds = new HashSet<class_2960>();
            for (class_8781 pa : manager.method_53693()) {
                class_2960 id = pa.method_53649().comp_1919();
                nodes.put(id, pa);
                allIds.add(id);
            }
            HashSet<String> keepMods = new HashSet<String>(cfg.kept_mods);
            HashSet<String> removeMods = new HashSet<String>(cfg.removed_mods);
            Set<class_2960> keepIds = this.parseIdSet(cfg.kept_advancements);
            Set<class_2960> removeIds = this.parseIdSet(cfg.removed_advancements);
            if (cfg.keep_parent_advancements) {
                ArrayDeque<class_2960> stack = new ArrayDeque<class_2960>(keepIds);
                while (!stack.isEmpty()) {
                    class_2960 pid;
                    class_8781 parent;
                    class_2960 id = (class_2960)stack.pop();
                    class_8781 pa = (class_8781)nodes.get(id);
                    if (pa == null || (parent = pa.method_53651()) == null || keepIds.contains(pid = parent.method_53649().comp_1919())) continue;
                    keepIds.add(pid);
                    stack.push(pid);
                }
            }
            class_3300 rm = server.method_34864();
            HashSet<class_2960> toRemove = new HashSet<class_2960>();
            for (class_2960 id : allIds) {
                boolean isKept = keepIds.contains(id) || keepMods.contains(id.method_12836());
                boolean isMinecraft = "minecraft".equals(id.method_12836());
                if (isKept) continue;
                if (!isMinecraft) {
                    toRemove.add(id);
                    continue;
                }
                boolean isTrueVanilla = this.isEffectiveVanilla(rm, id);
                if (isTrueVanilla || keepIds.contains(id) || keepMods.contains("minecraft")) continue;
                toRemove.add(id);
            }
            do {
                changed = false;
                for (class_2960 id : new HashSet(allIds)) {
                    class_2960 pid;
                    class_8781 parent;
                    class_8781 pa;
                    if (toRemove.contains(id) || "minecraft".equals(id.method_12836()) || keepMods.contains(id.method_12836()) || keepIds.contains(id) || (pa = (class_8781)nodes.get(id)) == null || (parent = pa.method_53651()) == null || !toRemove.contains(pid = parent.method_53649().comp_1919())) continue;
                    toRemove.add(id);
                    changed = true;
                }
            } while (changed);
            if (!toRemove.isEmpty()) {
                manager.method_713(toRemove);
                server.method_3760().method_14571().forEach(p -> p.method_14236().method_12886(loader));
                LOGGER.info("OnlyVanillaAdvancements: removed {} advancements (after rules).", (Object)toRemove.size());
            } else {
                LOGGER.info("OnlyVanillaAdvancements: no removals needed.");
            }
        }
        catch (Throwable t) {
            LOGGER.error("OnlyVanillaAdvancements: filtering failed", t);
        }
    }

    private String safePackId(class_3298 res) {
        try {
            return res.method_14480();
        }
        catch (Throwable t) {
            return "";
        }
    }

    private boolean isEffectiveVanilla(class_3300 rm, class_2960 advId) {
        try {
            String resPath = "advancements/" + advId.method_12832() + ".json";
            class_2960 resId = class_2960.method_60655((String)"minecraft", (String)resPath);
            Optional opt = rm.method_14486(resId);
            if (opt.isEmpty()) {
                return true;
            }
            String pid = this.safePackId((class_3298)opt.get());
            return this.isBuiltinPack(pid);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private boolean isBuiltinPack(String pid) {
        String p = pid == null ? "" : pid.toLowerCase();
        return p.equals("vanilla") || p.equals("minecraft") || p.contains("builtin") || p.contains("default");
    }

    private Set<class_2960> parseIdSet(Collection<String> raw) {
        HashSet<class_2960> out = new HashSet<class_2960>();
        if (raw == null) {
            return out;
        }
        for (String s : raw) {
            class_2960 id;
            if (s == null || s.isBlank() || (id = class_2960.method_12829((String)s.trim())) == null) continue;
            out.add(id);
        }
        return out;
    }
}

