/*
 * Decompiled with CFR 0.152.
 */
package com.codex.onlyvanadv.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OvaConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"only_vanilla_advancements-config");
    public final Set<String> kept_mods = new HashSet<String>();
    public final Set<String> kept_advancements = new HashSet<String>();
    public final Set<String> removed_mods = new HashSet<String>();
    public final Set<String> removed_advancements = new HashSet<String>();
    public boolean keep_parent_advancements = true;

    public static Path configDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static Path tomlPath() {
        return OvaConfig.configDir().resolve("only_vanilla_advancements.toml");
    }

    public static OvaConfig loadOrCreate() {
        OvaConfig ovaConfig;
        block9: {
            Path path = OvaConfig.tomlPath();
            if (!Files.exists(path, new LinkOption[0])) {
                OvaConfig cfg = new OvaConfig();
                cfg.saveWithComments();
                return cfg;
            }
            CommentedFileConfig c = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
            try {
                c.load();
                ovaConfig = OvaConfig.fromToml((CommentedConfig)c);
                if (c == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to load {}: {}. Using defaults.", (Object)path.getFileName(), (Object)t.toString());
                    OvaConfig cfg = new OvaConfig();
                    cfg.saveWithComments();
                    return cfg;
                }
            }
            c.close();
        }
        return ovaConfig;
    }

    private static OvaConfig fromToml(CommentedConfig c) {
        OvaConfig cfg = new OvaConfig();
        cfg.kept_mods.addAll(OvaConfig.readStrList(c, "kept_mods"));
        cfg.kept_advancements.addAll(OvaConfig.readStrList(c, "kept_advancements"));
        cfg.removed_mods.addAll(OvaConfig.readStrList(c, "removed_mods"));
        cfg.removed_advancements.addAll(OvaConfig.readStrList(c, "removed_advancements"));
        Object b = c.get("keep_parent_advancements");
        cfg.keep_parent_advancements = b instanceof Boolean ? (Boolean)b : true;
        return cfg;
    }

    public void saveWithComments() {
        Path path = OvaConfig.tomlPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (CommentedFileConfig c = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();){
            c.load();
            c.set("#", (Object)"Only Vanilla Advancements - Config");
            c.set("#1", (Object)"Vanilla (minecraft:*) is always kept. This file lets you keep/remove non-vanilla entries.");
            c.set("kept_mods", new ArrayList<String>(this.kept_mods));
            c.setComment("kept_mods", "Keep ALL advancements from these mods/datapacks (their short id, e.g. myquests)");
            c.set("kept_advancements", new ArrayList<String>(this.kept_advancements));
            c.setComment("kept_advancements", "Keep these specific advancement IDs (e.g. myquests:story/root)");
            c.set("removed_mods", new ArrayList<String>(this.removed_mods));
            c.setComment("removed_mods", "Always remove ALL advancements from these mods/datapacks");
            c.set("removed_advancements", new ArrayList<String>(this.removed_advancements));
            c.setComment("removed_advancements", "Always remove these specific advancement IDs");
            c.set("keep_parent_advancements", (Object)this.keep_parent_advancements);
            c.setComment("keep_parent_advancements", "If true, keeping an advancement also keeps its required parents so the UI looks correct (recommended)");
            c.save();
        }
    }

    private static List<String> readStrList(CommentedConfig c, String key) {
        Object v = c.get(key);
        if (v instanceof List) {
            List list = (List)v;
            ArrayList<String> out = new ArrayList<String>();
            for (Object o : list) {
                if (o == null) continue;
                out.add(o.toString());
            }
            return out;
        }
        return new ArrayList<String>();
    }
}

