/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.entrypoints;

import com.google.inject.Injector;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.lazyio.injectables.ReloadableManager;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;

public final class Main
implements ModInitializer {
    private ReloadableManager reloadableManager;

    public void onInitialize() {
        Injector injector = UnforgivingVoidConstants.getInjector();
        ((TranslatorFactory)injector.getInstance(TranslatorFactory.class)).addTranslator("unforgivingvoid");
        this.reloadableManager = (ReloadableManager)injector.getInstance(ReloadableManager.class);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
    }

    private void onServerStarted(MinecraftServer server) {
        UnforgivingVoidConstants.setServer(server);
        this.reloadableManager.reload("dynamic_unforgivingvoid_customDimensionConfigs");
    }

    private void onServerStopping(MinecraftServer server) {
        UnforgivingVoidConstants.setServer(null);
    }
}

