/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.config;

import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.injectables.ConfigScreenBuilderFactory;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenBuilder;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfigManager;
import dev.the_fireplace.unforgivingvoid.config.FallbackDimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.TargetSpawnPositioning;
import dev.the_fireplace.unforgivingvoid.domain.config.DimensionSettings;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.minecraft.class_2960;
import net.minecraft.class_437;

@Singleton
public final class UVConfigScreenFactory {
    private static final String TRANSLATION_BASE = "text.config.unforgivingvoid.";
    private static final String OPTION_TRANSLATION_BASE = "text.config.unforgivingvoid.option.";
    private final Translator translator;
    private final ConfigScreenBuilderFactory configScreenBuilderFactory;
    private final DimensionConfigManager dimensionConfigManager;
    private final DimensionConfig fallbackDimensionConfig;
    private final DimensionSettings defaultFallbackSettings;
    private ConfigScreenBuilder configScreenBuilder;

    @Inject
    public UVConfigScreenFactory(TranslatorFactory translatorFactory, ConfigScreenBuilderFactory configScreenBuilderFactory, DimensionConfigManager dimensionConfigManager, FallbackDimensionConfig fallbackDimensionConfig, @Named(value="default") DimensionSettings defaultFallbackSettings) {
        this.translator = translatorFactory.getTranslator("unforgivingvoid");
        this.configScreenBuilderFactory = configScreenBuilderFactory;
        this.dimensionConfigManager = dimensionConfigManager;
        this.fallbackDimensionConfig = fallbackDimensionConfig;
        this.defaultFallbackSettings = defaultFallbackSettings;
    }

    public class_437 getConfigScreen(class_437 parent) {
        this.configScreenBuilder = (ConfigScreenBuilder)this.configScreenBuilderFactory.create(this.translator, "text.config.unforgivingvoid.title", "text.config.unforgivingvoid.default", parent, this.dimensionConfigManager::saveAll).get();
        this.buildDefaultDimensionConfigCategory(this.fallbackDimensionConfig);
        for (class_2960 customMobId : this.dimensionConfigManager.getDimensionIdsWithCustomSettings()) {
            this.buildCustomDimensionConfigCategory(customMobId, this.dimensionConfigManager.getSettings(customMobId));
        }
        return this.configScreenBuilder.build();
    }

    private void addCommonDimensionConfigCategoryOptions(DimensionConfig dimensionConfig, DimensionSettings defaultSettings) {
        this.configScreenBuilder.addBoolToggle("text.config.unforgivingvoid.option.isEnabled", dimensionConfig.isEnabled(), defaultSettings.isEnabled(), dimensionConfig::setEnabled).setDescriptionRowCount((byte)0);
        this.configScreenBuilder.addByteField("text.config.unforgivingvoid.option.triggerDistance", dimensionConfig.getTriggerDistance(), defaultSettings.getTriggerDistance(), dimensionConfig::setTriggerDistance).setMinimum((Object)1).setDescriptionRowCount((byte)2);
        this.configScreenBuilder.addBoolToggle("text.config.unforgivingvoid.option.dropObsidian", dimensionConfig.isDropObsidian(), defaultSettings.isDropObsidian(), dimensionConfig::setDropObsidian);
        this.configScreenBuilder.addIntField("text.config.unforgivingvoid.option.fireResistanceSeconds", dimensionConfig.getFireResistanceSeconds(), defaultSettings.getFireResistanceSeconds(), dimensionConfig::setFireResistanceSeconds).setMinimum((Object)0).setDescriptionRowCount((byte)2);
        this.configScreenBuilder.addIntField("text.config.unforgivingvoid.option.slowFallingSeconds", dimensionConfig.getSlowFallingSeconds(), defaultSettings.getSlowFallingSeconds(), dimensionConfig::setSlowFallingSeconds).setMinimum((Object)0).setDescriptionRowCount((byte)2);
        this.configScreenBuilder.addIntField("text.config.unforgivingvoid.option.horizontalDistanceOffset", dimensionConfig.getHorizontalDistanceOffset(), defaultSettings.getHorizontalDistanceOffset(), dimensionConfig::setHorizontalDistanceOffset).setMinimum((Object)0);
        Set<String> dimensionIds = this.getDimensionIds();
        this.configScreenBuilder.addStringDropdown("text.config.unforgivingvoid.option.targetDimension", dimensionConfig.getTargetDimension(), defaultSettings.getTargetDimension(), dimensionIds, dimensionConfig::setTargetDimension).setDescriptionRowCount((byte)2);
        this.configScreenBuilder.addEnumDropdown("text.config.unforgivingvoid.option.transferPositionMode", (Enum)dimensionConfig.getTransferPositionMode(), (Enum)defaultSettings.getTransferPositionMode(), (Enum[])TargetSpawnPositioning.values(), dimensionConfig::setTransferPositionMode).setDescriptionRowCount((byte)0);
    }

    private Set<String> getDimensionIds() {
        HashSet<String> dimensionIds = new HashSet<String>();
        for (class_2960 dimensionId : this.dimensionConfigManager.getDimensionIds()) {
            dimensionIds.add(dimensionId.toString());
        }
        return dimensionIds;
    }

    private void buildDefaultDimensionConfigCategory(DimensionConfig dimensionConfig) {
        this.addCommonDimensionConfigCategoryOptions(dimensionConfig, this.defaultFallbackSettings);
        this.createAddCustomDimensionDropdown();
    }

    private void createAddCustomDimensionDropdown() {
        this.configScreenBuilder.addStringDropdown("text.config.unforgivingvoid.option.addCustomDimensionConfig", "", "", (Iterable)this.dimensionConfigManager.getDimensionIdsWithoutCustomSettings().stream().map(class_2960::toString).sorted().collect(Collectors.toList()), newValue -> {
            if (!newValue.isEmpty()) {
                this.dimensionConfigManager.addCustom(new class_2960(newValue), this.fallbackDimensionConfig.clone());
            }
        }).setDescriptionRowCount((byte)3).setErrorSupplier(value -> this.dimensionConfigManager.isCustom(new class_2960(value)) ? Optional.of(this.translator.getTranslatedText("text.config.unforgivingvoid.option.addCustomDimensionConfig.error", new Object[0])) : Optional.empty());
    }

    private void buildCustomDimensionConfigCategory(class_2960 identifier, DimensionConfig dimensionConfig) {
        this.configScreenBuilder.startCategory("text.config.unforgivingvoid.custom", new Object[]{identifier.toString()});
        this.addCommonDimensionConfigCategoryOptions(dimensionConfig, this.fallbackDimensionConfig);
        this.createRemoveCustomDimensionButton(identifier);
    }

    private void createRemoveCustomDimensionButton(class_2960 identifier) {
        this.configScreenBuilder.addBoolToggle("text.config.unforgivingvoid.option.deleteCustomDimensionConfig", false, false, newValue -> {
            if (newValue.booleanValue()) {
                this.dimensionConfigManager.deleteCustom(identifier);
            }
        }).setDescriptionRowCount((byte)2);
    }
}

