/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.usecase;

import dev.the_fireplace.lib.api.teleport.injectables.Teleporter;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfigManager;
import dev.the_fireplace.unforgivingvoid.config.TargetSpawnPositioning;
import dev.the_fireplace.unforgivingvoid.usecase.SpawnPositionLocator;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public final class VoidTransfer {
    private final DimensionConfigManager dimensionConfigManager;
    private final Teleporter teleporter;
    private final SpawnPositionLocator spawnPositionLocator;

    @Inject
    public VoidTransfer(DimensionConfigManager dimensionConfigManager, Teleporter teleporter, SpawnPositionLocator spawnPositionLocator) {
        this.dimensionConfigManager = dimensionConfigManager;
        this.teleporter = teleporter;
        this.spawnPositionLocator = spawnPositionLocator;
    }

    public void initiateVoidTransfer(class_3222 serverPlayerEntity, MinecraftServer server) {
        class_3218 currentWorld = serverPlayerEntity.method_14220();
        DimensionConfig dimensionConfig = this.dimensionConfigManager.getSettings(currentWorld.method_27983().method_29177());
        class_3218 targetWorld = this.getTargetWorld(server, dimensionConfig);
        if (targetWorld == null) {
            UnforgivingVoidConstants.getLogger().error("Target world not found: " + dimensionConfig.getTargetDimension());
            return;
        }
        this.spawnPositionLocator.setHorizontalOffsetRange(dimensionConfig.getHorizontalDistanceOffset());
        class_2338 spawnPos = this.getSpawnPos(serverPlayerEntity, currentWorld, dimensionConfig, targetWorld);
        class_1297 teleportedEntity = this.teleporter.teleport((class_1297)serverPlayerEntity, targetWorld, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
        this.applyStatusEffects((class_3222)teleportedEntity, dimensionConfig);
        this.createAssistanceMaterials(dimensionConfig, targetWorld, spawnPos);
        UnforgivingVoidConstants.getLogger().debug("Player teleport complete. New position is {}, and new world is {}", (Object)teleportedEntity.method_24515().method_23854(), (Object)((class_3222)teleportedEntity).method_14220().method_27983().method_29177());
    }

    private class_2338 getSpawnPos(class_3222 serverPlayerEntity, class_3218 currentWorld, DimensionConfig dimensionConfig, class_3218 targetWorld) {
        return switch (dimensionConfig.getTransferPositionMode()) {
            case TargetSpawnPositioning.SIMILAR -> this.spawnPositionLocator.findSimilarPosition(serverPlayerEntity.method_5864(), currentWorld, targetWorld, serverPlayerEntity.method_24515());
            case TargetSpawnPositioning.SURFACE -> this.spawnPositionLocator.findSurfacePosition(serverPlayerEntity.method_5864(), currentWorld, targetWorld, serverPlayerEntity.method_24515());
            case TargetSpawnPositioning.FALL_FROM_SKY -> this.spawnPositionLocator.findSkyPosition(serverPlayerEntity.method_5864(), currentWorld, targetWorld, serverPlayerEntity.method_24515());
            case TargetSpawnPositioning.SPAWNPOINT -> this.spawnPositionLocator.findSpawnPosition(serverPlayerEntity.method_5864(), targetWorld);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Nullable
    private class_3218 getTargetWorld(MinecraftServer server, DimensionConfig dimensionConfig) {
        class_5321<class_1937> targetWorldRegistryKey = this.createTargetWorldRegistryKey(dimensionConfig);
        return server.method_3847(targetWorldRegistryKey);
    }

    private class_5321<class_1937> createTargetWorldRegistryKey(DimensionConfig dimensionConfig) {
        return class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(dimensionConfig.getTargetDimension()));
    }

    private void applyStatusEffects(class_3222 serverPlayerEntity, DimensionConfig dimensionConfig) {
        serverPlayerEntity.method_6092(new class_1293(class_1294.field_5919, 60, 3));
        if (dimensionConfig.getFireResistanceSeconds() > 0) {
            serverPlayerEntity.method_6092(new class_1293(class_1294.field_5918, dimensionConfig.getFireResistanceSeconds() * 20));
        }
        if (dimensionConfig.getSlowFallingSeconds() > 0) {
            serverPlayerEntity.method_6092(new class_1293(class_1294.field_5906, dimensionConfig.getSlowFallingSeconds() * 20));
        }
    }

    private void createAssistanceMaterials(DimensionConfig dimensionConfig, class_3218 targetWorld, class_2338 spawnPos) {
        if (dimensionConfig.isDropObsidian()) {
            targetWorld.method_8649((class_1297)new class_1542((class_1937)targetWorld, (double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), new class_1799((class_1935)class_2246.field_10540, 14)));
        }
    }
}

