/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.config;

import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import dev.the_fireplace.unforgivingvoid.config.FallbackDimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.TargetSpawnPositioning;
import dev.the_fireplace.unforgivingvoid.domain.config.DimensionSettings;
import java.util.Locale;

public class DimensionConfig
implements HierarchicalConfig,
DimensionSettings {
    protected boolean isEnabled;
    protected byte triggerDistance;
    protected boolean dropObsidian;
    protected int fireResistanceSeconds;
    protected int slowFallingSeconds;
    protected int horizontalDistanceOffset;
    protected String targetDimension;
    protected TargetSpawnPositioning transferPositionMode;

    public DimensionConfig clone() {
        DimensionConfig clone = new DimensionConfig();
        clone.isEnabled = this.isEnabled;
        clone.triggerDistance = this.triggerDistance;
        clone.dropObsidian = this.dropObsidian;
        clone.fireResistanceSeconds = this.fireResistanceSeconds;
        clone.slowFallingSeconds = this.slowFallingSeconds;
        clone.horizontalDistanceOffset = this.horizontalDistanceOffset;
        clone.targetDimension = this.targetDimension;
        clone.transferPositionMode = this.transferPositionMode;
        return clone;
    }

    public void readFrom(StorageReadBuffer buffer) {
        DimensionConfig defaultConfig = (DimensionConfig)UnforgivingVoidConstants.getInjector().getInstance(FallbackDimensionConfig.class);
        this.isEnabled = buffer.readBool("isEnabled", defaultConfig.isEnabled());
        this.triggerDistance = buffer.readByte("triggerDistance", defaultConfig.getTriggerDistance());
        this.dropObsidian = buffer.readBool("dropObsidian", defaultConfig.isDropObsidian());
        this.fireResistanceSeconds = buffer.readInt("fireResistanceSeconds", defaultConfig.getFireResistanceSeconds());
        this.slowFallingSeconds = buffer.readInt("slowFallingSeconds", defaultConfig.getSlowFallingSeconds());
        this.horizontalDistanceOffset = buffer.readInt("horizontalDistanceOffset", defaultConfig.getHorizontalDistanceOffset());
        this.targetDimension = buffer.readString("targetDimension", defaultConfig.getTargetDimension());
        this.transferPositionMode = TargetSpawnPositioning.valueOf(buffer.readString("transferPositionMode", defaultConfig.getTransferPositionMode().name()).toUpperCase(Locale.ROOT));
    }

    public void writeTo(StorageWriteBuffer buffer) {
        buffer.writeBool("isEnabled", this.isEnabled);
        buffer.writeByte("triggerDistance", this.triggerDistance);
        buffer.writeBool("dropObsidian", this.dropObsidian);
        buffer.writeInt("fireResistanceSeconds", this.fireResistanceSeconds);
        buffer.writeInt("slowFallingSeconds", this.slowFallingSeconds);
        buffer.writeInt("horizontalDistanceOffset", this.horizontalDistanceOffset);
        buffer.writeString("targetDimension", this.targetDimension);
        buffer.writeString("transferPositionMode", this.transferPositionMode.name());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public byte getTriggerDistance() {
        return this.triggerDistance;
    }

    public void setTriggerDistance(byte triggerDistance) {
        this.triggerDistance = triggerDistance;
    }

    @Override
    public boolean isDropObsidian() {
        return this.dropObsidian;
    }

    public void setDropObsidian(boolean dropObsidian) {
        this.dropObsidian = dropObsidian;
    }

    @Override
    public int getFireResistanceSeconds() {
        return this.fireResistanceSeconds;
    }

    public void setFireResistanceSeconds(int fireResistanceSeconds) {
        this.fireResistanceSeconds = fireResistanceSeconds;
    }

    @Override
    public int getSlowFallingSeconds() {
        return this.slowFallingSeconds;
    }

    public void setSlowFallingSeconds(int slowFallingSeconds) {
        this.slowFallingSeconds = slowFallingSeconds;
    }

    @Override
    public int getHorizontalDistanceOffset() {
        return this.horizontalDistanceOffset;
    }

    public void setHorizontalDistanceOffset(int horizontalDistanceOffset) {
        this.horizontalDistanceOffset = horizontalDistanceOffset;
    }

    @Override
    public String getTargetDimension() {
        return this.targetDimension;
    }

    public void setTargetDimension(String targetDimension) {
        this.targetDimension = targetDimension;
    }

    @Override
    public TargetSpawnPositioning getTransferPositionMode() {
        return this.transferPositionMode;
    }

    public void setTransferPositionMode(TargetSpawnPositioning transferPositionMode) {
        this.transferPositionMode = transferPositionMode;
    }
}

