/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.usecase;

import dev.the_fireplace.lib.api.teleport.injectables.SafePosition;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import java.util.Optional;
import java.util.Random;
import javax.inject.Inject;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class SpawnPositionLocator {
    private static final int MAX_SCAN_ITERATIONS = 2048;
    private final SafePosition safePosition;
    private int horizontalOffsetRange = 128;

    @Inject
    public SpawnPositionLocator(SafePosition safePosition) {
        this.safePosition = safePosition;
    }

    public BlockPos findSimilarPosition(EntityType<?> entityType, ServerLevel currentWorld, ServerLevel targetWorld, BlockPos currentPos) {
        int targetY;
        Optional<Vec3> spawnVec;
        Random rand = targetWorld.m_5822_();
        BlockPos targetFocalPosition = this.getDimensionScaledPosition((ResourceKey<Level>)currentWorld.m_46472_(), (ResourceKey<Level>)targetWorld.m_46472_(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to similar position, iteration {}", (Object)iteration);
            if (iteration++ < 2048) continue;
            UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding similar position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.m_46472_().m_135782_().toString());
            return this.findSpawnPosition(entityType, targetWorld);
        } while ((spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition, targetY = rand.nextInt(targetWorld.m_143344_() - 20) + 10 + targetWorld.m_141937_())).isEmpty());
        return new BlockPos(spawnVec.get());
    }

    public BlockPos findSurfacePosition(EntityType<?> entityType, ServerLevel currentWorld, ServerLevel targetWorld, BlockPos currentPos) {
        Optional<Vec3> spawnVec;
        BlockPos targetFocalPosition = this.getDimensionScaledPosition((ResourceKey<Level>)currentWorld.m_46472_(), (ResourceKey<Level>)targetWorld.m_46472_(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to surface position, iteration {}", (Object)iteration);
            if (iteration++ < 2048) continue;
            UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding surface position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.m_46472_().m_135782_().toString());
            return this.findSpawnPosition(entityType, targetWorld);
        } while ((spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition)).isEmpty());
        return new BlockPos(spawnVec.get());
    }

    public BlockPos findSkyPosition(EntityType<?> entityType, ServerLevel currentWorld, ServerLevel targetWorld, BlockPos currentPos) {
        Random rand = targetWorld.m_5822_();
        BlockPos targetFocalPosition = this.getDimensionScaledPosition((ResourceKey<Level>)currentWorld.m_46472_(), (ResourceKey<Level>)targetWorld.m_46472_(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to sky position, iteration {}", (Object)iteration);
            int spawnHeight = targetWorld.m_7726_().m_8481_().m_142051_((LevelHeightAccessor)targetWorld);
            int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.m_123341_());
            int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.m_123343_());
            int targetY = rand.nextInt(targetWorld.m_143344_() - spawnHeight) + spawnHeight - 6;
            BlockPos attemptPos = new BlockPos(targetX, targetY, targetZ);
            if (!this.isSafeSky(entityType, targetWorld, attemptPos)) continue;
            return attemptPos;
        } while (iteration++ < 2048);
        UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding sky position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.m_46472_().m_135782_().toString());
        return this.findSpawnPosition(entityType, targetWorld);
    }

    public BlockPos findSpawnPosition(EntityType<?> entityType, ServerLevel targetWorld) {
        BlockPos targetFocalPosition = targetWorld.m_8900_();
        Optional<Vec3> spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition);
        int iteration = 0;
        while (spawnVec.isEmpty()) {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to spawn position, iteration {}", (Object)iteration);
            if (iteration++ >= 2048) {
                UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding spawn position in {}, falling back to the built in spawn position even though it may be unsafe.", (Object)targetWorld.m_46472_().m_135782_().toString());
                return targetFocalPosition;
            }
            spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition);
        }
        return new BlockPos(spawnVec.get());
    }

    private Optional<Vec3> findSafePlatform(EntityType<?> entityType, ServerLevel targetWorld, BlockPos targetFocalPosition, int targetY) {
        Random rand = targetWorld.m_5822_();
        int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.m_123341_());
        int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.m_123343_());
        BlockPos attemptPos = new BlockPos(targetX, targetY, targetZ);
        return this.safePosition.findBy(entityType, (CollisionGetter)targetWorld, attemptPos);
    }

    private Optional<Vec3> findSafePlatform(EntityType<?> entityType, ServerLevel targetWorld, BlockPos targetFocalPosition) {
        Random rand = targetWorld.m_5822_();
        int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.m_123341_());
        int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.m_123343_());
        int targetY = targetWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, targetX, targetZ);
        BlockPos attemptPos = new BlockPos(targetX, targetY, targetZ);
        return this.safePosition.findBy(entityType, (CollisionGetter)targetWorld, attemptPos);
    }

    private boolean isSafeSky(EntityType<?> entityType, ServerLevel targetWorld, BlockPos blockPos) {
        AABB skySpawnBoundingBox = entityType.m_20585_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5).m_165887_((double)(blockPos.m_123342_() - 16));
        return targetWorld.m_45772_(skySpawnBoundingBox);
    }

    private BlockPos getDimensionScaledPosition(ResourceKey<Level> originDimension, ResourceKey<Level> targetDimension, BlockPos inputPos) {
        if (originDimension.equals((Object)Level.f_46428_) && targetDimension.equals((Object)Level.f_46429_)) {
            return new BlockPos(inputPos.m_123341_() / 8, inputPos.m_123342_(), inputPos.m_123343_() / 8);
        }
        if (originDimension.equals((Object)Level.f_46429_) && targetDimension.equals((Object)Level.f_46428_)) {
            return new BlockPos(inputPos.m_123341_() * 8, inputPos.m_123342_(), inputPos.m_123343_() * 8);
        }
        return inputPos;
    }

    private int applyHorizontalOffset(Random rand, int xzCoordinate) {
        return xzCoordinate - this.horizontalOffsetRange + rand.nextInt(this.horizontalOffsetRange * 2);
    }

    public void setHorizontalOffsetRange(int horizontalOffsetRange) {
        this.horizontalOffsetRange = horizontalOffsetRange;
    }
}

