/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.usecase;

import dev.the_fireplace.lib.api.teleport.injectables.Teleporter;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfigManager;
import dev.the_fireplace.unforgivingvoid.config.TargetSpawnPositioning;
import dev.the_fireplace.unforgivingvoid.usecase.SpawnPositionLocator;
import javax.inject.Inject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public final class VoidTransfer {
    private final DimensionConfigManager dimensionConfigManager;
    private final Teleporter teleporter;
    private final SpawnPositionLocator spawnPositionLocator;

    @Inject
    public VoidTransfer(DimensionConfigManager dimensionConfigManager, Teleporter teleporter, SpawnPositionLocator spawnPositionLocator) {
        this.dimensionConfigManager = dimensionConfigManager;
        this.teleporter = teleporter;
        this.spawnPositionLocator = spawnPositionLocator;
    }

    public void initiateVoidTransfer(ServerPlayer serverPlayerEntity, MinecraftServer server) {
        ServerLevel currentWorld = serverPlayerEntity.m_183503_();
        DimensionConfig dimensionConfig = this.dimensionConfigManager.getSettings(currentWorld.m_46472_().m_135782_());
        ServerLevel targetWorld = this.getTargetWorld(server, dimensionConfig);
        if (targetWorld == null) {
            UnforgivingVoidConstants.getLogger().error("Target world not found: " + dimensionConfig.getTargetDimension());
            return;
        }
        this.spawnPositionLocator.setHorizontalOffsetRange(dimensionConfig.getHorizontalDistanceOffset());
        BlockPos spawnPos = this.getSpawnPos(serverPlayerEntity, currentWorld, dimensionConfig, targetWorld);
        Entity teleportedEntity = this.teleporter.teleport((Entity)serverPlayerEntity, targetWorld, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        this.applyStatusEffects((ServerPlayer)teleportedEntity, dimensionConfig);
        this.createAssistanceMaterials(dimensionConfig, targetWorld, spawnPos);
        UnforgivingVoidConstants.getLogger().debug("Player teleport complete. New position is {}, and new world is {}", (Object)teleportedEntity.m_142538_().m_123344_(), (Object)teleportedEntity.m_183503_().m_46472_().m_135782_());
    }

    private BlockPos getSpawnPos(ServerPlayer serverPlayerEntity, ServerLevel currentWorld, DimensionConfig dimensionConfig, ServerLevel targetWorld) {
        return switch (dimensionConfig.getTransferPositionMode()) {
            default -> throw new IncompatibleClassChangeError();
            case TargetSpawnPositioning.SIMILAR -> this.spawnPositionLocator.findSimilarPosition(serverPlayerEntity.m_6095_(), currentWorld, targetWorld, serverPlayerEntity.m_142538_());
            case TargetSpawnPositioning.SURFACE -> this.spawnPositionLocator.findSurfacePosition(serverPlayerEntity.m_6095_(), currentWorld, targetWorld, serverPlayerEntity.m_142538_());
            case TargetSpawnPositioning.FALL_FROM_SKY -> this.spawnPositionLocator.findSkyPosition(serverPlayerEntity.m_6095_(), currentWorld, targetWorld, serverPlayerEntity.m_142538_());
            case TargetSpawnPositioning.SPAWNPOINT -> this.spawnPositionLocator.findSpawnPosition(serverPlayerEntity.m_6095_(), targetWorld);
        };
    }

    @Nullable
    private ServerLevel getTargetWorld(MinecraftServer server, DimensionConfig dimensionConfig) {
        ResourceKey<Level> targetWorldRegistryKey = this.createTargetWorldRegistryKey(dimensionConfig);
        return server.m_129880_(targetWorldRegistryKey);
    }

    private ResourceKey<Level> createTargetWorldRegistryKey(DimensionConfig dimensionConfig) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimensionConfig.getTargetDimension()));
    }

    private void applyStatusEffects(ServerPlayer serverPlayerEntity, DimensionConfig dimensionConfig) {
        serverPlayerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 3));
        if (dimensionConfig.getFireResistanceSeconds() > 0) {
            serverPlayerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, dimensionConfig.getFireResistanceSeconds() * 20));
        }
        if (dimensionConfig.getSlowFallingSeconds() > 0) {
            serverPlayerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, dimensionConfig.getSlowFallingSeconds() * 20));
        }
    }

    private void createAssistanceMaterials(DimensionConfig dimensionConfig, ServerLevel targetWorld, BlockPos spawnPos) {
        if (dimensionConfig.isDropObsidian()) {
            targetWorld.m_7967_((Entity)new ItemEntity((Level)targetWorld, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), new ItemStack((ItemLike)Blocks.f_50080_, 14)));
        }
    }
}

