/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.config;

import com.google.common.collect.Sets;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.injectables.HierarchicalConfigManagerFactory;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.NamespacedHierarchicalConfigManager;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.FallbackDimensionConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

@Singleton
public final class DimensionConfigManager {
    public static final String DOMAIN = "unforgivingvoid_customDimensionConfigs";
    public static final Set<class_2960> DEFAULT_DIMENSIONS = Sets.newHashSet((Object[])new class_2960[]{class_1937.field_25179.method_29177(), class_1937.field_25180.method_29177(), class_1937.field_25181.method_29177()});
    private final NamespacedHierarchicalConfigManager<DimensionConfig> hierarchicalConfigManager;
    private final ConfigStateManager configStateManager;
    private final FallbackDimensionConfig defaultSettings;

    @Inject
    public DimensionConfigManager(HierarchicalConfigManagerFactory hierarchicalConfigManagerFactory, ConfigStateManager configStateManager, FallbackDimensionConfig defaultSettings) {
        this.defaultSettings = defaultSettings;
        this.configStateManager = configStateManager;
        this.hierarchicalConfigManager = hierarchicalConfigManagerFactory.createDynamicNamespaced(DOMAIN, (HierarchicalConfig)defaultSettings, DEFAULT_DIMENSIONS, () -> UnforgivingVoidConstants.getServer().method_30611().method_30530(class_2378.field_25095).method_10235());
    }

    public Iterable<class_2960> getDimensionIds() {
        return this.hierarchicalConfigManager.getAllowedModuleIds();
    }

    public Collection<class_2960> getDimensionIdsWithCustomSettings() {
        return this.hierarchicalConfigManager.getCustoms();
    }

    public Collection<class_2960> getDimensionIdsWithoutCustomSettings() {
        HashSet idsWithoutSettings = Sets.newHashSet((Iterable)this.hierarchicalConfigManager.getAllowedModuleIds());
        idsWithoutSettings.removeAll(this.getDimensionIdsWithCustomSettings());
        return idsWithoutSettings;
    }

    public DimensionConfig getSettings(class_2960 dimensionId) {
        return (DimensionConfig)this.hierarchicalConfigManager.get(dimensionId);
    }

    public boolean isCustom(class_2960 dimensionId) {
        return this.hierarchicalConfigManager.isCustom(dimensionId);
    }

    public void addCustom(class_2960 dimensionId, DimensionConfig settings) {
        this.hierarchicalConfigManager.addCustom(dimensionId, (HierarchicalConfig)settings);
    }

    public boolean deleteCustom(class_2960 dimensionId) {
        return this.hierarchicalConfigManager.deleteCustom(dimensionId);
    }

    public void saveAll() {
        this.configStateManager.save((Config)this.defaultSettings);
        this.hierarchicalConfigManager.saveAllCustoms();
    }
}

