/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.config;

import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.TargetSpawnPositioning;
import dev.the_fireplace.unforgivingvoid.domain.config.DimensionSettings;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public final class FallbackDimensionConfig
extends DimensionConfig
implements Config {
    private final DimensionSettings defaultSettings;

    @Inject
    public FallbackDimensionConfig(ConfigStateManager configStateManager, @Named(value="default") DimensionSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
        configStateManager.initialize((Config)this);
    }

    public String getId() {
        return "unforgivingvoid_defaultDimensionConfig";
    }

    public void afterReload(SimpleBuffer changedValues) {
        super.afterReload(changedValues);
    }

    @Override
    public void readFrom(StorageReadBuffer buffer) {
        this.isEnabled = buffer.readBool("isEnabled", this.defaultSettings.isEnabled());
        this.triggerDistance = buffer.readByte("triggerDistance", this.defaultSettings.getTriggerDistance());
        this.dropObsidian = buffer.readBool("dropObsidian", this.defaultSettings.isDropObsidian());
        this.fireResistanceSeconds = buffer.readInt("fireResistanceSeconds", this.defaultSettings.getFireResistanceSeconds());
        this.slowFallingSeconds = buffer.readInt("slowFallingSeconds", this.defaultSettings.getSlowFallingSeconds());
        this.horizontalDistanceOffset = buffer.readInt("horizontalDistanceOffset", this.defaultSettings.getHorizontalDistanceOffset());
        this.targetDimension = buffer.readString("targetDimension", this.defaultSettings.getTargetDimension());
        this.transferPositionMode = TargetSpawnPositioning.valueOf(buffer.readString("transferPositionMode", this.defaultSettings.getTransferPositionMode().name()).toUpperCase(Locale.ROOT));
    }
}

