/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.usecase;

import dev.the_fireplace.lib.api.teleport.injectables.SafePosition;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import java.util.Optional;
import javax.inject.Inject;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5819;

public final class SpawnPositionLocator {
    private static final int MAX_SCAN_ITERATIONS = 2048;
    private final SafePosition safePosition;
    private int horizontalOffsetRange = 128;

    @Inject
    public SpawnPositionLocator(SafePosition safePosition) {
        this.safePosition = safePosition;
    }

    public class_2338 findSimilarPosition(class_1299<?> entityType, class_3218 currentWorld, class_3218 targetWorld, class_2338 currentPos) {
        int targetY;
        Optional<class_243> spawnVec;
        class_5819 rand = targetWorld.method_8409();
        class_2338 targetFocalPosition = this.getDimensionScaledPosition((class_5321<class_1937>)currentWorld.method_27983(), (class_5321<class_1937>)targetWorld.method_27983(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to similar position, iteration {}", (Object)iteration);
            if (iteration++ < 2048) continue;
            UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding similar position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.method_27983().method_29177().toString());
            return this.findSpawnPosition(entityType, targetWorld);
        } while ((spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition, targetY = rand.method_43048(targetWorld.method_32819() - 20) + 10 + targetWorld.method_31607())).isEmpty());
        return new class_2338(spawnVec.get());
    }

    public class_2338 findSurfacePosition(class_1299<?> entityType, class_3218 currentWorld, class_3218 targetWorld, class_2338 currentPos) {
        Optional<class_243> spawnVec;
        class_2338 targetFocalPosition = this.getDimensionScaledPosition((class_5321<class_1937>)currentWorld.method_27983(), (class_5321<class_1937>)targetWorld.method_27983(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to surface position, iteration {}", (Object)iteration);
            if (iteration++ < 2048) continue;
            UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding surface position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.method_27983().method_29177().toString());
            return this.findSpawnPosition(entityType, targetWorld);
        } while ((spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition)).isEmpty());
        return new class_2338(spawnVec.get());
    }

    public class_2338 findSkyPosition(class_1299<?> entityType, class_3218 currentWorld, class_3218 targetWorld, class_2338 currentPos) {
        class_5819 rand = targetWorld.method_8409();
        class_2338 targetFocalPosition = this.getDimensionScaledPosition((class_5321<class_1937>)currentWorld.method_27983(), (class_5321<class_1937>)targetWorld.method_27983(), currentPos);
        int iteration = 0;
        do {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to sky position, iteration {}", (Object)iteration);
            int spawnHeight = targetWorld.method_14178().method_12129().method_12100((class_5539)targetWorld);
            int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.method_10263());
            int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.method_10260());
            int targetY = rand.method_43048(targetWorld.method_32819() - spawnHeight) + spawnHeight - 6;
            class_2338 attemptPos = new class_2338(targetX, targetY, targetZ);
            if (!this.isSafeSky(entityType, targetWorld, attemptPos)) continue;
            return attemptPos;
        } while (iteration++ < 2048);
        UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding sky position in {}, falling back to finding the spawn position instead.", (Object)targetWorld.method_27983().method_29177().toString());
        return this.findSpawnPosition(entityType, targetWorld);
    }

    public class_2338 findSpawnPosition(class_1299<?> entityType, class_3218 targetWorld) {
        class_2338 targetFocalPosition = targetWorld.method_43126();
        Optional<class_243> spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition);
        int iteration = 0;
        while (spawnVec.isEmpty()) {
            UnforgivingVoidConstants.getLogger().debug("Attempting to teleport to spawn position, iteration {}", (Object)iteration);
            if (iteration++ >= 2048) {
                UnforgivingVoidConstants.getLogger().warn("Max attempts exceeded for finding spawn position in {}, falling back to the built in spawn position even though it may be unsafe.", (Object)targetWorld.method_27983().method_29177().toString());
                return targetFocalPosition;
            }
            spawnVec = this.findSafePlatform(entityType, targetWorld, targetFocalPosition);
        }
        return new class_2338(spawnVec.get());
    }

    private Optional<class_243> findSafePlatform(class_1299<?> entityType, class_3218 targetWorld, class_2338 targetFocalPosition, int targetY) {
        class_5819 rand = targetWorld.method_8409();
        int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.method_10263());
        int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.method_10260());
        class_2338 attemptPos = new class_2338(targetX, targetY, targetZ);
        return this.safePosition.findBy(entityType, (class_1941)targetWorld, attemptPos);
    }

    private Optional<class_243> findSafePlatform(class_1299<?> entityType, class_3218 targetWorld, class_2338 targetFocalPosition) {
        class_5819 rand = targetWorld.method_8409();
        int targetX = this.applyHorizontalOffset(rand, targetFocalPosition.method_10263());
        int targetZ = this.applyHorizontalOffset(rand, targetFocalPosition.method_10260());
        int targetY = targetWorld.method_8624(class_2902.class_2903.field_13202, targetX, targetZ);
        class_2338 attemptPos = new class_2338(targetX, targetY, targetZ);
        return this.safePosition.findBy(entityType, (class_1941)targetWorld, attemptPos);
    }

    private boolean isSafeSky(class_1299<?> entityType, class_3218 targetWorld, class_2338 blockPos) {
        class_238 skySpawnBoundingBox = entityType.method_17683((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5).method_35575((double)(blockPos.method_10264() - 16));
        return targetWorld.method_18026(skySpawnBoundingBox);
    }

    private class_2338 getDimensionScaledPosition(class_5321<class_1937> originDimension, class_5321<class_1937> targetDimension, class_2338 inputPos) {
        if (originDimension.equals((Object)class_1937.field_25179) && targetDimension.equals((Object)class_1937.field_25180)) {
            return new class_2338(inputPos.method_10263() / 8, inputPos.method_10264(), inputPos.method_10260() / 8);
        }
        if (originDimension.equals((Object)class_1937.field_25180) && targetDimension.equals((Object)class_1937.field_25179)) {
            return new class_2338(inputPos.method_10263() * 8, inputPos.method_10264(), inputPos.method_10260() * 8);
        }
        return inputPos;
    }

    private int applyHorizontalOffset(class_5819 rand, int xzCoordinate) {
        return xzCoordinate - this.horizontalOffsetRange + rand.method_43048(this.horizontalOffsetRange * 2);
    }

    public void setHorizontalOffsetRange(int horizontalOffsetRange) {
        this.horizontalOffsetRange = horizontalOffsetRange;
    }
}

