/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.unforgivingvoid.config;

import com.google.common.collect.Sets;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.injectables.HierarchicalConfigManagerFactory;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.NamespacedHierarchicalConfigManager;
import dev.the_fireplace.unforgivingvoid.UnforgivingVoidConstants;
import dev.the_fireplace.unforgivingvoid.config.DimensionConfig;
import dev.the_fireplace.unforgivingvoid.config.FallbackDimensionConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

@Singleton
public final class DimensionConfigManager {
    public static final String DOMAIN = "unforgivingvoid_customDimensionConfigs";
    public static final Set<ResourceLocation> DEFAULT_DIMENSIONS = Sets.newHashSet((Object[])new ResourceLocation[]{Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_(), Level.f_46430_.m_135782_()});
    private final NamespacedHierarchicalConfigManager<DimensionConfig> hierarchicalConfigManager;
    private final ConfigStateManager configStateManager;
    private final FallbackDimensionConfig defaultSettings;

    @Inject
    public DimensionConfigManager(HierarchicalConfigManagerFactory hierarchicalConfigManagerFactory, ConfigStateManager configStateManager, FallbackDimensionConfig defaultSettings) {
        this.defaultSettings = defaultSettings;
        this.configStateManager = configStateManager;
        this.hierarchicalConfigManager = hierarchicalConfigManagerFactory.createDynamicNamespaced(DOMAIN, (HierarchicalConfig)defaultSettings, DEFAULT_DIMENSIONS, () -> UnforgivingVoidConstants.getServer().m_206579_().m_175515_(Registry.f_122818_).m_6566_());
    }

    public Iterable<ResourceLocation> getDimensionIds() {
        return this.hierarchicalConfigManager.getAllowedModuleIds();
    }

    public Collection<ResourceLocation> getDimensionIdsWithCustomSettings() {
        return this.hierarchicalConfigManager.getCustoms();
    }

    public Collection<ResourceLocation> getDimensionIdsWithoutCustomSettings() {
        HashSet idsWithoutSettings = Sets.newHashSet((Iterable)this.hierarchicalConfigManager.getAllowedModuleIds());
        idsWithoutSettings.removeAll(this.getDimensionIdsWithCustomSettings());
        return idsWithoutSettings;
    }

    public DimensionConfig getSettings(ResourceLocation dimensionId) {
        return (DimensionConfig)this.hierarchicalConfigManager.get(dimensionId);
    }

    public boolean isCustom(ResourceLocation dimensionId) {
        return this.hierarchicalConfigManager.isCustom(dimensionId);
    }

    public void addCustom(ResourceLocation dimensionId, DimensionConfig settings) {
        this.hierarchicalConfigManager.addCustom(dimensionId, (HierarchicalConfig)settings);
    }

    public boolean deleteCustom(ResourceLocation dimensionId) {
        return this.hierarchicalConfigManager.deleteCustom(dimensionId);
    }

    public void saveAll() {
        this.configStateManager.save((Config)this.defaultSettings);
        this.hierarchicalConfigManager.saveAllCustoms();
    }
}

