/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.trademineitemrandom.network;

import net.mcreator.trademineitemrandom.TrademineItemRandomMod;
import net.mcreator.trademineitemrandom.procedures.RTGUIProcdureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record RandomTraderGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("trademine_item_random", "random_trader_gui_buttons");

    public RandomTraderGUIButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(RandomTraderGUIButtonMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> RandomTraderGUIButtonMessage.handleButtonAction((Player)context.player().get(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RTGUIProcdureProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TrademineItemRandomMod.addNetworkMessage(ID, RandomTraderGUIButtonMessage::new, RandomTraderGUIButtonMessage::handleData);
    }
}

