/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.myceliumwar.network;

import java.util.function.Supplier;
import net.mcreator.myceliumwar.MyceliumwarMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyceliumwarModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MyceliumwarMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MyceliumwarMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ifplayerisinfected = message.data.ifplayerisinfected;
                    variables.ifplayerenterthegame = message.data.ifplayerenterthegame;
                    variables.shotgunammo = message.data.shotgunammo;
                    variables.ifplayerismyceliumman = message.data.ifplayerismyceliumman;
                    variables.timer = message.data.timer;
                    variables.supershotgunammo = message.data.supershotgunammo;
                    variables.ifplayerentertheword = message.data.ifplayerentertheword;
                    variables.ifplayerisNORcitizen = message.data.ifplayerisNORcitizen;
                    variables.ifplayerhurtcultic = message.data.ifplayerhurtcultic;
                    variables.ifplayerisdoingthemissionnor = message.data.ifplayerisdoingthemissionnor;
                    variables.isplayerrescuecultic = message.data.isplayerrescuecultic;
                    variables.pistolammo = message.data.pistolammo;
                    variables.ifplayerchattedwithnortrader = message.data.ifplayerchattedwithnortrader;
                    variables.ifplayerisdoingthemissionnor2 = message.data.ifplayerisdoingthemissionnor2;
                    variables.ifplayerisdoingthemissionnor3 = message.data.ifplayerisdoingthemissionnor3;
                    variables.ifplayerwearthecoil = message.data.ifplayerwearthecoil;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double ifplayerisinfected = 0.0;
        public double ifplayerenterthegame = 0.0;
        public double shotgunammo = 0.0;
        public double ifplayerismyceliumman = 0.0;
        public double timer = 0.0;
        public double supershotgunammo = 0.0;
        public double ifplayerentertheword = 0.0;
        public double ifplayerisNORcitizen = 0.0;
        public double ifplayerhurtcultic = 0.0;
        public double ifplayerisdoingthemissionnor = 0.0;
        public double isplayerrescuecultic = 0.0;
        public double pistolammo = 0.0;
        public double ifplayerchattedwithnortrader = 0.0;
        public double ifplayerisdoingthemissionnor2 = 0.0;
        public double ifplayerisdoingthemissionnor3 = 0.0;
        public double ifplayerwearthecoil = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("ifplayerisinfected", this.ifplayerisinfected);
            nbt.m_128347_("ifplayerenterthegame", this.ifplayerenterthegame);
            nbt.m_128347_("shotgunammo", this.shotgunammo);
            nbt.m_128347_("ifplayerismyceliumman", this.ifplayerismyceliumman);
            nbt.m_128347_("timer", this.timer);
            nbt.m_128347_("supershotgunammo", this.supershotgunammo);
            nbt.m_128347_("ifplayerentertheword", this.ifplayerentertheword);
            nbt.m_128347_("ifplayerisNORcitizen", this.ifplayerisNORcitizen);
            nbt.m_128347_("ifplayerhurtcultic", this.ifplayerhurtcultic);
            nbt.m_128347_("ifplayerisdoingthemissionnor", this.ifplayerisdoingthemissionnor);
            nbt.m_128347_("isplayerrescuecultic", this.isplayerrescuecultic);
            nbt.m_128347_("pistolammo", this.pistolammo);
            nbt.m_128347_("ifplayerchattedwithnortrader", this.ifplayerchattedwithnortrader);
            nbt.m_128347_("ifplayerisdoingthemissionnor2", this.ifplayerisdoingthemissionnor2);
            nbt.m_128347_("ifplayerisdoingthemissionnor3", this.ifplayerisdoingthemissionnor3);
            nbt.m_128347_("ifplayerwearthecoil", this.ifplayerwearthecoil);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.ifplayerisinfected = nbt.m_128459_("ifplayerisinfected");
            this.ifplayerenterthegame = nbt.m_128459_("ifplayerenterthegame");
            this.shotgunammo = nbt.m_128459_("shotgunammo");
            this.ifplayerismyceliumman = nbt.m_128459_("ifplayerismyceliumman");
            this.timer = nbt.m_128459_("timer");
            this.supershotgunammo = nbt.m_128459_("supershotgunammo");
            this.ifplayerentertheword = nbt.m_128459_("ifplayerentertheword");
            this.ifplayerisNORcitizen = nbt.m_128459_("ifplayerisNORcitizen");
            this.ifplayerhurtcultic = nbt.m_128459_("ifplayerhurtcultic");
            this.ifplayerisdoingthemissionnor = nbt.m_128459_("ifplayerisdoingthemissionnor");
            this.isplayerrescuecultic = nbt.m_128459_("isplayerrescuecultic");
            this.pistolammo = nbt.m_128459_("pistolammo");
            this.ifplayerchattedwithnortrader = nbt.m_128459_("ifplayerchattedwithnortrader");
            this.ifplayerisdoingthemissionnor2 = nbt.m_128459_("ifplayerisdoingthemissionnor2");
            this.ifplayerisdoingthemissionnor3 = nbt.m_128459_("ifplayerisdoingthemissionnor3");
            this.ifplayerwearthecoil = nbt.m_128459_("ifplayerwearthecoil");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("myceliumwar", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "myceliumwar_mapvars";
        public double ifhavechattedwithkerry = 0.0;
        public double ifhavechattedwithnito = 0.0;
        public double ifepiswilldie = 0.0;
        public double ifthekingisdead = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.ifhavechattedwithkerry = nbt.m_128459_("ifhavechattedwithkerry");
            this.ifhavechattedwithnito = nbt.m_128459_("ifhavechattedwithnito");
            this.ifepiswilldie = nbt.m_128459_("ifepiswilldie");
            this.ifthekingisdead = nbt.m_128459_("ifthekingisdead");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("ifhavechattedwithkerry", this.ifhavechattedwithkerry);
            nbt.m_128347_("ifhavechattedwithnito", this.ifhavechattedwithnito);
            nbt.m_128347_("ifepiswilldie", this.ifepiswilldie);
            nbt.m_128347_("ifthekingisdead", this.ifthekingisdead);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "myceliumwar_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ifplayerisinfected = original.ifplayerisinfected;
            clone.ifplayerenterthegame = original.ifplayerenterthegame;
            clone.shotgunammo = original.shotgunammo;
            clone.ifplayerismyceliumman = original.ifplayerismyceliumman;
            clone.timer = original.timer;
            clone.supershotgunammo = original.supershotgunammo;
            clone.ifplayerentertheword = original.ifplayerentertheword;
            clone.ifplayerisNORcitizen = original.ifplayerisNORcitizen;
            clone.ifplayerhurtcultic = original.ifplayerhurtcultic;
            clone.ifplayerisdoingthemissionnor = original.ifplayerisdoingthemissionnor;
            clone.isplayerrescuecultic = original.isplayerrescuecultic;
            clone.pistolammo = original.pistolammo;
            clone.ifplayerchattedwithnortrader = original.ifplayerchattedwithnortrader;
            clone.ifplayerisdoingthemissionnor2 = original.ifplayerisdoingthemissionnor2;
            clone.ifplayerisdoingthemissionnor3 = original.ifplayerisdoingthemissionnor3;
            clone.ifplayerwearthecoil = original.ifplayerwearthecoil;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MyceliumwarMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

