/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.ai.generator;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.Player2AppCheck;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.ChatType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.Message;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.ai.parser.ILetterParser;
import com.sighs.touhou_little_maid_epistalove.ai.prompt.IPromptBuilder;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.config.AILetterConfig;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class AILetterGenerator
implements ILetterGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String tone;
    private final String prompt;
    private final IPromptBuilder promptBuilder;
    private final ILetterParser letterParser;

    public AILetterGenerator(String tone, String prompt, IPromptBuilder promptBuilder, ILetterParser letterParser) {
        this.tone = tone;
        this.prompt = prompt;
        this.promptBuilder = promptBuilder;
        this.letterParser = letterParser;
    }

    @Override
    public void generate(ServerPlayer owner, EntityMaid maid, Consumer<ItemStack> callback) {
        this.doGenerate(owner, maid, null, callback);
    }

    @Override
    public void generateWithContext(ServerPlayer owner, EntityMaid maid, CompoundTag context, Consumer<ItemStack> callback) {
        this.doGenerate(owner, maid, context, callback);
    }

    private void doGenerate(ServerPlayer owner, EntityMaid maid, CompoundTag context, Consumer<ItemStack> callback) {
        if (!((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()) {
            LOGGER.warn("[MaidMail][AI] LLM disabled");
            callback.accept(ItemStack.EMPTY);
            return;
        }
        MaidAIChatManager chatManager = maid.getAiChatManager();
        LLMSite site = chatManager.getLLMSite();
        if (site == null) {
            LOGGER.warn("[MaidMail][AI] site not available");
            callback.accept(ItemStack.EMPTY);
            return;
        }
        if (!site.enabled()) {
            if (DefaultLLMSite.PLAYER2.id().equals(site.id())) {
                Player2AppCheck.checkPlayer2App((ServerPlayer)owner, () -> this.startAIChat(owner, maid, context, chatManager, site, callback));
                return;
            }
            LOGGER.warn("[MaidMail][AI] site disabled: {}", (Object)site.id());
            callback.accept(ItemStack.EMPTY);
            return;
        }
        this.startAIChat(owner, maid, context, chatManager, site, callback);
    }

    private void startAIChat(ServerPlayer owner, EntityMaid maid, CompoundTag context, MaidAIChatManager chatManager, LLMSite site, final Consumer<ItemStack> callback) {
        String system = this.promptBuilder.buildSystemPrompt(this.tone, maid, owner);
        String userPrompt = this.interpolatePrompt(this.prompt, context);
        LLMClient client = site.client();
        ArrayList<LLMMessage> chat = new ArrayList<LLMMessage>();
        chat.add(LLMMessage.systemChat((EntityMaid)maid, (String)system));
        chat.add(LLMMessage.userChat((EntityMaid)maid, (String)userPrompt));
        LLMConfig config = this.createEnhancedLLMConfig(chatManager.getLLMModel(), maid);
        client.chat(chat, config, (ResponseCallback)new LLMCallback(chatManager, "", 0L){

            public void onSuccess(ResponseChat responseChat) {
                String content = responseChat.chatText;
                String senderName = this.maid.getName().getString();
                ItemStack result = AILetterGenerator.this.letterParser.parseToLetter(content, senderName, this.maid);
                callback.accept(result);
            }

            public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
                LOGGER.error("[MaidMail][AI] onFailure code={} msg={}", (Object)errorCode, (Object)(throwable != null ? throwable.getMessage() : "null"));
                callback.accept(ItemStack.EMPTY);
            }

            public void onFunctionCall(Message message, List<LLMMessage> messages, LLMConfig config, LLMClient client) {
                LOGGER.warn("[MaidMail][AI] unexpected function call in letter phase; ignored");
                this.onFailure(null, new RuntimeException("Unexpected function call"), 2);
            }
        });
    }

    private String interpolatePrompt(String p, CompoundTag ctx) {
        if (ctx == null) {
            return p;
        }
        String result = p;
        for (String key : ctx.getAllKeys()) {
            String val = ctx.getString(key);
            result = result.replace("${" + key + "}", val);
        }
        return result;
    }

    @Override
    public String getType() {
        return "ai";
    }

    private LLMConfig createEnhancedLLMConfig(String model, EntityMaid maid) {
        double temperatureBoost = (Double)AILetterConfig.CREATIVITY_TEMPERATURE_BOOST.get();
        double enhancedTemperature = Math.min(1.2, (Double)AIConfig.LLM_TEMPERATURE.get() + temperatureBoost);
        int enhancedMaxTokens = Math.max((Integer)AIConfig.LLM_MAX_TOKEN.get(), 200);
        return new LLMConfig(model, enhancedTemperature, enhancedMaxTokens, maid, ChatType.AUTO_GEN_SETTING);
    }
}

