/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.ai.generator;

import com.flechazo.contact.data.PostcardDataManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.util.PostcardPackageUtil;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class PresetLetterGenerator
implements ILetterGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String title;
    private final String message;
    private final ResourceLocation postcardId;
    private final ResourceLocation parcelId;

    public PresetLetterGenerator(String title, String message, ResourceLocation postcardId, ResourceLocation parcelId) {
        this.title = title;
        this.message = message;
        this.postcardId = postcardId;
        this.parcelId = parcelId;
    }

    @Override
    public void generate(ServerPlayer owner, EntityMaid maid, Consumer<ItemStack> callback) {
        try {
            if (!PostcardDataManager.getPostcardIds().contains(this.postcardId)) {
                LOGGER.error("[MaidMail] postcard not exists id={}", (Object)this.postcardId);
                callback.accept(ItemStack.EMPTY);
                return;
            }
            String senderName = maid.getName().getString();
            ItemStack letter = PostcardPackageUtil.buildPackageWithPostcard(this.parcelId, this.title + "\n" + this.message, this.postcardId, senderName);
            callback.accept(letter);
        }
        catch (Exception e) {
            LOGGER.error("[MaidMail] Error generating preset letter: {}", (Object)e.getMessage());
            callback.accept(ItemStack.EMPTY);
        }
    }

    @Override
    public String getType() {
        return "preset";
    }
}

