/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.ai.parser;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.ai.parser.ILetterParser;
import com.sighs.touhou_little_maid_epistalove.ai.prompt.IPromptBuilder;
import com.sighs.touhou_little_maid_epistalove.config.AILetterConfig;
import com.sighs.touhou_little_maid_epistalove.util.PostcardPackageUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class JsonLetterParser
implements ILetterParser {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern JSON_OBJECT = Pattern.compile("\\{.*\\}", 32);
    private final IPromptBuilder promptBuilder;

    public JsonLetterParser(IPromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
    }

    @Override
    public ItemStack parseToLetter(String content, String senderName, EntityMaid maid) {
        Matcher m = JSON_OBJECT.matcher(content);
        if (!m.find()) {
            LOGGER.warn("[MaidMail][AI] JSON object not found in content");
            return ItemStack.EMPTY;
        }
        String json = m.group(0);
        try {
            String message;
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            String title = obj.has("title") ? obj.get("title").getAsString() : "";
            String string = message = obj.has("message") ? obj.get("message").getAsString() : "";
            if (((Boolean)AILetterConfig.ENABLE_QUALITY_FILTER.get()).booleanValue() && !this.isContentValid(title, message)) {
                LOGGER.warn("[MaidMail][AI] Content quality check failed: title='{}', message='{}'", (Object)title, (Object)message);
                return ItemStack.EMPTY;
            }
            String parcelIdStr = obj.has("parcel_id") ? obj.get("parcel_id").getAsString() : null;
            String postcardIdStr = obj.has("postcard_id") ? obj.get("postcard_id").getAsString() : null;
            ResourceLocation packageId = PostcardPackageUtil.choosePackageId(parcelIdStr);
            ResourceLocation postcardId = PostcardPackageUtil.choosePostcardId(postcardIdStr);
            if (maid != null && this.promptBuilder != null) {
                this.promptBuilder.recordGeneratedContent(maid.getStringUUID(), title, message);
            }
            return PostcardPackageUtil.buildPackageWithPostcard(packageId, title + "\n" + message, postcardId, senderName);
        }
        catch (Exception e) {
            LOGGER.error("[MaidMail][AI] parse JSON error: {}", (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }

    @Override
    public boolean isContentValid(String title, String message) {
        if (title == null || title.trim().isEmpty() || title.length() < 2) {
            return false;
        }
        int minLength = (Integer)AILetterConfig.MIN_CONTENT_LENGTH.get();
        if (message == null || message.trim().isEmpty() || message.length() < minLength) {
            return false;
        }
        String[] genericPhrases = new String[]{"\u606d\u559c", "\u795d\u8d3a", "\u52a0\u6cb9", "\u52aa\u529b", "\u7ee7\u7eed", "\u4fdd\u6301"};
        String combinedText = (title + " " + message).toLowerCase();
        int genericCount = 0;
        for (String phrase : genericPhrases) {
            if (!combinedText.contains(phrase.toLowerCase())) continue;
            ++genericCount;
        }
        int maxGenericPhrases = (Integer)AILetterConfig.MAX_GENERIC_PHRASES.get();
        return genericCount <= maxGenericPhrases;
    }
}

