/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.ai.prompt;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.ai.prompt.IPromptBuilder;
import com.sighs.touhou_little_maid_epistalove.config.AILetterConfig;
import com.sighs.touhou_little_maid_epistalove.util.PostcardPackageUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.slf4j.Logger;

public class EnhancedPromptBuilder
implements IPromptBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Queue<String>> RECENT_CONTENT_MEMORY = new ConcurrentHashMap<String, Queue<String>>();
    private static final List<String> EXPRESSION_TECHNIQUES = List.of("Use vivid sensory details", "Describe through sight, sound, smell, touch", "Employ metaphor and personification", "Build a specific atmosphere", "Use contrast and layered structure", "Add actions and scene description", "Use imagery-rich vocabulary", "Create a unique point of view");
    private static final List<String> CONTEXT_TEMPLATES = List.of("In this %s %s, ", "As the %s lingers by the windowsill, with %s, ", "With the %s surrounding us, feeling %s, ", "Under a %s sky, filled with %s, ", "Listening to the %s, in a mood of %s, ", "Sensing the %s in the air, with %s, ", "At this special moment, with %s and %s, ", "Accompanied by %s, feeling %s, ");
    private static final List<String> WEATHER_DESCRIPTIONS = List.of("breeze", "drizzle", "sunshine", "moonlight", "starlight", "snowflakes", "clouds", "morning dew");
    private static final List<String> EMOTIONAL_STATES = List.of("gentle", "joyful", "calm", "hopeful", "nostalgic", "content", "curious", "caring");

    @Override
    public String buildSystemPrompt(String tone, EntityMaid maid, ServerPlayer owner) {
        String cs;
        List<ResourceLocation> allPostcards = PostcardPackageUtil.getAllPostcardIds();
        List<ResourceLocation> allParcels = PostcardPackageUtil.getAllPackageItemIds();
        String postcardsList = allPostcards.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
        String parcelsList = allParcels.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
        String contextInfo = (Boolean)AILetterConfig.ENABLE_CONTEXT_ENRICHMENT.get() != false ? this.generateContextInfo(maid, owner) : "\u5f53\u524d\u73af\u5883\uff1a\u666e\u901a";
        String expressionTechnique = this.getRandomExpressionTechnique();
        String creativityBoost = this.generateCreativityBoost();
        String memoryConstraints = this.generateMemoryConstraints(maid.getStringUUID());
        String toneInline = tone != null && !tone.isBlank() ? tone : "Pick a suitable style word based on the player's dialogue; do not ask the player; if no clear preference, choose randomly";
        MaidAIChatManager chatManager = maid.getAiChatManager();
        Object personaSection = "";
        if (((Boolean)AILetterConfig.ENABLE_CUSTOM_PERSONA.get()).booleanValue() && (cs = chatManager.customSetting) != null && !cs.isBlank()) {
            personaSection = "[Persona]\n" + cs + "\n\n";
        }
        Object nameRuleSection = "";
        String ownerAlias = chatManager.ownerName;
        if (ownerAlias != null && !ownerAlias.isBlank()) {
            nameRuleSection = "[Naming Rule]\nYou must address the master strictly as '" + ownerAlias + "'. Do not use any other form of address.\n\n";
        }
        String clientLang = this.resolveClientLanguage(owner);
        String languageSection = "[Language Requirement]\nStrictly write in " + clientLang + ". Do not mix languages.\n\n";
        return "You are a maid. Write a heartfelt letter to your master.\n\n%s%s%s[Context]\n%s\n\n[Expression Techniques]\n- %s\n- Avoid generic phrasing; be innovative\n- Try different openings and endings each time\n- Add unique, concrete details\n\n[Creativity Tips]\n%s\n\n[Avoid Repetition]\n%s\n\nOutput strictly a single JSON object containing:\n- \"title\": creative letter title (string)\n- \"message\": engaging letter content (string, \u2264160 characters)\n- \"postcard_id\": optional, choose one most suitable from: [%s]\n- \"parcel_id\": optional, choose one most suitable from: [%s]\n\nDo not output any extra characters or explanations.\nTone: %s\n\nExample (use completely different content):\n{\"title\":\"A unique title\",\"message\":\"An imaginative short letter\",\"postcard_id\":\"contact:default\",\"parcel_id\":\"contact:letter\"}\n".formatted(personaSection, nameRuleSection, languageSection, contextInfo, expressionTechnique, creativityBoost, memoryConstraints, postcardsList, parcelsList, toneInline);
    }

    @Override
    public void recordGeneratedContent(String maidId, String title, String message) {
        String contentSummary = title + ": " + (String)(message.length() > 30 ? message.substring(0, 30) + "..." : message);
        Queue recentContent = RECENT_CONTENT_MEMORY.computeIfAbsent(maidId, k -> new LinkedList());
        recentContent.offer(contentSummary);
        int maxMemorySize = (Integer)AILetterConfig.MEMORY_SIZE.get();
        if (recentContent.size() > maxMemorySize) {
            recentContent.poll();
        }
    }

    @Override
    public void clearMemory(String maidId) {
        RECENT_CONTENT_MEMORY.remove(maidId);
    }

    private String generateContextInfo(EntityMaid maid, ServerPlayer owner) {
        StringBuilder context = new StringBuilder();
        Level level = maid.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LocalDateTime now = this.getMinecraftDateTime(level2);
            String timeDesc = this.getTimeDescription(now);
            context.append("Time: ").append(timeDesc).append(" (").append(now.format(DateTimeFormatter.ofPattern("HH:mm"))).append(")\n");
            try {
                Biome biome = (Biome)level2.getBiome(maid.blockPosition()).value();
                ResourceLocation biomeId = level2.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
                String biomeName = biomeId != null ? biomeId.toString() : "Unknown biome";
                context.append("Environment: ").append(biomeName).append("\n");
            }
            catch (Exception e) {
                context.append("Environment: Unknown biome\n");
            }
            int affection = maid.getFavorability();
            String affectionDesc = affection > 80 ? "very close" : (affection > 60 ? "close" : (affection > 40 ? "friendly" : "normal"));
            context.append("Relationship: ").append(affectionDesc).append(" (favorability ").append(affection).append(")\n");
            String weatherPhrase = this.computeWeatherPhrase(maid);
            String emotion = EnhancedPromptBuilder.randomPick(EnhancedPromptBuilder.getConfiguredOrDefault((List)AILetterConfig.EMOTIONAL_STATES.get(), EMOTIONAL_STATES));
            String template = EnhancedPromptBuilder.randomPick(EnhancedPromptBuilder.getConfiguredOrDefault((List)AILetterConfig.CONTEXT_TEMPLATES.get(), CONTEXT_TEMPLATES));
            context.append("Atmosphere: ").append(String.format(template, weatherPhrase, emotion));
        }
        return context.toString();
    }

    private String getTimeDescription(LocalDateTime dateTime) {
        int hour = dateTime.getHour();
        if (hour <= 4) {
            return "Late night";
        }
        if (hour <= 6) {
            return "Dawn";
        }
        if (hour <= 9) {
            return "Early morning";
        }
        if (hour <= 11) {
            return "Morning";
        }
        if (hour <= 13) {
            return "Noon";
        }
        if (hour <= 16) {
            return "Afternoon";
        }
        if (hour <= 18) {
            return "Evening";
        }
        if (hour <= 20) {
            return "Dusk";
        }
        return "Night";
    }

    private String getRandomExpressionTechnique() {
        return EnhancedPromptBuilder.randomPick(EnhancedPromptBuilder.getConfiguredOrDefault((List)AILetterConfig.EXPRESSION_TECHNIQUES.get(), EXPRESSION_TECHNIQUES));
    }

    private String generateCreativityBoost() {
        List<String> defaults = List.of("Try using metaphor or personification", "Add small details like sounds, scents, and textures", "Describe the same thing from different angles", "Use poetic expressions where suitable", "Create a specific mood or atmosphere", "Add imaginative elements", "Experiment with dialogue or inner monologue", "Use literary rhetorical devices");
        return EnhancedPromptBuilder.randomPick(EnhancedPromptBuilder.getConfiguredOrDefault((List)AILetterConfig.CREATIVITY_TIPS.get(), defaults));
    }

    private static <T> T randomPick(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Random random = new Random();
        return list.get(random.nextInt(list.size()));
    }

    private static List<String> getConfiguredOrDefault(List<? extends String> configured, List<String> defaults) {
        return configured != null && !configured.isEmpty() ? configured.stream().map(String::valueOf).collect(Collectors.toList()) : defaults;
    }

    private String generateMemoryConstraints(String maidId) {
        Queue<String> recentContent = RECENT_CONTENT_MEMORY.get(maidId);
        if (recentContent == null || recentContent.isEmpty()) {
            return "This is the first letter; feel free to be creative.";
        }
        StringBuilder constraints = new StringBuilder("Please avoid the following recently used expressions:\n");
        int count = 0;
        for (String content : recentContent) {
            if (count >= 5) break;
            constraints.append("- ").append(content).append("\n");
            ++count;
        }
        constraints.append("Use a completely different expression and creative angle.");
        return constraints.toString();
    }

    private String resolveClientLanguage(ServerPlayer sp) {
        return EnhancedPromptBuilder.formatLanguageDisplayName(sp.getLanguage());
    }

    private static String formatLanguageDisplayName(String languageTag) {
        if (languageTag == null || ((String)languageTag).isEmpty()) {
            return "\u672a\u77e5\u8bed\u8a00";
        }
        String[] parts = ((String)languageTag).split("_", 2);
        if (parts.length == 2) {
            languageTag = parts[0] + "-" + parts[1].toUpperCase(Locale.ENGLISH);
        }
        Locale locale = Locale.forLanguageTag((String)languageTag);
        return locale.getDisplayLanguage() + (String)(locale.getCountry().isEmpty() ? "" : " (" + locale.getDisplayCountry() + ")");
    }

    private WeatherCategory computeWeatherCategory(EntityMaid maid) {
        Level level = maid.level();
        if (!(level instanceof ServerLevel)) {
            return WeatherCategory.UNKNOWN;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = maid.blockPosition();
        Biome biome = (Biome)level2.getBiome(pos).value();
        if (level2.isThundering()) {
            return WeatherCategory.THUNDER;
        }
        boolean rainingHere = level2.isRainingAt(pos);
        if (rainingHere) {
            if (biome.getPrecipitationAt(pos) == Biome.Precipitation.SNOW || biome.coldEnoughToSnow(pos)) {
                return WeatherCategory.SNOW;
            }
            return WeatherCategory.RAIN;
        }
        if (level2.isRaining()) {
            if (biome.getPrecipitationAt(pos) == Biome.Precipitation.SNOW) {
                return WeatherCategory.SNOW;
            }
            if (biome.getPrecipitationAt(pos) == Biome.Precipitation.RAIN) {
                return WeatherCategory.CLOUDY;
            }
            return WeatherCategory.CLOUDY;
        }
        return WeatherCategory.CLEAR;
    }

    private String computeWeatherPhrase(EntityMaid maid) {
        WeatherCategory category = this.computeWeatherCategory(maid);
        boolean night = false;
        Level level = maid.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            night = level2.isNight();
        }
        List<String> configured = EnhancedPromptBuilder.getConfiguredOrDefault((List)AILetterConfig.WEATHER_DESCRIPTIONS.get(), WEATHER_DESCRIPTIONS);
        ArrayList<String> filtered = new ArrayList<String>();
        block7: for (String w : configured) {
            switch (category.ordinal()) {
                case 0: {
                    if (!this.containsAny(w, "thunder", "storm", "cloud", "wind", "rain")) continue block7;
                    filtered.add(w);
                    continue block7;
                }
                case 1: {
                    if (!this.containsAny(w, "rain", "drizzle", "cloud", "wind", "dew")) continue block7;
                    filtered.add(w);
                    continue block7;
                }
                case 2: {
                    if (!this.containsAny(w, "snow", "frost", "cloud", "wind")) continue block7;
                    filtered.add(w);
                    continue block7;
                }
                case 3: {
                    if (!this.containsAny(w, "cloud", "mist", "wind")) continue block7;
                    filtered.add(w);
                    continue block7;
                }
                case 4: {
                    if (night) {
                        if (!this.containsAny(w, "moon", "star", "wind", "dew", "cloud")) continue block7;
                        filtered.add(w);
                        continue block7;
                    }
                    if (!this.containsAny(w, "sun", "wind", "cloud", "dew")) continue block7;
                    filtered.add(w);
                    continue block7;
                }
            }
            if (!this.containsAny(w, "wind", "cloud", "dew", "sun", "moon", "star", "rain", "snow")) continue;
            filtered.add(w);
        }
        List<String> picks = this.randomPickMany(filtered.isEmpty() ? configured : filtered, 2);
        if (picks.isEmpty()) {
            return night ? "moonlight and breeze" : "sunshine and breeze";
        }
        if (picks.size() == 1) {
            return picks.getFirst();
        }
        return picks.get(0) + " and " + picks.get(1);
    }

    private boolean containsAny(String s, String ... keys) {
        for (String k : keys) {
            if (!s.contains(k)) continue;
            return true;
        }
        return false;
    }

    private List<String> randomPickMany(List<String> list, int count) {
        if (list == null || list.isEmpty() || count <= 0) {
            return List.of();
        }
        ArrayList<String> copy = new ArrayList<String>(list);
        Collections.shuffle(copy, new Random());
        int n = Math.min(count, copy.size());
        return copy.subList(0, n);
    }

    private LocalDateTime getMinecraftDateTime(ServerLevel level) {
        long dayTime = level.getDayTime() % 24000L;
        int hour = (int)((dayTime / 1000L + 6L) % 24L);
        int minute = (int)(dayTime % 1000L * 60L / 1000L);
        return LocalDateTime.of(2024, 1, 1, hour, minute);
    }

    private static enum WeatherCategory {
        THUNDER,
        RAIN,
        SNOW,
        CLOUDY,
        CLEAR,
        UNKNOWN;

    }
}

