/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AILetterConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final double DEFAULT_CREATIVITY_TEMPERATURE_BOOST = 0.3;
    public static final int DEFAULT_MEMORY_SIZE = 10;
    public static final boolean DEFAULT_ENABLE_CONTEXT_ENRICHMENT = true;
    public static final boolean DEFAULT_ENABLE_QUALITY_FILTER = true;
    public static final boolean DEFAULT_ENABLE_CUSTOM_PERSONA = true;
    public static final int DEFAULT_MIN_CONTENT_LENGTH = 10;
    public static final int DEFAULT_MAX_GENERIC_PHRASES = 2;
    public static final ModConfigSpec.DoubleValue CREATIVITY_TEMPERATURE_BOOST;
    public static final ModConfigSpec.IntValue MEMORY_SIZE;
    public static final ModConfigSpec.BooleanValue ENABLE_CONTEXT_ENRICHMENT;
    public static final ModConfigSpec.BooleanValue ENABLE_QUALITY_FILTER;
    public static final ModConfigSpec.IntValue MIN_CONTENT_LENGTH;
    public static final ModConfigSpec.IntValue MAX_GENERIC_PHRASES;
    public static final ModConfigSpec.BooleanValue ENABLE_CUSTOM_PERSONA;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> EXPRESSION_TECHNIQUES;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CONTEXT_TEMPLATES;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> TIME_DESCRIPTIONS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> WEATHER_DESCRIPTIONS;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> EMOTIONAL_STATES;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CREATIVITY_TIPS;
    private static final String TRANSLATE_KEY = "config.touhou_little_maid_epistalove.ai_letter";

    private static String translateKey(String key) {
        return "config.touhou_little_maid_epistalove.ai_letter." + key;
    }

    static {
        BUILDER.translation(TRANSLATE_KEY).push("ai_letter_generation");
        CREATIVITY_TEMPERATURE_BOOST = BUILDER.comment("Extra creativity temperature applied when generating letters (0.0\u20130.5, higher = more creative)").translation(AILetterConfig.translateKey("creativity_temperature_boost")).defineInRange("creativity_temperature_boost", 0.3, 0.0, 0.5);
        MEMORY_SIZE = BUILDER.comment("Number of recent letters kept in memory to avoid repeated content").translation(AILetterConfig.translateKey("memory_size")).defineInRange("memory_size", 10, 5, 50);
        ENABLE_CONTEXT_ENRICHMENT = BUILDER.comment("Whether to enable context enrichment (inject dynamic info like time, environment, maid status)").translation(AILetterConfig.translateKey("enable_context_enrichment")).define("enable_context_enrichment", true);
        ENABLE_QUALITY_FILTER = BUILDER.comment("Whether to enable the quality filter to block low-quality or inappropriate content").translation(AILetterConfig.translateKey("enable_quality_filter")).define("enable_quality_filter", true);
        ENABLE_CUSTOM_PERSONA = BUILDER.comment("Inject maid's custom persona from AI chat settings into the system prompt").translation(AILetterConfig.translateKey("enable_custom_persona")).define("enable_custom_persona", true);
        MIN_CONTENT_LENGTH = BUILDER.comment("Minimum length of generated letter content (characters) to avoid being too short").translation(AILetterConfig.translateKey("min_content_length")).defineInRange("min_content_length", 10, 5, 50);
        MAX_GENERIC_PHRASES = BUILDER.comment("Maximum number of generic phrases allowed per letter; exceeding marks content as low quality").translation(AILetterConfig.translateKey("max_generic_phrases")).defineInRange("max_generic_phrases", 2, 0, 5);
        EXPRESSION_TECHNIQUES = BUILDER.comment("List of expression techniques used to diversify style").translation(AILetterConfig.translateKey("expression_techniques")).defineListAllowEmpty("expression_techniques", List.of("\u8fd0\u7528\u751f\u52a8\u7684\u7ec6\u8282\u63cf\u5199", "\u52a0\u5165\u611f\u5b98\u4f53\u9a8c\u7684\u63cf\u8ff0", "\u4f7f\u7528\u6bd4\u55bb\u548c\u62df\u4eba\u624b\u6cd5", "\u8425\u9020\u7279\u5b9a\u7684\u6c1b\u56f4\u611f", "\u8fd0\u7528\u5bf9\u6bd4\u548c\u5c42\u6b21\u611f", "\u52a0\u5165\u52a8\u4f5c\u548c\u573a\u666f\u63cf\u5199", "\u4f7f\u7528\u5bcc\u6709\u753b\u9762\u611f\u7684\u8bcd\u6c47", "\u521b\u9020\u72ec\u7279\u7684\u8868\u8fbe\u89d2\u5ea6"), o -> o instanceof String);
        CONTEXT_TEMPLATES = BUILDER.comment("Context templates; should contain two %s placeholders for weather and emotion").translation(AILetterConfig.translateKey("context_templates")).defineListAllowEmpty("context_templates", List.of("\u5728\u8fd9\u4e2a%s\u7684%s\uff0c", "\u5f53%s\u8f7b\u629a\u8fc7\u7a97\u53f0\u65f6\uff0c", "\u5728%s\u7684\u966a\u4f34\u4e0b\uff0c", "\u671b\u7740%s\u7684\u5929\u7a7a\uff0c", "\u542c\u7740%s\u7684\u58f0\u97f3\uff0c", "\u611f\u53d7\u7740%s\u7684\u6c14\u606f\uff0c", "\u5728\u8fd9\u4e2a\u7279\u522b\u7684\u65f6\u523b\uff0c", "\u4f34\u968f\u7740%s\u7684\u5fc3\u60c5\uff0c"), o -> o instanceof String);
        TIME_DESCRIPTIONS = BUILDER.comment("Time descriptions for dynamic context").translation(AILetterConfig.translateKey("time_descriptions")).defineListAllowEmpty("time_descriptions", List.of("\u6e05\u6668", "\u5348\u540e", "\u9ec4\u660f", "\u591c\u665a", "\u6df1\u591c", "\u9ece\u660e", "\u6b63\u5348", "\u508d\u665a"), o -> o instanceof String);
        WEATHER_DESCRIPTIONS = BUILDER.comment("Weather descriptors for dynamic context").translation(AILetterConfig.translateKey("weather_descriptions")).defineListAllowEmpty("weather_descriptions", List.of("\u5fae\u98ce", "\u7ec6\u96e8", "\u9633\u5149", "\u6708\u5149", "\u661f\u5149", "\u96ea\u82b1", "\u4e91\u6735", "\u6668\u9732"), o -> o instanceof String);
        EMOTIONAL_STATES = BUILDER.comment("Emotion descriptors for dynamic context").translation(AILetterConfig.translateKey("emotional_states")).defineListAllowEmpty("emotional_states", List.of("\u6e29\u67d4", "\u6b23\u559c", "\u5b81\u9759", "\u671f\u5f85", "\u601d\u5ff5", "\u6ee1\u8db3", "\u597d\u5947", "\u5173\u6000"), o -> o instanceof String);
        CREATIVITY_TIPS = BUILDER.comment("Creativity tips to enrich wording variety").translation(AILetterConfig.translateKey("creativity_tips")).defineListAllowEmpty("creativity_tips", List.of("\u5c1d\u8bd5\u4f7f\u7528\u6bd4\u55bb\u6216\u62df\u4eba\u7684\u624b\u6cd5", "\u53ef\u4ee5\u52a0\u5165\u4e00\u4e9b\u5c0f\u7ec6\u8282\uff0c\u6bd4\u5982\u58f0\u97f3\u3001\u6c14\u5473\u3001\u89e6\u611f\u7b49", "\u8bd5\u7740\u4ece\u4e0d\u540c\u7684\u89d2\u5ea6\u6765\u63cf\u8ff0\u540c\u4e00\u4ef6\u4e8b", "\u53ef\u4ee5\u4f7f\u7528\u4e00\u4e9b\u8bd7\u610f\u7684\u8868\u8fbe", "\u5c1d\u8bd5\u8425\u9020\u7279\u5b9a\u7684\u6c1b\u56f4\u6216\u60c5\u7eea", "\u53ef\u4ee5\u52a0\u5165\u4e00\u4e9b\u60f3\u8c61\u529b\u4e30\u5bcc\u7684\u5143\u7d20", "\u8bd5\u7740\u7528\u5bf9\u8bdd\u6216\u5185\u5fc3\u72ec\u767d\u7684\u5f62\u5f0f", "\u53ef\u4ee5\u4f7f\u7528\u4e00\u4e9b\u6587\u5b66\u6027\u7684\u4fee\u8f9e\u624b\u6cd5"), o -> o instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

