/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.data;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.sighs.touhou_little_maid_epistalove.ai.generator.AILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.ai.generator.PresetLetterGenerator;
import com.sighs.touhou_little_maid_epistalove.ai.parser.JsonLetterParser;
import com.sighs.touhou_little_maid_epistalove.ai.prompt.EnhancedPromptBuilder;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.api.trigger.ITriggerManager;
import com.sighs.touhou_little_maid_epistalove.data.MaidLetterRule;
import com.sighs.touhou_little_maid_epistalove.trigger.TriggerManager;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DataPackLetterRuleAdapter
implements ILetterRule {
    private final MaidLetterRule dataPackRule;
    private final ILetterGenerator generator;
    private static final ITriggerManager TRIGGER_MANAGER = TriggerManager.getInstance();
    private static final EnhancedPromptBuilder PROMPT_BUILDER = new EnhancedPromptBuilder();
    private static final JsonLetterParser LETTER_PARSER = new JsonLetterParser(PROMPT_BUILDER);

    public DataPackLetterRuleAdapter(MaidLetterRule dataPackRule) {
        this.dataPackRule = dataPackRule;
        this.generator = this.createGenerator();
    }

    @Override
    public String getId() {
        return this.dataPackRule.id();
    }

    @Override
    public int getMinAffection() {
        return this.dataPackRule.minAffection();
    }

    @Override
    public Integer getMaxAffection() {
        return this.dataPackRule.maxAffection().orElse(null);
    }

    @Override
    public List<ResourceLocation> getTriggers() {
        return this.dataPackRule.triggers();
    }

    @Override
    public ILetterRule.TriggerType getTriggerType() {
        return this.dataPackRule.triggerType() == MaidLetterRule.TriggerType.ONCE ? ILetterRule.TriggerType.ONCE : ILetterRule.TriggerType.REPEAT;
    }

    @Override
    public Integer getCooldown() {
        return this.dataPackRule.cooldown().orElse(null);
    }

    @Override
    public Integer getFavorabilityChange() {
        return this.dataPackRule.favorabilityChange().orElse(null);
    }

    @Override
    public Integer getFavorabilityThreshold() {
        return this.dataPackRule.favorabilityThreshold().orElse(null);
    }

    @Override
    public boolean matches(ServerPlayer owner, EntityMaid maid, long gameTime) {
        int affection = maid.getFavorability();
        if (affection < this.getMinAffection()) {
            return false;
        }
        if (this.getMaxAffection() != null && affection > this.getMaxAffection()) {
            return false;
        }
        List<ResourceLocation> required = this.getRequiredMaidIds();
        if (required != null && !required.isEmpty()) {
            ResourceLocation maidModel;
            String modelIdStr = maid.getModelId();
            ResourceLocation resourceLocation = maidModel = !modelIdStr.isEmpty() ? ResourceLocation.parse((String)modelIdStr) : null;
            if (maidModel == null || !required.contains(maidModel)) {
                return false;
            }
        }
        return this.hasAnyTrigger(owner);
    }

    @Override
    public List<ResourceLocation> getRequiredMaidIds() {
        return this.dataPackRule.maidIds().orElse(null);
    }

    @Override
    public void generateLetter(ServerPlayer owner, EntityMaid maid, Consumer<ItemStack> callback) {
        CompoundTag ctx = null;
        for (ResourceLocation tid : this.getTriggers()) {
            if (!TRIGGER_MANAGER.hasTriggered(owner, tid)) continue;
            ctx = TRIGGER_MANAGER.getTriggerContext(owner, tid);
            break;
        }
        this.generator.generateWithContext(owner, maid, ctx, callback);
    }

    @Override
    public String getType() {
        return this.generator.getType();
    }

    private ILetterGenerator createGenerator() {
        switch (this.dataPackRule.type()) {
            case AI: {
                MaidLetterRule.AI ai = this.dataPackRule.ai().orElseThrow(() -> new IllegalStateException("AI rule must have AI configuration"));
                return new AILetterGenerator(ai.tone().orElse("sweet"), ai.prompt(), PROMPT_BUILDER, LETTER_PARSER);
            }
            case PRESET: {
                MaidLetterRule.Preset preset = this.dataPackRule.preset().orElseThrow(() -> new IllegalStateException("Preset rule must have preset configuration"));
                if (preset.gifts().isEmpty()) {
                    throw new IllegalStateException("Preset rule must have at least one gift");
                }
                MaidLetterRule.Gift gift = preset.gifts().get(0);
                return new PresetLetterGenerator(preset.title(), preset.message(), gift.postcard(), gift.parcel());
            }
        }
        throw new IllegalStateException("Unknown rule type: " + String.valueOf((Object)this.dataPackRule.type()));
    }

    private boolean hasAnyTrigger(ServerPlayer owner) {
        MinecraftServer server = owner.getServer();
        if (server == null) {
            return false;
        }
        for (ResourceLocation triggerId : this.getTriggers()) {
            AdvancementHolder advancement = server.getAdvancements().get(triggerId);
            if (advancement != null) {
                if (!TRIGGER_MANAGER.hasTriggered(owner, triggerId)) continue;
                return true;
            }
            boolean active = TRIGGER_MANAGER.hasTriggered(owner, triggerId);
            if (!active) continue;
            ResourceLocation consumeKey = ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + this.getId() + "_" + triggerId.toString().replace(":", "_")));
            if (this.getTriggerType() == ILetterRule.TriggerType.ONCE && TRIGGER_MANAGER.hasConsumedOnce(owner, consumeKey)) continue;
            return true;
        }
        return false;
    }

    public void consumeTriggers(ServerPlayer owner) {
        MinecraftServer server = owner.getServer();
        for (ResourceLocation triggerId : this.getTriggers()) {
            AdvancementHolder advancement;
            AdvancementHolder advancementHolder = advancement = server != null ? server.getAdvancements().get(triggerId) : null;
            if (advancement != null) {
                TRIGGER_MANAGER.clearTriggered(owner, triggerId);
                continue;
            }
            if (!TRIGGER_MANAGER.hasTriggered(owner, triggerId)) continue;
            if (this.getTriggerType() == ILetterRule.TriggerType.ONCE) {
                ResourceLocation consumeKey = ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + this.getId() + "_" + triggerId.toString().replace(":", "_")));
                TRIGGER_MANAGER.markConsumedOnce(owner, consumeKey);
                TRIGGER_MANAGER.clearTriggered(owner, triggerId);
                continue;
            }
            TRIGGER_MANAGER.clearTriggered(owner, triggerId);
        }
    }
}

