/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.data;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.api.trigger.ITriggerManager;
import com.sighs.touhou_little_maid_epistalove.trigger.TriggerManager;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class LetterRule
implements ILetterRule {
    private final String id;
    private final int minAffection;
    private final Integer maxAffection;
    private final List<ResourceLocation> triggers;
    private final ILetterRule.TriggerType triggerType;
    private final Integer cooldown;
    private final Integer favorabilityChange;
    private final Integer favorabilityThreshold;
    private final ILetterGenerator generator;
    private final List<ResourceLocation> requiredMaidIds;
    private static final ITriggerManager TRIGGER_MANAGER = TriggerManager.getInstance();

    public LetterRule(String id, int minAffection, Integer maxAffection, List<ResourceLocation> triggers, ILetterRule.TriggerType triggerType, Integer cooldown, Integer favorabilityChange, Integer favorabilityThreshold, ILetterGenerator generator, List<ResourceLocation> requiredMaidIds) {
        this.id = id;
        this.minAffection = minAffection;
        this.maxAffection = maxAffection;
        this.triggers = triggers;
        this.triggerType = triggerType;
        this.cooldown = cooldown;
        this.favorabilityChange = favorabilityChange;
        this.favorabilityThreshold = favorabilityThreshold;
        this.generator = generator;
        this.requiredMaidIds = requiredMaidIds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMinAffection() {
        return this.minAffection;
    }

    @Override
    public Integer getMaxAffection() {
        return this.maxAffection;
    }

    @Override
    public List<ResourceLocation> getTriggers() {
        return this.triggers;
    }

    @Override
    public ILetterRule.TriggerType getTriggerType() {
        return this.triggerType;
    }

    @Override
    public Integer getCooldown() {
        return this.cooldown;
    }

    @Override
    public Integer getFavorabilityChange() {
        return this.favorabilityChange;
    }

    @Override
    public Integer getFavorabilityThreshold() {
        return this.favorabilityThreshold;
    }

    @Override
    public boolean matches(ServerPlayer owner, EntityMaid maid, long gameTime) {
        int affection = maid.getFavorability();
        if (affection < this.minAffection) {
            return false;
        }
        if (this.maxAffection != null && affection > this.maxAffection) {
            return false;
        }
        if (this.requiredMaidIds != null && !this.requiredMaidIds.isEmpty()) {
            ResourceLocation maidModel;
            String modelIdStr = maid.getModelId();
            ResourceLocation resourceLocation = maidModel = !modelIdStr.isEmpty() ? ResourceLocation.parse((String)modelIdStr) : null;
            if (maidModel == null || !this.requiredMaidIds.contains(maidModel)) {
                return false;
            }
        }
        return this.hasAnyTrigger(owner);
    }

    @Override
    public List<ResourceLocation> getRequiredMaidIds() {
        return this.requiredMaidIds;
    }

    @Override
    public void generateLetter(ServerPlayer owner, EntityMaid maid, Consumer<ItemStack> callback) {
        CompoundTag ctx = null;
        for (ResourceLocation tid : this.triggers) {
            if (!TRIGGER_MANAGER.hasTriggered(owner, tid)) continue;
            ctx = TRIGGER_MANAGER.getTriggerContext(owner, tid);
            break;
        }
        this.generator.generateWithContext(owner, maid, ctx, callback);
    }

    @Override
    public String getType() {
        return this.generator.getType();
    }

    private boolean hasAnyTrigger(ServerPlayer owner) {
        MinecraftServer server = owner.getServer();
        if (server == null) {
            return false;
        }
        for (ResourceLocation triggerId : this.triggers) {
            AdvancementHolder advancement = server.getAdvancements().get(triggerId);
            if (advancement != null) {
                if (!TRIGGER_MANAGER.hasTriggered(owner, triggerId)) continue;
                return true;
            }
            boolean active = TRIGGER_MANAGER.hasTriggered(owner, triggerId);
            if (!active) continue;
            ResourceLocation consumeKey = ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + this.id + "_" + triggerId.toString().replace(":", "_")));
            if (this.triggerType == ILetterRule.TriggerType.ONCE && TRIGGER_MANAGER.hasConsumedOnce(owner, consumeKey)) continue;
            return true;
        }
        return false;
    }

    public void consumeTriggers(ServerPlayer owner) {
        MinecraftServer server = owner.getServer();
        for (ResourceLocation triggerId : this.triggers) {
            AdvancementHolder advancement;
            AdvancementHolder advancementHolder = advancement = server != null ? server.getAdvancements().get(triggerId) : null;
            if (advancement != null) {
                TRIGGER_MANAGER.clearTriggered(owner, triggerId);
                continue;
            }
            if (!TRIGGER_MANAGER.hasTriggered(owner, triggerId)) continue;
            if (this.triggerType == ILetterRule.TriggerType.ONCE) {
                ResourceLocation consumeKey = ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + this.id + "_" + triggerId.toString().replace(":", "_")));
                TRIGGER_MANAGER.markConsumedOnce(owner, consumeKey);
                TRIGGER_MANAGER.clearTriggered(owner, triggerId);
                continue;
            }
            TRIGGER_MANAGER.clearTriggered(owner, triggerId);
        }
    }
}

