/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.data;

import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.data.PostcardDataManager;
import com.mafuyu404.oelib.api.data.DataValidator;
import com.sighs.touhou_little_maid_epistalove.data.MaidLetterRule;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class MaidLetterValidator
implements DataValidator<MaidLetterRule> {
    public DataValidator.ValidationResult validate(MaidLetterRule rule, ResourceLocation source) {
        int thr;
        if (rule.id() == null || rule.id().isBlank()) {
            return DataValidator.ValidationResult.failure((String)"id is empty");
        }
        if (rule.triggers() == null || rule.triggers().isEmpty()) {
            return DataValidator.ValidationResult.failure((String)"triggers are empty");
        }
        if (rule.type() == MaidLetterRule.Type.PRESET) {
            if (rule.preset().isEmpty()) {
                return DataValidator.ValidationResult.failure((String)"preset block missing when type = preset");
            }
            MaidLetterRule.Preset p = rule.preset().get();
            if (p.gifts() == null || p.gifts().isEmpty()) {
                return DataValidator.ValidationResult.failure((String)"gifts must contain exactly one entry");
            }
            if (p.gifts().size() != 1) {
                return DataValidator.ValidationResult.failure((String)"gifts must be size 1");
            }
            MaidLetterRule.Gift gift = p.gifts().getFirst();
            Item item = (Item)BuiltInRegistries.ITEM.get(gift.parcel());
            if (!(item instanceof IPackageItem)) {
                return DataValidator.ValidationResult.failure((String)("Parcel item must implement IPackageItem: " + String.valueOf(gift.parcel())));
            }
            if (!PostcardDataManager.getPostcards().containsKey(gift.postcard())) {
                return DataValidator.ValidationResult.failure((String)("Postcard id not exists: " + String.valueOf(gift.postcard())));
            }
        } else {
            if (rule.ai().isEmpty()) {
                return DataValidator.ValidationResult.failure((String)"ai block missing when type = ai");
            }
            if (rule.ai().get().prompt() == null || rule.ai().get().prompt().isBlank()) {
                return DataValidator.ValidationResult.failure((String)"ai.prompt is empty");
            }
        }
        for (ResourceLocation rl : rule.triggers()) {
            if (!rl.getNamespace().isBlank() && !rl.getPath().isBlank()) continue;
            return DataValidator.ValidationResult.failure((String)("Invalid trigger id: " + String.valueOf(rl)));
        }
        if (rule.maidIds().isPresent()) {
            for (ResourceLocation rl : rule.maidIds().get()) {
                if (!rl.getNamespace().isBlank() && !rl.getPath().isBlank()) continue;
                return DataValidator.ValidationResult.failure((String)("Invalid model_id: " + String.valueOf(rl)));
            }
        }
        if (rule.favorabilityThreshold().isPresent() && (thr = rule.favorabilityThreshold().get().intValue()) < 0) {
            return DataValidator.ValidationResult.failure((String)"favorability_threshold must be >= 0");
        }
        return DataValidator.ValidationResult.success();
    }
}

